/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyStorageUtils;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00160\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010$\u00a8\u0006+"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEEnergyStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "Lappeng/api/networking/energy/IEnergyService;", "energyService", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "entity", "<init>", "(Lappeng/api/networking/energy/IEnergyService;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "", "setChanged", "()V", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "stack", "", "simulate", "store", "(Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;Z)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "", "getContent", "()Ljava/util/Iterator;", "Ljava/util/function/Predicate;", "predicate", "", "limit", "take", "(Ljava/util/function/Predicate;JZ)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Lappeng/api/networking/energy/IEnergyService;", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "getMaxStackSize", "()Ljava/lang/Long;", "maxStackSize", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "operator", "getCanExtract", "()Z", "canExtract", "getFirstEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "firstEnergy", "getCanReceive", "canReceive", "peripheralworks-fabric-1.20.1"})
public final class AEEnergyStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final IEnergyService energyService;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEEnergyStorage(@NotNull IEnergyService energyService, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)energyService, (String)"energyService");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.energyService = energyService;
        this.entity = entity;
    }

    @NotNull
    public Long getMaxStackSize() {
        return (long)this.energyService.getMaxStoredPower();
    }

    @NotNull
    public SomethingOperator<AgnosticEnergyStack, Long> getOperator() {
        return (SomethingOperator)EnergyStorageUtils.INSTANCE;
    }

    public boolean getCanExtract() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack getFirstEnergy() {
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)this.energyService.getStoredPower());
    }

    public void setChanged() {
        this.entity.method_5431();
    }

    public boolean getCanReceive() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack store(@NotNull AgnosticEnergyStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)Energies.INSTANCE.getREDSTONE_FLUX())) {
            return stack;
        }
        double leftover = this.energyService.injectPower((double)stack.getAmount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return stack.copyWithCount((long)leftover);
    }

    @NotNull
    public Iterator<AgnosticEnergyStack> getContent() {
        return CollectionsKt.listOf((Object)this.getFirstEnergy()).iterator();
    }

    @NotNull
    public AgnosticEnergyStack take(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getFirstEnergy())) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        double extracted = this.energyService.extractAEPower((double)limit, simulate ? Actionable.SIMULATE : Actionable.MODULATE, PowerMultiplier.CONFIG);
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)extracted);
    }
}

