/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralHubPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J+\u0010\u0017\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\f2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0017J\b\u0010\u001f\u001a\u00020\fH\u0017J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\"0!H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper;", "O", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "record", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "peripheralHubPeripheral", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "<init>", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;)V", "mount", "", "desiredLocation", "Ldan200/computercraft/api/filesystem/Mount;", "driveName", "mountWritable", "Ldan200/computercraft/api/filesystem/WritableMount;", "unmount", "", "location", "getID", "", "queueEvent", "event", "arguments", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "getMainThreadMonitor", "Ldan200/computercraft/api/peripheral/WorkMonitor;", "getAttachmentName", "getAvailablePeripherals", "", "Ldan200/computercraft/api/peripheral/IPeripheral;", "getAvailablePeripheral", "name", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteComputerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1187#2,2:64\n1261#2,4:66\n*S KotlinDebug\n*F\n+ 1 RemoteComputerWrapper.kt\nsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper\n*L\n50#1:64,2\n50#1:66,4\n*E\n"})
public final class RemoteComputerWrapper<O extends IPeripheralOwner>
implements IComputerAccess {
    @NotNull
    private final IComputerAccess computer;
    @NotNull
    private final PeripheralRecord<O> record;
    @NotNull
    private final PeripheralHubPeripheral<O> peripheralHubPeripheral;

    public RemoteComputerWrapper(@NotNull IComputerAccess computer, @NotNull PeripheralRecord<O> record, @NotNull PeripheralHubPeripheral<O> peripheralHubPeripheral) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter(peripheralHubPeripheral, (String)"peripheralHubPeripheral");
        this.computer = computer;
        this.record = record;
        this.peripheralHubPeripheral = peripheralHubPeripheral;
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mount(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mount(@NotNull String desiredLocation, @NotNull Mount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mount(desiredLocation, mount, driveName);
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        return this.computer.mountWritable(desiredLocation, mount, this.record.getName());
    }

    @Nullable
    public String mountWritable(@NotNull String desiredLocation, @NotNull WritableMount mount, @NotNull String driveName) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)mount, (String)"mount");
        Intrinsics.checkNotNullParameter((Object)driveName, (String)"driveName");
        return this.computer.mountWritable(desiredLocation, mount, driveName);
    }

    public void unmount(@Nullable String location) {
        this.computer.unmount(location);
    }

    public int getID() {
        return this.computer.getID();
    }

    public void queueEvent(@Nonnull @NotNull String event, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.computer.queueEvent(event, Arrays.copyOf(arguments, arguments.length));
    }

    @Nonnull
    @NotNull
    public WorkMonitor getMainThreadMonitor() {
        WorkMonitor workMonitor = this.computer.getMainThreadMonitor();
        Intrinsics.checkNotNullExpressionValue((Object)workMonitor, (String)"getMainThreadMonitor(...)");
        return workMonitor;
    }

    @Nonnull
    @NotNull
    public String getAttachmentName() {
        return this.record.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, IPeripheral> getAvailablePeripherals() {
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralHubPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Iterable $this$associate$iv = this.peripheralHubPeripheral.getPeripheralsRecord().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), (Object)((PeripheralRecord)it.getValue()).getPeripheral());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IPeripheral getAvailablePeripheral(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralHubPeripheral.getPeripheralsRecord();
        synchronized (concurrentMap) {
            PeripheralRecord peripheralRecord;
            block4: {
                boolean bl = false;
                if ((PeripheralRecord)this.peripheralHubPeripheral.getPeripheralsRecord().get(name) != null) break block4;
                IPeripheral iPeripheral = null;
                return iPeripheral;
            }
            PeripheralRecord record = peripheralRecord;
            IPeripheral iPeripheral = record.getPeripheral();
            return iPeripheral;
        }
    }
}

