/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.plugins.PeripheralPluginUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f0\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/BeaconPlugin;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "target", "Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;", "<init>", "(Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V", "getLevel", "", "getPossiblePowers", "", "", "getPowers", "", "", "configure", "Ldan200/computercraft/api/lua/MethodResult;", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nBeaconPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeaconPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/BeaconPlugin\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n13346#2,2:124\n1#3:126\n*S KotlinDebug\n*F\n+ 1 BeaconPlugin.kt\nsite/siredvin/peripheralworks/computercraft/plugins/specific/BeaconPlugin\n*L\n31#1:124,2\n*E\n"})
public final class BeaconPlugin
implements IPeripheralPlugin {
    @NotNull
    private final BeaconBlockEntity target;

    public BeaconPlugin(@NotNull BeaconBlockEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @LuaFunction(mainThread=true)
    public final int getLevel() {
        return this.target.f_58650_;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> getPossiblePowers() {
        List powers = new ArrayList();
        int i = 0;
        int n = Math.min(this.target.f_58650_ - 1, 2);
        if (i <= n) {
            while (true) {
                MobEffect[] mobEffectArray = BeaconBlockEntity.f_58646_[i];
                Intrinsics.checkNotNullExpressionValue((Object)mobEffectArray, (String)"get(...)");
                Object[] $this$forEach$iv = mobEffectArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MobEffect it = (MobEffect)element$iv;
                    boolean bl = false;
                    String string = it.m_19481_();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptionId(...)");
                    powers.add(LuaRepresentation.INSTANCE.fromLegacyToNewID(string));
                }
                if (i == n) break;
                ++i;
            }
        }
        return powers;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> getPowers() {
        int effectTime = (9 + this.target.f_58650_ * 2) * 20;
        if (this.target.f_58652_ == null) {
            return CollectionsKt.emptyList();
        }
        List effects = new ArrayList();
        MobEffect mobEffect = this.target.f_58652_;
        Intrinsics.checkNotNull((Object)mobEffect);
        effects.add(LuaRepresentation.INSTANCE.forMobEffectInstance(new MobEffectInstance(mobEffect, effectTime, Intrinsics.areEqual((Object)this.target.f_58653_, (Object)this.target.f_58652_) ? 1 : 0, true, true)));
        if (this.target.f_58653_ != null && !Intrinsics.areEqual((Object)this.target.f_58653_, (Object)this.target.f_58652_)) {
            MobEffect mobEffect2 = this.target.f_58653_;
            Intrinsics.checkNotNull((Object)mobEffect2);
            effects.add(LuaRepresentation.INSTANCE.forMobEffectInstance(new MobEffectInstance(mobEffect2, effectTime, 0, true, true)));
        }
        return effects;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult configure(@NotNull IComputerAccess computer, @NotNull IArguments arguments) {
        ItemStack extractedStack;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String primaryPower = arguments.getString(0);
        String fromName = arguments.getString(1);
        Object itemQuery = arguments.get(2);
        boolean regenerationSecondary = arguments.optBoolean(3, false);
        MobEffect primaryEffect = null;
        int i = 0;
        int n = Math.min(this.target.f_58650_ - 1, 2);
        if (i <= n) {
            while (true) {
                Object object;
                block9: {
                    MobEffect[] mobEffectArray = BeaconBlockEntity.f_58646_[i];
                    Intrinsics.checkNotNullExpressionValue((Object)mobEffectArray, (String)"get(...)");
                    for (Object object2 : (Object[])mobEffectArray) {
                        MobEffect it = (MobEffect)object2;
                        boolean bl = false;
                        String string = it.m_19481_();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptionId(...)");
                        if (!Intrinsics.areEqual((Object)LuaRepresentation.INSTANCE.fromLegacyToNewID(string), (Object)primaryPower)) continue;
                        object = object2;
                        break block9;
                    }
                    object = null;
                }
                primaryEffect = (MobEffect)object;
                if (primaryEffect != null || i == n) break;
                ++i;
            }
        }
        if (primaryEffect == null) {
            Object[] objectArray = new Object[]{null, "Cannot find desired effect in list of available effects"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Level level = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        AgnosticItemStorage agnosticItemStorage = AgnosticItemStorageLookup.INSTANCE.extractStorageFromUnknown(level, location.getTarget());
        if (agnosticItemStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an item inventory");
        }
        AgnosticItemStorage fromStorage = agnosticItemStorage;
        Predicate<ItemStack> predicate = BeaconPlugin::configure$lambda$1;
        if (itemQuery != null) {
            Predicate<ItemStack> predicate2 = predicate.and(PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery));
            Intrinsics.checkNotNullExpressionValue(predicate2, (String)"and(...)");
            predicate = predicate2;
        }
        if ((extractedStack = fromStorage.takeItems(predicate, 1)).m_41619_()) {
            Object[] objectArray = new Object[]{null, "Target storage cannot provide desired items"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        this.target.f_58652_ = primaryEffect;
        if (this.target.f_58650_ == 4) {
            this.target.f_58653_ = regenerationSecondary ? MobEffects.f_19605_ : primaryEffect;
        }
        Level level2 = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level2);
        level2.m_151543_(this.target.m_58899_());
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final boolean configure$lambda$1(ItemStack it) {
        return it.m_204117_(ItemTags.f_13164_);
    }
}

