/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.occultism;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.platform.api.RegistryWrapper;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.integrations.occultism.OccultismItemStorage;
import site.siredvin.tweakium.modules.plugins.AbstractItemStoragePlugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\b\u0010\u0013\u001a\u00020\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStoragePlugin;", "Lsite/siredvin/tweakium/modules/plugins/AbstractItemStoragePlugin;", "storageController", "Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;Lnet/minecraft/world/level/Level;)V", "getLevel", "()Lnet/minecraft/world/level/Level;", "storage", "Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStorage;", "getStorage", "()Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStorage;", "itemStorageTransferLimit", "", "getItemStorageTransferLimit", "()I", "getMaxSlots", "getUsedSlots", "isBlacklisted", "", "item", "", "peripheralworks-forge-1.20.1"})
public final class OccultismItemStoragePlugin
extends AbstractItemStoragePlugin {
    @NotNull
    private final IStorageController storageController;
    @NotNull
    private final Level level;
    @NotNull
    private final OccultismItemStorage storage;

    public OccultismItemStoragePlugin(@NotNull IStorageController storageController, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)storageController, (String)"storageController");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.storageController = storageController;
        this.level = level;
        this.storage = new OccultismItemStorage(this.storageController);
    }

    @NotNull
    public Level getLevel() {
        return this.level;
    }

    @NotNull
    public OccultismItemStorage getStorage() {
        return this.storage;
    }

    public int getItemStorageTransferLimit() {
        return PeripheralWorksConfig.INSTANCE.getItemStorageTransferLimit();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxSlots() {
        return this.storageController.getMaxSlots();
    }

    @LuaFunction(mainThread=true)
    public final int getUsedSlots() {
        return this.storageController.getUsedSlots();
    }

    @LuaFunction(mainThread=true)
    public final boolean isBlacklisted(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        RegistryWrapper registryWrapper = PlatformRegistries.INSTANCE.getITEMS();
        ResourceLocation resourceLocation = ResourceLocation.parse((String)item);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
        Item itemInstance = (Item)registryWrapper.get(resourceLocation);
        if (Intrinsics.areEqual((Object)itemInstance, (Object)Items.f_41852_)) {
            throw new LuaException("Cannot find item with id " + item);
        }
        return this.storageController.isBlacklisted(itemInstance.m_7968_());
    }
}

