/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.peripheralworks.subsystem.recipe.DefaultRecipeTransformer;
import site.siredvin.peripheralworks.subsystem.recipe.NBTCheckMode;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeSearchPredicate;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeSerializableRecord;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeTransformer;
import site.siredvin.peripheralworks.subsystem.recipe.integration.ShapedCraftingRecipeTransformer;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.platform.ComputerPlatformToolkit;
import site.siredvin.tweakium.modules.platform.api.InnerComputerPlatformToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJI\u0010\u0011\u001a\u00020\u0006\"\b\b\u0000\u0010\n*\u00020\t\"\u000e\b\u0001\u0010\f*\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012JO\u0010\u0013\u001a\u00020\u0006\"\b\b\u0000\u0010\n*\u00020\t\"\u000e\b\u0001\u0010\f*\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0012J7\u0010\u0017\u001a\u00020\u0006\"\u0004\b\u0000\u0010\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J1\u0010\u001d\u001a\u00020\u0006\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010!\u001a\u0004\u0018\u00010\u00012\b\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010#\u001a\u0004\u0018\u00010\u00012\b\u0010 \u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010%\u001a\u0004\u0018\u00010\u00012\b\u0010 \u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b%\u0010$J-\u0010+\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00010)2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b-\u0010.J+\u00102\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b012\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b2\u00103J9\u00109\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u0001082\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u00105\u001a\u0002042\u0006\u00100\u001a\u00020/2\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\b9\u0010:J!\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019012\b\u0010;\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b<\u0010=R\u0017\u0010?\u001a\u00020>8\u0006\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u0017\u0010C\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR#\u0010G\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0)8\u0006\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR:\u0010L\u001a(\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\r\u0012\u0012\u0012\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000f0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010HR2\u0010M\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00150K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010HR$\u0010N\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001b0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010HR\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00040R8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010W\u00a8\u0006X"}, d2={"Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeRegistryToolkit;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "type", "", "excludeRecipeType", "(Lnet/minecraft/class_2960;)V", "Lnet/minecraft/class_1263;", "V", "Lnet/minecraft/class_1860;", "T", "Ljava/lang/Class;", "recipeClass", "Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeTransformer;", "transformer", "registerRecipeSerializer", "(Ljava/lang/Class;Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeTransformer;)V", "registerRecipeSerializerRaw", "clazz", "Ljava/util/function/Function;", "serializer", "registerSerializer", "(Ljava/lang/Class;Ljava/util/function/Function;)V", "Lnet/minecraft/class_3956;", "recipeType", "Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeSearchPredicate;", "searchFunction", "registerRecipePredicate", "(Lnet/minecraft/class_3956;Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeSearchPredicate;)V", "Lcom/google/gson/JsonObject;", "obj", "serializeJson", "(Lcom/google/gson/JsonObject;)Ljava/lang/Object;", "serializePossibleCollection", "(Ljava/lang/Object;)Ljava/lang/Object;", "serialize", "recipe", "Lnet/minecraft/class_5455;", "registryAccess", "", "", "serializeRecipe", "(Lnet/minecraft/class_1860;Lnet/minecraft/class_5455;)Ljava/util/Map;", "getRecipeType", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_3956;", "Lnet/minecraft/class_1937;", "level", "", "getRecipesForType", "(Lnet/minecraft/class_3956;Lnet/minecraft/class_1937;)Ljava/util/List;", "Lnet/minecraft/class_1799;", "result", "Lsite/siredvin/peripheralworks/subsystem/recipe/NBTCheckMode;", "checkMode", "", "findRecipesForType", "(Lnet/minecraft/class_3956;Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Lsite/siredvin/peripheralworks/subsystem/recipe/NBTCheckMode;)Ljava/util/List;", "types", "collectRecipeTypes", "(Ljava/lang/Object;)Ljava/util/List;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "SERIALIZATION_SKIP", "Ljava/lang/Object;", "getSERIALIZATION_SKIP", "()Ljava/lang/Object;", "SERIALIZATION_EMPTY_SLOT", "Ljava/util/Map;", "getSERIALIZATION_EMPTY_SLOT", "()Ljava/util/Map;", "", "RECIPE_SERIALIZERS", "SERIALIZERS", "RECIPE_PREDICATES", "", "EXCLUDED_RECIPE_TYPES", "Ljava/util/Set;", "", "getExcludedRecipeTypes", "()Ljava/util/Set;", "excludedRecipeTypes", "DEFAULT_RECIPE_PREDICATE", "Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeSearchPredicate;", "peripheralworks-fabric-1.20.1"})
public final class RecipeRegistryToolkit {
    @NotNull
    public static final RecipeRegistryToolkit INSTANCE = new RecipeRegistryToolkit();
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final Object SERIALIZATION_SKIP = new Object();
    @NotNull
    private static final Map<String, String> SERIALIZATION_EMPTY_SLOT = MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"empty"));
    @NotNull
    private static final Map<Class<? extends class_1860<?>>, RecipeTransformer<?, class_1860<?>>> RECIPE_SERIALIZERS = new LinkedHashMap();
    @NotNull
    private static final Map<Class<?>, Function<Object, Object>> SERIALIZERS = new LinkedHashMap();
    @NotNull
    private static final Map<class_3956<?>, RecipeSearchPredicate> RECIPE_PREDICATES = new LinkedHashMap();
    @NotNull
    private static final Set<class_2960> EXCLUDED_RECIPE_TYPES = new LinkedHashSet();
    @NotNull
    private static final RecipeSearchPredicate DEFAULT_RECIPE_PREDICATE = RecipeRegistryToolkit::DEFAULT_RECIPE_PREDICATE$lambda$0;

    private RecipeRegistryToolkit() {
    }

    @NotNull
    public final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public final Object getSERIALIZATION_SKIP() {
        return SERIALIZATION_SKIP;
    }

    @NotNull
    public final Map<String, String> getSERIALIZATION_EMPTY_SLOT() {
        return SERIALIZATION_EMPTY_SLOT;
    }

    @NotNull
    public final Set<class_2960> getExcludedRecipeTypes() {
        return EXCLUDED_RECIPE_TYPES;
    }

    public final void excludeRecipeType(@NotNull class_2960 type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        EXCLUDED_RECIPE_TYPES.add(type2);
    }

    public final <V extends class_1263, T extends class_1860<V>> void registerRecipeSerializer(@NotNull Class<T> recipeClass, @NotNull RecipeTransformer<V, T> transformer) {
        Intrinsics.checkNotNullParameter(recipeClass, (String)"recipeClass");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        RECIPE_SERIALIZERS.put(recipeClass, transformer);
    }

    public final <V extends class_1263, T extends class_1860<V>> void registerRecipeSerializerRaw(@NotNull Class<T> recipeClass, @NotNull RecipeTransformer<class_1263, class_1860<class_1263>> transformer) {
        Intrinsics.checkNotNullParameter(recipeClass, (String)"recipeClass");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        RECIPE_SERIALIZERS.put(recipeClass, transformer);
    }

    public final <T> void registerSerializer(@NotNull Class<T> clazz, @NotNull Function<T, Object> serializer) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        SERIALIZERS.put(clazz, serializer);
    }

    public final <T extends class_1860<?>> void registerRecipePredicate(@NotNull class_3956<T> recipeType, @NotNull RecipeSearchPredicate searchFunction) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)searchFunction, (String)"searchFunction");
        RECIPE_PREDICATES.put(recipeType, searchFunction);
    }

    @Nullable
    public final Object serializeJson(@Nullable JsonObject obj) {
        return GSON.fromJson((JsonElement)obj, HashMap.class);
    }

    @Nullable
    public final Object serializePossibleCollection(@Nullable Object obj) {
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().map(INSTANCE::serialize).collect(Collectors.toList());
        }
        if (obj != null && obj.getClass().isArray()) {
            return Arrays.stream((Object[])obj).map(INSTANCE::serialize).collect(Collectors.toList());
        }
        return this.serialize(obj);
    }

    @Nullable
    public final Object serialize(@Nullable Object obj) {
        if (obj instanceof RecipeSerializableRecord) {
            return ((RecipeSerializableRecord)obj).serializeForToolkit();
        }
        for (Class<?> clazz : SERIALIZERS.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            Function<Object, Object> function = SERIALIZERS.get(clazz);
            Intrinsics.checkNotNull(function);
            return function.apply(clazz.cast(obj));
        }
        return obj;
    }

    @NotNull
    public final Map<String, Object> serializeRecipe(@NotNull class_1860<?> recipe, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (Class<class_1860<?>> recipeClass : RECIPE_SERIALIZERS.keySet()) {
            if (!recipeClass.isInstance(recipe)) continue;
            RecipeTransformer<?, class_1860<?>> recipeTransformer = RECIPE_SERIALIZERS.get(recipeClass);
            Intrinsics.checkNotNull(recipeTransformer);
            return recipeTransformer.transform(recipe, registryAccess);
        }
        return DefaultRecipeTransformer.INSTANCE.transform(recipe, registryAccess);
    }

    @NotNull
    public final class_3956<?> getRecipeType(@NotNull class_2960 type2) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        class_3956 class_39562 = (class_3956)PlatformRegistries.INSTANCE.getRECIPE_TYPES().tryGet(type2);
        if (class_39562 == null) {
            String string = "Incorrect recipe type %s";
            Object[] objectArray = new Object[]{type2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new LuaException(string2);
        }
        return class_39562;
    }

    @NotNull
    public final List<class_1860<?>> getRecipesForType(@NotNull class_3956<?> recipeType, @NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List list = level.method_8433().method_30027(recipeType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
        return list;
    }

    @Nullable
    public final List<Object> findRecipesForType(@NotNull class_3956<?> recipeType, @NotNull class_1799 result, @NotNull class_1937 level, @NotNull NBTCheckMode checkMode) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        RecipeSearchPredicate searchPredicate = RECIPE_PREDICATES.getOrDefault(recipeType, DEFAULT_RECIPE_PREDICATE);
        List<class_1860<?>> recipes = this.getRecipesForType(recipeType, level);
        return recipes.stream().filter(arg_0 -> RecipeRegistryToolkit.findRecipesForType$lambda$1(arg_0 -> RecipeRegistryToolkit.findRecipesForType$lambda$0(searchPredicate, result, checkMode, arg_0), arg_0)).collect(Collectors.toList());
    }

    @NotNull
    public final List<class_3956<?>> collectRecipeTypes(@Nullable Object types) throws LuaException {
        if (types == null || Intrinsics.areEqual((Object)types.toString(), (Object)"*")) {
            return SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)PlatformRegistries.INSTANCE.getRECIPE_TYPES().iterator()));
        }
        if (types instanceof String) {
            return StringsKt.contains$default((CharSequence)((CharSequence)types), (CharSequence)":", (boolean)false, (int)2, null) ? CollectionsKt.listOf(this.getRecipeType(new class_2960(((String)types).toString()))) : SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)PlatformRegistries.INSTANCE.getRECIPE_TYPES().iterator()), arg_0 -> RecipeRegistryToolkit.collectRecipeTypes$lambda$0(types, arg_0)));
        }
        if (types instanceof Map) {
            List recipeTypes = new ArrayList();
            for (Object el : ((Map)types).values()) {
                recipeTypes.add(this.getRecipeType(new class_2960(String.valueOf(el))));
            }
            return recipeTypes;
        }
        throw new LuaException("types should be string or table!");
    }

    private static final boolean DEFAULT_RECIPE_PREDICATE$lambda$0(class_1799 stack, class_1860 recipe, NBTCheckMode checkMode) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        class_1799 class_17992 = recipe.method_8110((class_5455)class_5455.field_40585);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getResultItem(...)");
        return checkMode.itemStackEquals(class_17992, stack);
    }

    private static final Object _init_$lambda$0(class_1856 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.method_8103()) {
            return SERIALIZATION_EMPTY_SLOT;
        }
        try {
            return GSON.fromJson(it.method_8089(), HashMap.class);
        }
        catch (JsonSyntaxException ignored) {
            try {
                return GSON.fromJson(it.method_8089(), ArrayList.class);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static final Object _init_$lambda$1(class_1799 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.method_7960()) {
            return SERIALIZATION_EMPTY_SLOT;
        }
        return LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (class_1799)it, null, (int)2, null);
    }

    private static final Object _init_$lambda$2(class_1299 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)PlatformRegistries.INSTANCE.getENTITY_TYPES().getKey((Object)it).toString())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final boolean findRecipesForType$lambda$0(RecipeSearchPredicate $searchPredicate, class_1799 $result, NBTCheckMode $checkMode, class_1860 it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.Recipe<net.minecraft.world.Container>");
        return $searchPredicate.test($result, (class_1860<class_1263>)it, $checkMode);
    }

    private static final boolean findRecipesForType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean collectRecipeTypes$lambda$0(Object $types, class_3956 p) {
        return StringsKt.startsWith$default((String)p.toString(), (String)((String)$types), (boolean)false, (int)2, null);
    }

    static {
        INSTANCE.registerSerializer(class_1856.class, RecipeRegistryToolkit::_init_$lambda$0);
        INSTANCE.registerSerializer(class_1799.class, RecipeRegistryToolkit::_init_$lambda$1);
        INSTANCE.registerSerializer(class_1792.class, arg_0 -> ((LuaRepresentation)LuaRepresentation.INSTANCE).forItem(arg_0));
        INSTANCE.registerSerializer(class_3611.class, arg_0 -> ((LuaRepresentation)LuaRepresentation.INSTANCE).forFluid(arg_0));
        INSTANCE.registerSerializer(JsonObject.class, INSTANCE::serializeJson);
        INSTANCE.registerSerializer(class_1299.class, RecipeRegistryToolkit::_init_$lambda$2);
        INSTANCE.registerSerializer(class_2520.class, arg_0 -> ((InnerComputerPlatformToolkit)ComputerPlatformToolkit.INSTANCE.get()).nbtToLua(arg_0));
        INSTANCE.registerRecipeSerializer(class_1869.class, ShapedCraftingRecipeTransformer.INSTANCE);
    }
}

