/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.powah;

import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyStorageUtils;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0016\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010!R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/PowahEnergyStorageWrapper;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "storage", "<init>", "(Lowmii/powah/lib/block/AbstractEnergyStorage;)V", "", "setChanged", "()V", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "stack", "", "simulate", "store", "(Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;Z)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "", "getContent", "()Ljava/util/Iterator;", "Ljava/util/function/Predicate;", "predicate", "", "limit", "take", "(Ljava/util/function/Predicate;JZ)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "getMaxStackSize", "()Ljava/lang/Long;", "maxStackSize", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "operator", "getCanExtract", "()Z", "canExtract", "getFirstEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "firstEnergy", "getReceiveRateLimit", "()J", "receiveRateLimit", "getExtractRateLimit", "extractRateLimit", "getCanReceive", "canReceive", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "unit", "peripheralworks-fabric-1.20.1"})
public final class PowahEnergyStorageWrapper
implements AgnosticEnergyStorage {
    @NotNull
    private final AbstractEnergyStorage<?, ?> storage;

    public PowahEnergyStorageWrapper(@NotNull AbstractEnergyStorage<?, ?> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    @NotNull
    public Long getMaxStackSize() {
        return this.storage.getEnergy().getCapacity();
    }

    @NotNull
    public SomethingOperator<AgnosticEnergyStack, Long> getOperator() {
        return (SomethingOperator)EnergyStorageUtils.INSTANCE;
    }

    public boolean getCanExtract() {
        return this.storage.canExtractEnergy(null);
    }

    @NotNull
    public AgnosticEnergyStack getFirstEnergy() {
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), this.storage.getEnergy().getStored());
    }

    public long getReceiveRateLimit() {
        AbstractBlock abstractBlock = this.storage.getBlock();
        AbstractEnergyBlock abstractEnergyBlock = abstractBlock instanceof AbstractEnergyBlock ? (AbstractEnergyBlock)abstractBlock : null;
        return abstractEnergyBlock != null && (abstractEnergyBlock = (IEnergyConfig)abstractEnergyBlock.getConfig()) != null ? abstractEnergyBlock.getTransfer((Enum)this.storage.getVariant()) : Long.MAX_VALUE;
    }

    public long getExtractRateLimit() {
        return this.getReceiveRateLimit();
    }

    public void setChanged() {
        this.storage.method_5431();
    }

    public boolean getCanReceive() {
        return this.storage.canReceiveEnergy(null);
    }

    @NotNull
    public final EnergyUnit getUnit() {
        return PlatformToolkit.INSTANCE.get().getCommonEnergy();
    }

    @NotNull
    public AgnosticEnergyStack store(@NotNull AgnosticEnergyStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(PlatformToolkit.INSTANCE.get().getCommonEnergy())) {
            return stack;
        }
        if (!this.storage.canReceiveEnergy(null)) {
            return stack;
        }
        long receivedEnergy = this.storage.receiveEnergy(stack.getAmount(), simulate, null);
        return stack.copyWithCount(stack.getAmount() - receivedEnergy);
    }

    @NotNull
    public Iterator<AgnosticEnergyStack> getContent() {
        return CollectionsKt.listOf((Object)this.getFirstEnergy()).iterator();
    }

    @NotNull
    public AgnosticEnergyStack take(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getFirstEnergy())) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        long extractedEnergy = this.storage.extractEnergy(limit, simulate, null);
        if (extractedEnergy == 0L) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), extractedEnergy);
    }
}

