/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.events;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.PeripheralWorksCore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J!\u0010\t\u001a\u00020\u00042\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0004\b\t\u0010\fJ!\u0010\r\u001a\u00020\u00042\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\nJ\u001b\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0004\b\r\u0010\fJ\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010!\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(RT\u0010,\u001aB\u0012\f\u0012\n **\u0004\u0018\u00010\u001a0\u001a\u0012\f\u0012\n **\u0004\u0018\u00010+0+ ** \u0012\f\u0012\n **\u0004\u0018\u00010\u001a0\u001a\u0012\f\u0012\n **\u0004\u0018\u00010+0+\u0018\u00010)0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/Rh\u00102\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011 **\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010101 ***\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011 **\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010101\u0018\u000100008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u0007048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u0010:\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus;", "", "<init>", "()V", "", "postDebugLog", "", "Lnet/minecraft/class_2338;", "pos", "addBlockPos", "([Lnet/minecraft/class_2338;)V", "", "(Ljava/util/Collection;)V", "removeBlockPos", "poses", "", "id", "Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;", "data", "putEventIntoQueue", "(JLsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;)V", "lastConsumedID", "Ljava/util/function/Consumer;", "consumer", "traverseEvents", "(JLjava/util/function/Consumer;)J", "Lnet/minecraft/class_3222;", "player", "togglePlayer", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_2680;", "previous", "current", "onBlockStateChange", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2680;)V", "", "EVENT_QUEUE_MAX_SIZE", "I", "", "listenedBlockPos", "Ljava/util/Set;", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "", "hookedPlayers", "Ljava/util/concurrent/ConcurrentMap;", "_lastEventID", "J", "Lcom/google/common/collect/EvictingQueue;", "Lkotlin/Pair;", "eventQueue", "Lcom/google/common/collect/EvictingQueue;", "", "getTrackedBlocks", "()Ljava/util/List;", "trackedBlocks", "getLastEventID", "()J", "lastEventID", "BlockStateUpdateEvent", "peripheralworks-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nBlockStateUpdateEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStateUpdateEventBus.kt\nsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1863#2,2:93\n*S KotlinDebug\n*F\n+ 1 BlockStateUpdateEventBus.kt\nsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus\n*L\n86#1:93,2\n*E\n"})
public final class BlockStateUpdateEventBus {
    @NotNull
    public static final BlockStateUpdateEventBus INSTANCE = new BlockStateUpdateEventBus();
    private static final int EVENT_QUEUE_MAX_SIZE = 200;
    @NotNull
    private static final Set<class_2338> listenedBlockPos = new LinkedHashSet();
    private static final ConcurrentMap<class_3222, Boolean> hookedPlayers = new MapMaker().weakKeys().concurrencyLevel(4).initialCapacity(1).makeMap();
    private static long _lastEventID;
    private static final EvictingQueue<Pair<Long, BlockStateUpdateEvent>> eventQueue;

    private BlockStateUpdateEventBus() {
    }

    @NotNull
    public final List<class_2338> getTrackedBlocks() {
        return CollectionsKt.toList((Iterable)listenedBlockPos);
    }

    public final synchronized long getLastEventID() {
        return _lastEventID;
    }

    public final synchronized void postDebugLog() {
        CacheBuilder.newBuilder().weakKeys();
        PeripheralWorksCore.INSTANCE.getLogger().info("Current last event ID: " + _lastEventID);
        PeripheralWorksCore.INSTANCE.getLogger().info("Current tracked pos: " + listenedBlockPos);
    }

    public final void addBlockPos(class_2338 ... pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CollectionsKt.addAll((Collection)listenedBlockPos, (Object[])pos);
    }

    public final void addBlockPos(@NotNull Collection<? extends class_2338> pos) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        listenedBlockPos.addAll(pos);
    }

    public final void removeBlockPos(class_2338 ... pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        listenedBlockPos.removeAll(ArraysKt.toSet((Object[])pos));
    }

    public final void removeBlockPos(@NotNull Collection<? extends class_2338> poses) {
        Intrinsics.checkNotNullParameter(poses, (String)"poses");
        listenedBlockPos.removeAll(CollectionsKt.toSet((Iterable)poses));
    }

    public final synchronized void putEventIntoQueue(long id, @NotNull BlockStateUpdateEvent data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        eventQueue.add((Object)new Pair((Object)id, (Object)data));
        long l = _lastEventID;
        _lastEventID = l + 1L;
    }

    public final synchronized long traverseEvents(long lastConsumedID, @NotNull Consumer<BlockStateUpdateEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        long consumedTracker = lastConsumedID;
        Iterator iterator = eventQueue.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Pair message = (Pair)iterator2.next();
            if (message == null || ((Number)message.getFirst()).longValue() <= consumedTracker) continue;
            consumer.accept((BlockStateUpdateEvent)message.getSecond());
            consumedTracker = ((Number)message.getFirst()).longValue();
        }
        return consumedTracker;
    }

    public final void togglePlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ConcurrentMap<class_3222, Boolean> concurrentMap = hookedPlayers;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"hookedPlayers");
        if (((Map)concurrentMap).containsKey(player)) {
            hookedPlayers.remove(player);
        } else {
            ConcurrentMap<class_3222, Boolean> concurrentMap2 = hookedPlayers;
            Intrinsics.checkNotNullExpressionValue(concurrentMap2, (String)"hookedPlayers");
            Map map = concurrentMap2;
            Boolean bl = true;
            map.put(player, bl);
        }
    }

    public final void onBlockStateChange(@NotNull class_2338 pos, @NotNull class_2680 previous, @NotNull class_2680 current) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (listenedBlockPos.contains(pos)) {
            this.putEventIntoQueue(this.getLastEventID(), new BlockStateUpdateEvent(pos, previous, current));
            Iterable $this$forEach$iv = hookedPlayers.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl = false;
                it.method_43496((class_2561)class_2561.method_43470((String)("Block " + pos + " changed")));
            }
        }
    }

    static {
        eventQueue = EvictingQueue.create((int)200);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001e\u0010\f\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;", "", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2680;", "previous", "current", "<init>", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2680;)V", "component1", "()Lnet/minecraft/class_2338;", "component2", "()Lnet/minecraft/class_2680;", "component3", "copy", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2680;)Lsite/siredvin/peripheralworks/common/events/BlockStateUpdateEventBus$BlockStateUpdateEvent;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2338;", "getPos", "Lnet/minecraft/class_2680;", "getPrevious", "getCurrent", "peripheralworks-fabric-1.20.1"})
    public static final class BlockStateUpdateEvent {
        @NotNull
        private final class_2338 pos;
        @NotNull
        private final class_2680 previous;
        @NotNull
        private final class_2680 current;

        public BlockStateUpdateEvent(@NotNull class_2338 pos, @NotNull class_2680 previous, @NotNull class_2680 current) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            this.pos = pos;
            this.previous = previous;
            this.current = current;
        }

        @NotNull
        public final class_2338 getPos() {
            return this.pos;
        }

        @NotNull
        public final class_2680 getPrevious() {
            return this.previous;
        }

        @NotNull
        public final class_2680 getCurrent() {
            return this.current;
        }

        @NotNull
        public final class_2338 component1() {
            return this.pos;
        }

        @NotNull
        public final class_2680 component2() {
            return this.previous;
        }

        @NotNull
        public final class_2680 component3() {
            return this.current;
        }

        @NotNull
        public final BlockStateUpdateEvent copy(@NotNull class_2338 pos, @NotNull class_2680 previous, @NotNull class_2680 current) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            return new BlockStateUpdateEvent(pos, previous, current);
        }

        public static /* synthetic */ BlockStateUpdateEvent copy$default(BlockStateUpdateEvent blockStateUpdateEvent, class_2338 class_23382, class_2680 class_26802, class_2680 class_26803, int n, Object object) {
            if ((n & 1) != 0) {
                class_23382 = blockStateUpdateEvent.pos;
            }
            if ((n & 2) != 0) {
                class_26802 = blockStateUpdateEvent.previous;
            }
            if ((n & 4) != 0) {
                class_26803 = blockStateUpdateEvent.current;
            }
            return blockStateUpdateEvent.copy(class_23382, class_26802, class_26803);
        }

        @NotNull
        public String toString() {
            return "BlockStateUpdateEvent(pos=" + this.pos + ", previous=" + this.previous + ", current=" + this.current + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.previous.hashCode();
            result = result * 31 + this.current.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockStateUpdateEvent)) {
                return false;
            }
            BlockStateUpdateEvent blockStateUpdateEvent = (BlockStateUpdateEvent)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)blockStateUpdateEvent.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previous, (Object)blockStateUpdateEvent.previous)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.current, (Object)blockStateUpdateEvent.current);
        }
    }
}

