/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import com.google.common.collect.MapMaker;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0015\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b \u0010!J)\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b$\u0010%J'\u0010'\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b'\u0010(J)\u0010)\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b)\u0010%J)\u0010/\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010-\u001a\u00020,H\u0007\u00a2\u0006\u0004\b/\u00100R)\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000002018\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R8\u0010:\u001a&\u0012\f\u0012\n 8*\u0004\u0018\u00010\t0\t 8*\u0012\u0012\f\u0012\n 8*\u0004\u0018\u00010\t0\t\u0018\u000109078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "O", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "", "peripheralType", "owner", "<init>", "(Ljava/lang/String;Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "Ldan200/computercraft/api/peripheral/IPeripheral;", "peripheral", "selectName", "(Ldan200/computercraft/api/peripheral/IPeripheral;)Ljava/lang/String;", "internalID", "", "useInternalID", "", "attachRemotePeripheral", "(Ldan200/computercraft/api/peripheral/IPeripheral;Ljava/lang/String;Z)V", "removeRemotePeripheral", "(Ljava/lang/String;)V", "purgePeripheral", "()V", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "attach", "(Ldan200/computercraft/api/peripheral/IComputerAccess;)V", "detach", "", "getNamesRemote", "()Ljava/util/Collection;", "name", "isPresentRemote", "(Ljava/lang/String;)Z", "", "", "getTypeRemote", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;)[Ljava/lang/Object;", "type", "hasTypeRemote", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/lang/String;)Z", "getMethodsRemote", "Ldan200/computercraft/api/lua/ILuaContext;", "context", "Ldan200/computercraft/api/lua/IArguments;", "arguments", "Ldan200/computercraft/api/lua/MethodResult;", "callRemote", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ldan200/computercraft/api/lua/ILuaContext;Ldan200/computercraft/api/lua/IArguments;)Ldan200/computercraft/api/lua/MethodResult;", "Ljava/util/concurrent/ConcurrentMap;", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "peripheralsRecord", "Ljava/util/concurrent/ConcurrentMap;", "getPeripheralsRecord", "()Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "", "remotePeripherals", "Ljava/util/Set;", "peripheralworks-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nPeripheralHubPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeripheralHubPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,139:1\n1863#2,2:140\n1863#2,2:143\n1863#2:145\n1863#2,2:146\n1864#2:148\n739#2,9:149\n1#3:142\n37#4,2:158\n*S KotlinDebug\n*F\n+ 1 PeripheralHubPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral\n*L\n44#1:140,2\n55#1:143,2\n65#1:145\n66#1:146,2\n65#1:148\n27#1:149,9\n28#1:158,2\n*E\n"})
public abstract class PeripheralHubPeripheral<O extends IPeripheralOwner>
extends OwnedPeripheral<O> {
    @NotNull
    private final ConcurrentMap<String, PeripheralRecord<O>> peripheralsRecord;
    private final Set<IPeripheral> remotePeripherals;

    public PeripheralHubPeripheral(@NotNull String peripheralType, @NotNull O owner) {
        Intrinsics.checkNotNullParameter((Object)peripheralType, (String)"peripheralType");
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        super(peripheralType, owner);
        this.peripheralsRecord = new ConcurrentHashMap();
        this.remotePeripherals = Collections.newSetFromMap(new MapMaker().concurrencyLevel(4).weakKeys().makeMap());
    }

    @NotNull
    public final ConcurrentMap<String, PeripheralRecord<O>> getPeripheralsRecord() {
        return this.peripheralsRecord;
    }

    @NotNull
    protected String selectName(@NotNull IPeripheral peripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        Integer maxIndex = this.peripheralsRecord.keySet().stream().filter(arg_0 -> PeripheralHubPeripheral.selectName$lambda$1(arg_0 -> PeripheralHubPeripheral.selectName$lambda$0(peripheral, arg_0), arg_0)).map(arg_0 -> PeripheralHubPeripheral.selectName$lambda$4(PeripheralHubPeripheral::selectName$lambda$3, arg_0)).max((arg_0, arg_1) -> PeripheralHubPeripheral.selectName$lambda$6(PeripheralHubPeripheral::selectName$lambda$5, arg_0, arg_1)).orElse(0);
        return peripheral.getType() + "_" + (maxIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachRemotePeripheral(@NotNull IPeripheral peripheral, @NotNull String internalID, boolean useInternalID) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        Intrinsics.checkNotNullParameter((Object)internalID, (String)"internalID");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                boolean bl2 = false;
                if (this.remotePeripherals.contains(peripheral)) {
                    return;
                }
                String peripheralName = useInternalID ? internalID : this.selectName(peripheral);
                PeripheralRecord record = new PeripheralRecord(peripheral, peripheralName, internalID, this);
                Iterable $this$forEach$iv = this.getConnectedComputers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IComputerAccess computer = (IComputerAccess)element$iv;
                    boolean bl3 = false;
                    record.attach(computer);
                }
                this.remotePeripherals.add(peripheral);
                ((Map)this.peripheralsRecord).put(peripheralName, record);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                reentrantLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void attachRemotePeripheral$default(PeripheralHubPeripheral peripheralHubPeripheral, IPeripheral iPeripheral, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachRemotePeripheral");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        peripheralHubPeripheral.attachRemotePeripheral(iPeripheral, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemotePeripheral(@NotNull String internalID) {
        Intrinsics.checkNotNullParameter((Object)internalID, (String)"internalID");
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            PeripheralRecord peripheralRecord;
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                PeripheralRecord peripheralRecord2;
                Object v0;
                block10: {
                    boolean bl2 = false;
                    Iterable iterable = this.peripheralsRecord.values();
                    Iterator iterator = iterable.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        PeripheralRecord it = (PeripheralRecord)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getInternalID(), (Object)internalID)) continue;
                        v0 = t;
                        break block10;
                    }
                    v0 = null;
                }
                if ((PeripheralRecord)v0 == null) {
                    return;
                }
                PeripheralRecord record = peripheralRecord2;
                Iterable $this$forEach$iv = this.getConnectedComputers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IComputerAccess p0 = (IComputerAccess)element$iv;
                    boolean bl4 = false;
                    record.detach(p0);
                }
                this.remotePeripherals.remove(record.getPeripheral());
                peripheralRecord = (PeripheralRecord)this.peripheralsRecord.remove(record.getName());
            }
            finally {
                reentrantLock.unlock();
            }
            PeripheralRecord peripheralRecord3 = peripheralRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgePeripheral() {
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            ReentrantLock reentrantLock = this.getConnectedComputersLock();
            reentrantLock.lock();
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = this.peripheralsRecord.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PeripheralRecord it = (PeripheralRecord)element$iv;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv2 = this.getConnectedComputers();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        IComputerAccess p0 = (IComputerAccess)element$iv2;
                        boolean bl4 = false;
                        it.detach(p0);
                    }
                    this.remotePeripherals.remove(it.getPeripheral());
                    this.peripheralsRecord.remove(it.getName());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                reentrantLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.attach(computer);
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            this.peripheralsRecord.values().forEach(arg_0 -> PeripheralHubPeripheral.attach$lambda$18$lambda$17(computer, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.detach(computer);
        ConcurrentMap<String, PeripheralRecord<O>> concurrentMap = this.peripheralsRecord;
        synchronized (concurrentMap) {
            boolean bl = false;
            this.peripheralsRecord.values().forEach(arg_0 -> PeripheralHubPeripheral.detach$lambda$20$lambda$19(computer, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    @LuaFunction
    @NotNull
    public final Collection<String> getNamesRemote() {
        return CollectionsKt.sorted((Iterable)this.peripheralsRecord.keySet());
    }

    @LuaFunction
    public final boolean isPresentRemote(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.peripheralsRecord.containsKey(name);
    }

    @LuaFunction
    @Nullable
    public final Object[] getTypeRemote(@Nullable IComputerAccess computer, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(name);
        if (peripheralRecord == null) {
            return null;
        }
        PeripheralRecord record = peripheralRecord;
        Object[] objectArray = new Object[]{record.getPeripheral().getType()};
        return objectArray;
    }

    @LuaFunction
    public final boolean hasTypeRemote(@NotNull IComputerAccess computer, @NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(name);
        if (peripheralRecord == null) {
            return false;
        }
        PeripheralRecord record = peripheralRecord;
        return Intrinsics.areEqual((Object)record.getPeripheral().getType(), (Object)type) || record.getPeripheral().getAdditionalTypes().contains(type);
    }

    @LuaFunction
    @Nullable
    public final Object[] getMethodsRemote(@Nullable IComputerAccess computer, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(name);
        if (peripheralRecord == null) {
            return null;
        }
        PeripheralRecord record = peripheralRecord;
        Object[] objectArray = new Object[]{record.getMethodNames()};
        return objectArray;
    }

    @LuaFunction
    @NotNull
    public final MethodResult callRemote(@NotNull IComputerAccess computer, @Nullable ILuaContext context, @NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String remoteName = arguments.getString(0);
        String methodName = arguments.getString(1);
        PeripheralRecord peripheralRecord = (PeripheralRecord)this.peripheralsRecord.get(remoteName);
        if (peripheralRecord == null) {
            throw new LuaException("No peripheral: " + remoteName);
        }
        PeripheralRecord record = peripheralRecord;
        Intrinsics.checkNotNull((Object)methodName);
        return record.callMethod(computer, context, methodName, arguments.drop(2));
    }

    private static final boolean selectName$lambda$0(IPeripheral $peripheral, String key) {
        Intrinsics.checkNotNullParameter((Object)$peripheral, (String)"$peripheral");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = $peripheral.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        return StringsKt.startsWith$default((String)key, (String)string, (boolean)false, (int)2, null);
    }

    private static final boolean selectName$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Integer selectName$lambda$3(String key) {
        List list;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CharSequence charSequence = key;
        Regex regex = new Regex("_");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] splitName = thisCollection$iv.toArray(new String[0]);
        return Integer.valueOf(splitName[splitName.length - 1]);
    }

    private static final Integer selectName$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final int selectName$lambda$5(int obj, Integer anotherInteger) {
        Integer n = anotherInteger;
        Intrinsics.checkNotNull((Object)n);
        return Intrinsics.compare((int)obj, (int)n);
    }

    private static final int selectName$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void attach$lambda$18$lambda$17(IComputerAccess $computer, PeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)$computer, (String)"$computer");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        record.attach($computer);
    }

    private static final void detach$lambda$20$lambda$19(IComputerAccess $computer, PeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)$computer, (String)"$computer");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        record.detach($computer);
    }
}

