/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.operations;

import com.google.common.math.IntMath;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.api.IForgeConfigHandler;
import site.siredvin.tweakium.modules.operation.SphereOperationContext;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004B)\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001b\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001eR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001fR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u0018\u0010$\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\"R\u0018\u0010&\u001a\u0004\u0018\u00010%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0011\u0010*\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010,\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)j\u0002\b-j\u0002\b.\u00a8\u0006/"}, d2={"Lsite/siredvin/peripheralworks/computercraft/operations/SphereOperations;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOperation;", "Lsite/siredvin/tweakium/modules/operation/SphereOperationContext;", "Lsite/siredvin/peripheralworks/api/IForgeConfigHandler;", "", "", "defaultCooldown", "defaultMaxFreeRadius", "defaultMaxCostRadius", "", "defaultExtraBlockCost", "<init>", "(Ljava/lang/String;IIIID)V", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "builder", "", "addToConfig", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "context", "getCooldown", "(Lsite/siredvin/tweakium/modules/operation/SphereOperationContext;)I", "getCost", "", "", "", "computerDescription", "()Ljava/util/Map;", "free", "()Lsite/siredvin/tweakium/modules/operation/SphereOperationContext;", "cost", "I", "D", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "cooldown", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "maxFreeRadiusConfig", "maxCostRadiusConfig", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "extraBlockCost", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "getMaxFreeRadius", "()I", "maxFreeRadius", "getMaxCostRadius", "maxCostRadius", "PORTABLE_UNIVERSAL_SCAN", "STATIONARY_UNIVERSAL_SCAN", "peripheralworks-fabric-1.20.1"})
public final class SphereOperations
extends Enum<SphereOperations>
implements IPeripheralOperation<SphereOperationContext>,
IForgeConfigHandler {
    private final int defaultCooldown;
    private final int defaultMaxFreeRadius;
    private final int defaultMaxCostRadius;
    private final double defaultExtraBlockCost;
    @Nullable
    private ForgeConfigSpec.IntValue cooldown;
    @Nullable
    private ForgeConfigSpec.IntValue maxFreeRadiusConfig;
    @Nullable
    private ForgeConfigSpec.IntValue maxCostRadiusConfig;
    @Nullable
    private ForgeConfigSpec.DoubleValue extraBlockCost;
    public static final /* enum */ SphereOperations PORTABLE_UNIVERSAL_SCAN = new SphereOperations(1000, 8, 16, 0.17);
    public static final /* enum */ SphereOperations STATIONARY_UNIVERSAL_SCAN = new SphereOperations(500, 24, 24, 0.0);
    private static final /* synthetic */ SphereOperations[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private SphereOperations(int defaultCooldown, int defaultMaxFreeRadius, int defaultMaxCostRadius, double defaultExtraBlockCost) {
        this.defaultCooldown = defaultCooldown;
        this.defaultMaxFreeRadius = defaultMaxFreeRadius;
        this.defaultMaxCostRadius = defaultMaxCostRadius;
        this.defaultExtraBlockCost = defaultExtraBlockCost;
    }

    @Override
    public void addToConfig(@NotNull ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 0, Integer.MAX_VALUE);
        this.maxFreeRadiusConfig = builder.defineInRange(this.settingsName() + "MaxFreeRadius", this.defaultMaxFreeRadius, 1, Integer.MAX_VALUE);
        this.maxCostRadiusConfig = builder.defineInRange(this.settingsName() + "MaxCostRadius", this.defaultMaxCostRadius, 1, Integer.MAX_VALUE);
        this.extraBlockCost = builder.defineInRange(this.settingsName() + "ExtraBlockCost", this.defaultExtraBlockCost, 0.1, Double.MAX_VALUE);
    }

    public int getCooldown(@NotNull SphereOperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ForgeConfigSpec.IntValue intValue = this.cooldown;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public int getCost(@NotNull SphereOperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = context.getRadius();
        ForgeConfigSpec.IntValue intValue = this.maxFreeRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue);
        if (n <= ((Number)intValue.get()).intValue()) {
            return 0;
        }
        ForgeConfigSpec.IntValue intValue2 = this.maxFreeRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue2);
        Object object = intValue2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int freeBlockCount = IntMath.pow((int)(2 * ((Number)object).intValue() + 1), (int)3);
        int allBlockCount = IntMath.pow((int)(2 * context.getRadius() + 1), (int)3);
        double d = allBlockCount - freeBlockCount;
        ForgeConfigSpec.DoubleValue doubleValue = this.extraBlockCost;
        Intrinsics.checkNotNull((Object)doubleValue);
        Object object2 = doubleValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        return (int)Math.floor(d * ((Number)object2).doubleValue());
    }

    public final int getMaxFreeRadius() {
        ForgeConfigSpec.IntValue intValue = this.maxFreeRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final int getMaxCostRadius() {
        ForgeConfigSpec.IntValue intValue = this.maxCostRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @NotNull
    public Map<String, Object> computerDescription() {
        Map data = new HashMap();
        data.put("name", this.settingsName());
        data.put("type", this.getClass().getName());
        ForgeConfigSpec.IntValue intValue = this.cooldown;
        Intrinsics.checkNotNull((Object)intValue);
        data.put("cooldown", intValue.get());
        ForgeConfigSpec.IntValue intValue2 = this.maxFreeRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue2);
        data.put("maxFreeRadius", intValue2.get());
        ForgeConfigSpec.IntValue intValue3 = this.maxCostRadiusConfig;
        Intrinsics.checkNotNull((Object)intValue3);
        data.put("maxCostRadius", intValue3.get());
        ForgeConfigSpec.DoubleValue doubleValue = this.extraBlockCost;
        Intrinsics.checkNotNull((Object)doubleValue);
        data.put("extraBlockCost", doubleValue.get());
        return data;
    }

    @NotNull
    public final SphereOperationContext free() {
        return new SphereOperationContext(this.getMaxFreeRadius());
    }

    @NotNull
    public final SphereOperationContext cost() {
        return new SphereOperationContext(this.getMaxCostRadius());
    }

    public static SphereOperations[] values() {
        return (SphereOperations[])$VALUES.clone();
    }

    public static SphereOperations valueOf(String value) {
        return Enum.valueOf(SphereOperations.class, value);
    }

    @NotNull
    public static EnumEntries<SphereOperations> getEntries() {
        return $ENTRIES;
    }

    @NotNull
    public String settingsName() {
        return IPeripheralOperation.DefaultImpls.settingsName((IPeripheralOperation)this);
    }

    @NotNull
    public String getSettingsPostfix() {
        return IPeripheralOperation.DefaultImpls.getSettingsPostfix((IPeripheralOperation)this);
    }

    static {
        $VALUES = sphereOperationsArray = new SphereOperations[]{SphereOperations.PORTABLE_UNIVERSAL_SCAN, SphereOperations.STATIONARY_UNIVERSAL_SCAN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

