/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.common.blockentity.FlexibleStatueBlockEntity;
import site.siredvin.peripheralworks.common.blockentity.StatueWorkbenchBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.utils.QuadList;
import site.siredvin.peripheralworks.utils.QuadsKt;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 -2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u000f\u0010\u0017\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0014J\u0017\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f0\u001eH\u0007\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\u00102\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001fH\u0007\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010)\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010'H\u0096\u0002\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b+\u0010\u001dR\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\r\u00a8\u0006."}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/StatueWorkbenchPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/StatueWorkbenchBlockEntity;", "blockEntity", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/StatueWorkbenchBlockEntity;)V", "Ljava/util/Optional;", "Lsite/siredvin/peripheralworks/common/blockentity/FlexibleStatueBlockEntity;", "getStatue", "()Ljava/util/Optional;", "", "isPresent", "()Z", "", "name", "", "setStatueName", "(Ljava/lang/String;)V", "getStatueName", "()Ljava/lang/String;", "author", "setAuthor", "getAuthor", "", "lightLevel", "setLightLevel", "(I)V", "getLightLevel", "()I", "", "", "getCubes", "()Ljava/util/List;", "cubes", "setCubes", "(Ljava/util/Map;)V", "reset", "()V", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "isEnabled", "Companion", "peripheralworks-fabric-1.20.1"})
public final class StatueWorkbenchPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<StatueWorkbenchBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "statue_workbench";

    public StatueWorkbenchPeripheral(@NotNull StatueWorkbenchBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((class_2586)blockEntity, null, 2, null));
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableStatueWorkbench();
    }

    @NotNull
    protected final Optional<FlexibleStatueBlockEntity> getStatue() {
        Optional<FlexibleStatueBlockEntity> optional;
        class_1937 class_19372 = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        class_2586 blockEntity = class_19372.method_8321(((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getPos().method_10069(0, 1, 0));
        if (!(blockEntity instanceof FlexibleStatueBlockEntity)) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        } else {
            Optional<class_2586> optional3 = Optional.of(blockEntity);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
        }
        return optional;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPresent() {
        return this.getStatue().isPresent();
    }

    @LuaFunction(mainThread=true)
    public final void setStatueName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        opStatue.ifPresent(arg_0 -> StatueWorkbenchPeripheral.setStatueName$lambda$1(arg_0 -> StatueWorkbenchPeripheral.setStatueName$lambda$0(name, arg_0), arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final String getStatueName() {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        String string = tileEntity.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @LuaFunction(mainThread=true)
    public final void setAuthor(@NotNull String author) {
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        opStatue.ifPresent(arg_0 -> StatueWorkbenchPeripheral.setAuthor$lambda$3(arg_0 -> StatueWorkbenchPeripheral.setAuthor$lambda$2(author, arg_0), arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final String getAuthor() {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        String string = tileEntity.getAuthor();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @LuaFunction(mainThread=true)
    public final void setLightLevel(int lightLevel) {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        opStatue.ifPresent(arg_0 -> StatueWorkbenchPeripheral.setLightLevel$lambda$5(arg_0 -> StatueWorkbenchPeripheral.setLightLevel$lambda$4(lightLevel, arg_0), arg_0));
    }

    @LuaFunction(mainThread=true)
    public final int getLightLevel() {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        return tileEntity.getLightLevel();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<?, ?>> getCubes() {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        QuadList quadList = tileEntity.getBakedQuads();
        if (quadList == null) {
            return CollectionsKt.emptyList();
        }
        QuadList quadList2 = quadList;
        return quadList2.toLua();
    }

    @LuaFunction(mainThread=true)
    public final void setCubes(@NotNull Map<?, ?> cubes) throws LuaException {
        Intrinsics.checkNotNullParameter(cubes, (String)"cubes");
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        QuadList quadList = QuadsKt.convertToQuadList(cubes);
        if (quadList.getList().size() > PeripheralWorksConfig.INSTANCE.getFlexibleStatueMaxQuads()) {
            throw new LuaException("You cannot send more then " + PeripheralWorksConfig.INSTANCE.getFlexibleStatueMaxQuads() + " quads");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        tileEntity.setBakedQuads(quadList, false);
    }

    @LuaFunction(mainThread=true)
    public final void reset() {
        Optional<FlexibleStatueBlockEntity> opStatue = this.getStatue();
        if (!opStatue.isPresent()) {
            throw new LuaException("There is no statue on top of workbench");
        }
        FlexibleStatueBlockEntity flexibleStatueBlockEntity = opStatue.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)flexibleStatueBlockEntity), (String)"get(...)");
        FlexibleStatueBlockEntity tileEntity = flexibleStatueBlockEntity;
        tileEntity.setName(null);
        tileEntity.setAuthor(null);
        FlexibleStatueBlockEntity.clear$default(tileEntity, null, false, 1, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatueWorkbenchPeripheral)) {
            return false;
        }
        if (!super.equals((IPeripheral)other)) {
            return false;
        }
        if (this.isEnabled() != ((StatueWorkbenchPeripheral)((Object)other)).isEnabled()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getPeripheralOwner(), (Object)((StatueWorkbenchPeripheral)((Object)other)).getPeripheralOwner());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.isEnabled());
        result = 31 * result + ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).hashCode();
        return result;
    }

    private static final Unit setStatueName$lambda$0(String $name, FlexibleStatueBlockEntity statue) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)((Object)statue), (String)"statue");
        statue.setName($name);
        return Unit.INSTANCE;
    }

    private static final void setStatueName$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit setAuthor$lambda$2(String $author, FlexibleStatueBlockEntity statue) {
        Intrinsics.checkNotNullParameter((Object)$author, (String)"$author");
        Intrinsics.checkNotNullParameter((Object)((Object)statue), (String)"statue");
        statue.setAuthor($author);
        return Unit.INSTANCE;
    }

    private static final void setAuthor$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit setLightLevel$lambda$4(int $lightLevel, FlexibleStatueBlockEntity statue) {
        Intrinsics.checkNotNullParameter((Object)((Object)statue), (String)"statue");
        statue.setLightLevel($lightLevel);
        return Unit.INSTANCE;
    }

    private static final void setLightLevel$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/StatueWorkbenchPeripheral$Companion;", "", "<init>", "()V", "", "TYPE", "Ljava/lang/String;", "peripheralworks-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

