/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.powah;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.block.AbstractEnergyStorage;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergySink;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.peripheralworks.xplat.ModPlatform;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0011\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/PowahEnergyStorageWrapper;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "storage", "<init>", "(Lowmii/powah/lib/block/AbstractEnergyStorage;)V", "", "setChanged", "()V", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "stack", "storeEnergy", "(Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Ljava/util/function/Predicate;", "predicate", "", "limit", "takeEnergy", "(Ljava/util/function/Predicate;J)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "getCapacity", "()J", "capacity", "", "getCanExtract", "()Z", "canExtract", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "energy", "getCanReceive", "canReceive", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "unit", "peripheralworks-fabric-1.20.1"})
public final class PowahEnergyStorageWrapper
implements AgnosticEnergyStorage {
    @NotNull
    private final AbstractEnergyStorage<?, ?> storage;

    public PowahEnergyStorageWrapper(@NotNull AbstractEnergyStorage<?, ?> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    public long getCapacity() {
        return this.storage.getEnergy().getCapacity();
    }

    public boolean getCanExtract() {
        return this.storage.canExtractEnergy(null);
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(ModPlatform.INSTANCE.getCommonEnergy(), this.storage.getEnergy().getStored());
    }

    public void setChanged() {
        this.storage.method_5431();
    }

    public boolean getCanReceive() {
        return this.storage.canReceiveEnergy(null);
    }

    @NotNull
    public EnergyUnit getUnit() {
        return ModPlatform.INSTANCE.getCommonEnergy();
    }

    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(ModPlatform.INSTANCE.getCommonEnergy())) {
            return stack;
        }
        if (!this.storage.canReceiveEnergy(null)) {
            return stack;
        }
        long receivedEnergy = this.storage.receiveEnergy(stack.getAmount(), false, null);
        return stack.copyWithCount(stack.getAmount() - receivedEnergy);
    }

    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(ModPlatform.INSTANCE.getCommonEnergy(), 0L);
        }
        long extractedEnergy = this.storage.extractEnergy(limit, false, null);
        if (extractedEnergy == 0L) {
            return new AgnosticEnergyStack(ModPlatform.INSTANCE.getCommonEnergy(), 0L);
        }
        return new AgnosticEnergyStack(ModPlatform.INSTANCE.getCommonEnergy(), extractedEnergy);
    }

    public long moveTo(@NotNull AgnosticEnergySink to, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveTo((AgnosticEnergyStorage)this, (AgnosticEnergySink)to, (long)limit, takePredicate);
    }

    public long moveFrom(@NotNull AgnosticEnergyStorage from, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveFrom((AgnosticEnergyStorage)this, (AgnosticEnergyStorage)from, (long)limit, takePredicate);
    }

    @Nullable
    public String getMovableType() {
        return AgnosticEnergyStorage.DefaultImpls.getMovableType((AgnosticEnergyStorage)this);
    }
}

