/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.team_reborn_energy;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergySink;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import team.reborn.energy.api.EnergyStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0011\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralworks/integrations/team_reborn_energy/EnergyStorageWrapper;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "Lteam/reborn/energy/api/EnergyStorage;", "energyStorage", "<init>", "(Lteam/reborn/energy/api/EnergyStorage;)V", "", "setChanged", "()V", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "stack", "storeEnergy", "(Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Ljava/util/function/Predicate;", "predicate", "", "limit", "takeEnergy", "(Ljava/util/function/Predicate;J)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Lteam/reborn/energy/api/EnergyStorage;", "getCapacity", "()J", "capacity", "", "getCanExtract", "()Z", "canExtract", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "energy", "getCanReceive", "canReceive", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "unit", "peripheralworks-fabric-1.20.1"})
public final class EnergyStorageWrapper
implements AgnosticEnergyStorage {
    @NotNull
    private final EnergyStorage energyStorage;

    public EnergyStorageWrapper(@NotNull EnergyStorage energyStorage) {
        Intrinsics.checkNotNullParameter((Object)energyStorage, (String)"energyStorage");
        this.energyStorage = energyStorage;
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    public boolean getCanExtract() {
        return this.energyStorage.supportsExtraction();
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), this.energyStorage.getAmount());
    }

    public void setChanged() {
    }

    public boolean getCanReceive() {
        return this.energyStorage.supportsInsertion();
    }

    @NotNull
    public EnergyUnit getUnit() {
        return Energies.INSTANCE.getREDSTONE_FLUX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)Energies.INSTANCE.getREDSTONE_FLUX())) {
            return stack;
        }
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long stored = this.energyStorage.insert(stack.getAmount(), (TransactionContext)it);
            it.commit();
            stack.shrink(stored);
            AgnosticEnergyStack agnosticEnergyStack = stack;
            return agnosticEnergyStack;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(this.getUnit(), 0L);
        }
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long extractedAmount = this.energyStorage.extract(limit, (TransactionContext)it);
            it.commit();
            AgnosticEnergyStack agnosticEnergyStack = new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), extractedAmount);
            return agnosticEnergyStack;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public long moveTo(@NotNull AgnosticEnergySink to, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveTo((AgnosticEnergyStorage)this, (AgnosticEnergySink)to, (long)limit, takePredicate);
    }

    public long moveFrom(@NotNull AgnosticEnergyStorage from, long limit, @NotNull Predicate<AgnosticEnergyStack> takePredicate) {
        return AgnosticEnergyStorage.DefaultImpls.moveFrom((AgnosticEnergyStorage)this, (AgnosticEnergyStorage)from, (long)limit, takePredicate);
    }

    @Nullable
    public String getMovableType() {
        return AgnosticEnergyStorage.DefaultImpls.getMovableType((AgnosticEnergyStorage)this);
    }
}

