/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import site.siredvin.peripheralworks.common.block.PeripheralProxy;
import site.siredvin.peripheralworks.common.blockentity.PeripheralProxyBlockEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J8\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016\u00a8\u0006\u001c"}, d2={"Lsite/siredvin/peripheralworks/client/renderer/PeripheralProxyRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity;", "<init>", "()V", "renderItem", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "combinedOverlay", "", "lightLevel", "startingAngle", "", "scale", "", "direction", "Lnet/minecraft/core/Direction;", "render", "blockEntity", "partialTick", "packedLight", "packedOverlay", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nPeripheralProxyRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeripheralProxyRenderer.kt\nsite/siredvin/peripheralworks/client/renderer/PeripheralProxyRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1863#2,2:95\n*S KotlinDebug\n*F\n+ 1 PeripheralProxyRenderer.kt\nsite/siredvin/peripheralworks/client/renderer/PeripheralProxyRenderer\n*L\n86#1:95,2\n*E\n"})
public final class PeripheralProxyRenderer
implements BlockEntityRenderer<PeripheralProxyBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final double CIRCLE_RADIUS = 0.4;

    private final void renderItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel, double startingAngle, float scale, Direction direction) {
        Level level = (Level)Minecraft.m_91087_().f_91073_;
        Objects.requireNonNull(level);
        Level level2 = level;
        Intrinsics.checkNotNull((Object)level2);
        float time = level2.m_46467_() * (long)5;
        double shiftedAngle = (startingAngle + (double)time) % (double)360;
        Vector3d translation = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> new Vector3d(0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)), 0.5);
            case 2 -> new Vector3d(0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)), 0.5);
            case 3 -> new Vector3d(0.5, 0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)));
            case 4 -> new Vector3d(0.5, 0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)));
            case 5 -> new Vector3d(0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.4, 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)));
            case 6 -> new Vector3d(0.5 + 0.4 * Math.cos(Math.toRadians(shiftedAngle)), 0.5, 0.5 + 0.4 * Math.sin(Math.toRadians(shiftedAngle)));
            default -> throw new NoWhenBranchMatchedException();
        };
        Quaternionf itemRotation = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 5 -> Axis.f_252436_.m_252977_(90.0f);
            case 6 -> Axis.f_252436_.m_252977_(90.0f);
            case 1 -> Axis.f_252436_.m_252977_(180.0f);
            case 2 -> Axis.f_252436_.m_252977_(0.0f);
            case 3 -> Axis.f_252436_.m_252977_(90.0f);
            case 4 -> Axis.f_252436_.m_252977_(-90.0f);
            default -> throw new NoWhenBranchMatchedException();
        };
        poseStack.m_85836_();
        poseStack.m_85837_(translation.x, translation.y, translation.z);
        poseStack.m_252781_(itemRotation);
        poseStack.m_85841_(scale, scale, scale);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, level, null, lightLevel);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.GROUND, true, poseStack, buffer, lightLevel, combinedOverlay, model);
        poseStack.m_85849_();
    }

    public void render(@NotNull PeripheralProxyBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        double angleStep = 360.0 / (double)blockEntity.getRemotePeripherals().size();
        double startingAngle = 0.0;
        if (!blockEntity.getItemStackCacheBuilt()) {
            Level level = blockEntity.m_58904_();
            Intrinsics.checkNotNull((Object)level);
            blockEntity.updateCachedStacks(level);
        }
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)PeripheralProxy.Companion.getORIENTATION());
        Iterable $this$forEach$iv = blockEntity.getRemotePeripherals().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PeripheralProxyBlockEntity.RemotePeripheralRecord it = (PeripheralProxyBlockEntity.RemotePeripheralRecord)element$iv;
            boolean bl = false;
            if (!it.getStack().m_41619_()) {
                ItemStack itemStack = it.getStack();
                Intrinsics.checkNotNull((Object)direction);
                this.renderItem(itemStack, poseStack, buffer, packedOverlay, packedLight, startingAngle, 0.8f, direction);
            }
            startingAngle += angleStep;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/client/renderer/PeripheralProxyRenderer$Companion;", "", "<init>", "()V", "CIRCLE_RADIUS", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

