/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.blockentity;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.api.IObservingBlockEntity;
import site.siredvin.broccolium.modules.base.api.ISyncingBlockEntity;
import site.siredvin.broccolium.modules.base.ext.BlockPosExtKt;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.peripheralworks.PeripheralWorksCore;
import site.siredvin.peripheralworks.common.block.PeripheralProxy;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.common.events.BlockStateUpdateEventBus;
import site.siredvin.peripheralworks.common.setup.BlockEntityTypes;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralHubPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralRecord;
import site.siredvin.peripheralworks.computercraft.peripherals.PeripheralProxyPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IOwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.blockentity.MutablePeripheralBlockEntity;
import site.siredvin.tweakium.modules.platform.ComputerPlatformToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 E2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003EFGB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0014J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0005J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00052\u0006\u0010,\u001a\u00020#2\u0006\u0010)\u001a\u00020*J\b\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00101\u001a\u00020.2\u0006\u00100\u001a\u00020\fH\u0002J\u001e\u00102\u001a\u00020.2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010,\u001a\u00020#2\u0006\u0010)\u001a\u00020*J\u000e\u00103\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0005J\b\u00104\u001a\u00020.H\u0002J\b\u00105\u001a\u00020.H\u0002J\u0010\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u0005H\u0016J\u0016\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:2\u0006\u00100\u001a\u00020\fJ\u000e\u0010;\u001a\u00020.2\u0006\u00109\u001a\u00020:J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0016J\b\u0010?\u001a\u00020.H\u0002J\u001a\u0010@\u001a\u00020\u00072\u0006\u0010>\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010\u0007H\u0016J \u0010B\u001a\u00020.2\u0006\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0007H\u0016J\b\u0010C\u001a\u00020.H\u0016J\b\u0010D\u001a\u00020.H\u0016R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006H"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity;", "Lsite/siredvin/tweakium/modules/peripheral/blockentity/MutablePeripheralBlockEntity;", "Lsite/siredvin/peripheralworks/computercraft/peripherals/PeripheralProxyPeripheral;", "Lsite/siredvin/broccolium/modules/base/api/IObservingBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "remotePeripherals", "", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "getRemotePeripherals", "()Ljava/util/Map;", "element", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$PeripheralProxyWiredElement;", "getElement", "()Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$PeripheralProxyWiredElement;", "connectedElements", "Ldan200/computercraft/shared/platform/ComponentAccess;", "Ldan200/computercraft/api/network/wired/WiredElement;", "lastConsumedEventID", "", "peripheralConnectionIncomplete", "", "listenerConnectionIncomplete", "refreshConnectionsRequired", "itemStackCacheBuilt", "getItemStackCacheBuilt", "()Z", "setItemStackCacheBuilt", "(Z)V", "createPeripheral", "side", "Lnet/minecraft/core/Direction;", "isPosApplicable", "pos", "containsPos", "buildPeripheralName", "", "targetPeripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "togglePos", "direction", "updatePeripherals", "", "trackRecord", "record", "untrackRecord", "addPosToTrack", "removePosToTrack", "unload", "scheduleConnectionsChanged", "onNeighbourChange", "neighbour", "connectBlockPos", "level", "Lnet/minecraft/world/level/Level;", "updateCachedStacks", "saveInternalData", "Lnet/minecraft/nbt/CompoundTag;", "data", "refreshConnection", "loadInternalData", "state", "handleTick", "setRemoved", "destroy", "Companion", "PeripheralProxyWiredElement", "RemotePeripheralRecord", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nPeripheralProxyBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeripheralProxyBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n535#2:352\n520#2,2:353\n522#2,4:358\n462#2:362\n412#2:363\n188#3,3:355\n216#3,2:370\n1246#4,4:364\n1863#4,2:368\n1863#4,2:372\n1863#4,2:374\n1755#4,3:376\n1755#4,3:379\n*S KotlinDebug\n*F\n+ 1 PeripheralProxyBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity\n*L\n143#1:352\n143#1:353,2\n143#1:358,4\n143#1:362\n143#1:363\n143#1:355,3\n242#1:370,2\n143#1:364,4\n229#1:368,2\n268#1:372,2\n291#1:374,2\n296#1:376,3\n297#1:379,3\n*E\n"})
public final class PeripheralProxyBlockEntity
extends MutablePeripheralBlockEntity<PeripheralProxyPeripheral>
implements IObservingBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<BlockPos, RemotePeripheralRecord> remotePeripherals;
    @NotNull
    private final PeripheralProxyWiredElement element;
    @NotNull
    private final ComponentAccess<WiredElement> connectedElements;
    private long lastConsumedEventID;
    private boolean peripheralConnectionIncomplete;
    private boolean listenerConnectionIncomplete;
    private boolean refreshConnectionsRequired;
    private boolean itemStackCacheBuilt;
    @NotNull
    public static final String REMOTE_PERIPHERALS_TAG = "remotePeripherals";
    @NotNull
    public static final String TARGET_BLOCK_TAG = "targetBlock";
    @NotNull
    public static final String DIRECTION_TAG = "direction";
    @NotNull
    public static final String PERIPHERAL_NAME_TAG = "peripheralName";
    @NotNull
    public static final String RESERVED_IDS_TAG = "reservedIds";

    public PeripheralProxyBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntityType<PeripheralProxyBlockEntity> blockEntityType = BlockEntityTypes.INSTANCE.getPERIPHERAL_PROXY().get();
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"get(...)");
        super(blockEntityType, blockPos, blockState);
        this.remotePeripherals = new LinkedHashMap();
        this.element = new PeripheralProxyWiredElement(this);
        ComponentAccess componentAccess = PlatformHelper.get().createWiredElementAccess((BlockEntity)this, arg_0 -> PeripheralProxyBlockEntity.connectedElements$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)componentAccess, (String)"createWiredElementAccess(...)");
        this.connectedElements = componentAccess;
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.getLastEventID() - 1L;
        this.refreshConnectionsRequired = true;
    }

    @NotNull
    public final Map<BlockPos, RemotePeripheralRecord> getRemotePeripherals() {
        return this.remotePeripherals;
    }

    @NotNull
    public final PeripheralProxyWiredElement getElement() {
        return this.element;
    }

    public final boolean getItemStackCacheBuilt() {
        return this.itemStackCacheBuilt;
    }

    public final void setItemStackCacheBuilt(boolean bl) {
        this.itemStackCacheBuilt = bl;
    }

    @NotNull
    protected PeripheralProxyPeripheral createPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new PeripheralProxyPeripheral(this);
    }

    public final boolean isPosApplicable(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)pos, (Object)this.m_58899_())) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_58899_(), (double)PeripheralWorksConfig.INSTANCE.getPeripheralProxyMaxRange());
    }

    public final boolean containsPos(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.remotePeripherals.containsKey(pos);
    }

    private final String buildPeripheralName(IPeripheral targetPeripheral) {
        MinecraftServer minecraftServer = PlatformToolkit.INSTANCE.get().getMinecraftServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        int newPeripheralID = ServerContext.get((MinecraftServer)minecraftServer).getNextId("peripheral." + targetPeripheral.getType());
        return targetPeripheral.getType() + "_" + newPeripheralID;
    }

    public final boolean togglePos(@NotNull BlockPos pos, @NotNull Direction direction, @NotNull IPeripheral targetPeripheral) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)DIRECTION_TAG);
        Intrinsics.checkNotNullParameter((Object)targetPeripheral, (String)"targetPeripheral");
        if (this.remotePeripherals.containsKey(pos)) {
            this.removePosToTrack(pos);
            bl = false;
        } else {
            this.addPosToTrack(pos, direction, targetPeripheral);
            bl = true;
        }
        boolean blockAdded = bl;
        ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        return blockAdded;
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePeripherals() {
        if (this.getPeripheral() != null) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map.Entry element$iv;
            Object $this$any$iv;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            WiredNode wiredNode = this.element.getNode();
            IOwnedPeripheral iOwnedPeripheral = this.getPeripheral();
            Intrinsics.checkNotNull((Object)iOwnedPeripheral);
            Map map = ((PeripheralProxyPeripheral)iOwnedPeripheral).getPeripheralsRecord();
            WiredNode wiredNode2 = wiredNode;
            boolean $i$f$filter = false;
            void var3_4 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Map.Entry element$iv$iv;
                block6: {
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    $this$any$iv = this.remotePeripherals;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<Map.Entry<BlockPos, RemotePeripheralRecord>> iterator2 = $this$any$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry r = element$iv = iterator2.next();
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)r.getValue().getPeripheralName(), it.getKey())) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                $this$any$iv = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                element$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl4 = false;
                IPeripheral iPeripheral = ((PeripheralRecord)it.getValue()).getPeripheral();
                map3.put(k, iPeripheral);
            }
            wiredNode2.updatePeripherals(destination$iv$iv);
        }
    }

    private final void trackRecord(RemotePeripheralRecord record, IPeripheral targetPeripheral) {
        if (!record.getConnectedToListener()) {
            BlockPos[] blockPosArray = new BlockPos[]{record.getTargetBlock()};
            BlockStateUpdateEventBus.INSTANCE.addBlockPos(blockPosArray);
            record.setConnectedToListener(true);
        }
        if (this.getPeripheral() != null) {
            if (record.getPeripheralName() == null) {
                record.setPeripheralName(this.buildPeripheralName(targetPeripheral));
            }
            IOwnedPeripheral iOwnedPeripheral = this.getPeripheral();
            Intrinsics.checkNotNull((Object)iOwnedPeripheral);
            PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)iOwnedPeripheral;
            String string = record.getPeripheralName();
            Intrinsics.checkNotNull((Object)string);
            peripheralProxyPeripheral.attachRemotePeripheral(targetPeripheral, string, true);
            this.updatePeripherals();
            record.setConnectedToPeripheral(true);
        } else if (!record.getConnectedToPeripheral()) {
            this.peripheralConnectionIncomplete = true;
        }
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (level.f_46443_ && record.getStack().m_41619_()) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                ItemStack itemStack = level2.m_8055_(record.getTargetBlock()).m_60734_().m_5456_().m_7968_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
                record.setStack(itemStack);
            }
        }
    }

    private final void untrackRecord(RemotePeripheralRecord record) {
        BlockPos[] blockPosArray = new BlockPos[]{record.getTargetBlock()};
        BlockStateUpdateEventBus.INSTANCE.removeBlockPos(blockPosArray);
        if (record.getPeripheralName() != null) {
            PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)this.getPeripheral();
            if (peripheralProxyPeripheral != null) {
                String string = record.getPeripheralName();
                Intrinsics.checkNotNull((Object)string);
                peripheralProxyPeripheral.removeRemotePeripheral(string);
            }
            this.updatePeripherals();
        }
    }

    public final void addPosToTrack(@NotNull BlockPos pos, @NotNull Direction direction, @NotNull IPeripheral targetPeripheral) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)DIRECTION_TAG);
        Intrinsics.checkNotNullParameter((Object)targetPeripheral, (String)"targetPeripheral");
        RemotePeripheralRecord record = new RemotePeripheralRecord(pos, this.buildPeripheralName(targetPeripheral), direction, false, false, null, 56, null);
        this.remotePeripherals.put(pos, record);
        this.trackRecord(record, targetPeripheral);
    }

    public final boolean removePosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.remotePeripherals.containsKey(pos)) {
            RemotePeripheralRecord remotePeripheralRecord = this.remotePeripherals.get(pos);
            Intrinsics.checkNotNull((Object)remotePeripheralRecord);
            RemotePeripheralRecord remoteRecord = remotePeripheralRecord;
            this.remotePeripherals.remove(pos);
            this.untrackRecord(remoteRecord);
            return true;
        }
        return false;
    }

    private final void unload() {
        PeripheralProxyPeripheral peripheralProxyPeripheral = (PeripheralProxyPeripheral)this.getPeripheral();
        if (peripheralProxyPeripheral != null) {
            peripheralProxyPeripheral.purgePeripheral();
        }
        BlockStateUpdateEventBus.INSTANCE.removeBlockPos((Collection<? extends BlockPos>)this.remotePeripherals.keySet());
    }

    private final void scheduleConnectionsChanged() {
        this.refreshConnectionsRequired = true;
    }

    public void onNeighbourChange(@NotNull BlockPos neighbour) {
        Intrinsics.checkNotNullParameter((Object)neighbour, (String)"neighbour");
        if (Intrinsics.areEqual((Object)this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)PeripheralProxy.Companion.getORIENTATION())).m_122424_()), (Object)neighbour)) {
            this.refreshConnectionsRequired = true;
        }
    }

    public final void connectBlockPos(@NotNull Level level, @NotNull RemotePeripheralRecord record) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (level instanceof ServerLevel) {
            IPeripheral targetPeripheral = ComputerPlatformToolkit.INSTANCE.get().getPeripheral((ServerLevel)level, record.getTargetBlock(), Direction.NORTH);
            if (targetPeripheral == null) {
                PeripheralWorksCore.INSTANCE.getLogger().debug("Postpone {} for peripheral proxing, it doesn't contains any peripheral for now", (Object)record.getTargetBlock());
                this.peripheralConnectionIncomplete = true;
            } else {
                this.trackRecord(record, targetPeripheral);
                ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
            }
        }
    }

    public final void updateCachedStacks(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.f_46443_) {
            this.itemStackCacheBuilt = true;
            Iterable $this$forEach$iv = this.remotePeripherals.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RemotePeripheralRecord it = (RemotePeripheralRecord)element$iv;
                boolean bl = false;
                if (!it.getStack().m_41619_()) continue;
                ItemStack itemStack = level.m_8055_(it.getTargetBlock()).m_60734_().m_5456_().m_7968_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
                it.setStack(itemStack);
                if (!it.getStack().m_41619_()) continue;
                this.itemStackCacheBuilt = false;
            }
        }
    }

    @NotNull
    public CompoundTag saveInternalData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ListTag trackedBlockTag = new ListTag();
        Map<BlockPos, RemotePeripheralRecord> $this$forEach$iv = this.remotePeripherals;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<BlockPos, RemotePeripheralRecord>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, RemotePeripheralRecord> element$iv;
            Map.Entry<BlockPos, RemotePeripheralRecord> it = element$iv = iterator.next();
            boolean bl = false;
            trackedBlockTag.add((Object)it.getValue().toTag());
        }
        data.m_128365_(REMOTE_PERIPHERALS_TAG, (Tag)trackedBlockTag);
        return data;
    }

    private final void refreshConnection() {
        Direction direction;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (level2.f_46443_) {
            return;
        }
        this.refreshConnectionsRequired = false;
        BlockPos current = this.m_58899_();
        BlockPos offset = current.m_121945_(direction = ((Direction)this.m_58900_().m_61143_((Property)PeripheralProxy.Companion.getORIENTATION())).m_122424_());
        if (!level2.m_46749_(offset)) {
            return;
        }
        WiredElement wiredElement = (WiredElement)this.connectedElements.get(direction);
        if (wiredElement == null) {
            return;
        }
        WiredElement element = wiredElement;
        this.element.getNode().connectTo(element.getNode());
    }

    @NotNull
    public BlockState loadInternalData(@NotNull CompoundTag data, @Nullable BlockState state) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.m_128441_(REMOTE_PERIPHERALS_TAG)) {
            this.remotePeripherals.clear();
            ListTag internalList = data.m_128437_(REMOTE_PERIPHERALS_TAG, 10);
            Intrinsics.checkNotNull((Object)internalList);
            Iterable $this$forEach$iv = (Iterable)internalList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                RemotePeripheralRecord record = Companion.fromTag((CompoundTag)it);
                this.remotePeripherals.put(record.getTargetBlock(), record);
                if (this.f_58857_ == null) {
                    this.peripheralConnectionIncomplete = true;
                    this.listenerConnectionIncomplete = true;
                    PeripheralWorksCore.INSTANCE.getLogger().debug("Postpone of loading blockPos {}", (Object)this.m_58899_());
                    continue;
                }
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                this.connectBlockPos(level, record);
            }
            Level level = this.f_58857_;
            boolean bl = level != null ? level.f_46443_ : false;
            if (bl) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                this.updateCachedStacks(level2);
            }
        }
        if ((blockState = state) == null) {
            BlockState blockState2 = this.m_58900_();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
        }
        return blockState;
    }

    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getPeripheral() == null) {
            this.ensurePeripheralCreated(Direction.UP);
        }
        if (this.listenerConnectionIncomplete || this.peripheralConnectionIncomplete) {
            boolean bl;
            boolean bl2;
            block12: {
                boolean bl3;
                Iterable $this$any$iv;
                boolean $i$f$any;
                PeripheralProxyBlockEntity peripheralProxyBlockEntity;
                RemotePeripheralRecord it;
                block11: {
                    Iterable $this$forEach$iv = this.remotePeripherals.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (RemotePeripheralRecord)element$iv;
                        boolean bl4 = false;
                        if (it.getConnectedToListener() && it.getConnectedToPeripheral()) continue;
                        this.connectBlockPos(level, it);
                    }
                    $this$forEach$iv = this.remotePeripherals.values();
                    peripheralProxyBlockEntity = this;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (RemotePeripheralRecord)element$iv;
                            boolean bl5 = false;
                            if (!(!it.getConnectedToListener())) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                peripheralProxyBlockEntity.listenerConnectionIncomplete = bl2 = bl3;
                $this$any$iv = this.remotePeripherals.values();
                peripheralProxyBlockEntity = this;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (RemotePeripheralRecord)element$iv;
                        boolean bl6 = false;
                        if (!(!it.getConnectedToPeripheral())) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            peripheralProxyBlockEntity.peripheralConnectionIncomplete = bl2 = bl;
        }
        Ref.BooleanRef dataModified = new Ref.BooleanRef();
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.traverseEvents(this.lastConsumedEventID, arg_0 -> PeripheralProxyBlockEntity.handleTick$lambda$3(this, level, dataModified, arg_0));
        if (dataModified.element) {
            PeripheralWorksCore.INSTANCE.getLogger().debug("Pushing information after removing some tracked position, {}", this.remotePeripherals);
            ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        }
        if (this.refreshConnectionsRequired) {
            this.refreshConnection();
        }
    }

    public void m_7651_() {
        block3: {
            block2: {
                this.unload();
                if (this.f_58857_ == null) break block2;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (level.f_46443_) break block3;
            }
            this.element.getNode().remove();
        }
        super.m_7651_();
    }

    public void destroy() {
        block3: {
            block2: {
                if (this.f_58857_ == null) break block2;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (level.f_46443_) break block3;
            }
            this.element.getNode().remove();
        }
        this.unload();
    }

    private static final void connectedElements$lambda$0(PeripheralProxyBlockEntity this$0, Direction x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x == ((Direction)this$0.m_58900_().m_61143_((Property)PeripheralProxy.Companion.getORIENTATION())).m_122424_()) {
            this$0.scheduleConnectionsChanged();
        }
    }

    private static final void handleTick$lambda$3(PeripheralProxyBlockEntity this$0, Level $level, Ref.BooleanRef $dataModified, BlockStateUpdateEventBus.BlockStateUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PeripheralWorksCore.INSTANCE.getLogger().debug("Processing event change {} {}", (Object)it, (Object)it.getPos());
        if (this$0.remotePeripherals.containsKey(it.getPos())) {
            RemotePeripheralRecord record = this$0.remotePeripherals.get(it.getPos());
            PeripheralWorksCore.INSTANCE.getLogger().debug("Extracted record {} for {}", (Object)record, (Object)it.getPos());
            if (record != null) {
                this$0.untrackRecord(record);
                if ($level instanceof ServerLevel) {
                    IPeripheral targetPeripheral = ComputerPlatformToolkit.INSTANCE.get().getPeripheral((ServerLevel)$level, it.getPos(), record.getDirection());
                    if (targetPeripheral == null) {
                        PeripheralWorksCore.INSTANCE.getLogger().debug("Cannot find peripheral for {} purging it completely", (Object)it.getPos());
                        $dataModified.element = true;
                        this$0.remotePeripherals.remove(it.getPos());
                    } else {
                        PeripheralWorksCore.INSTANCE.getLogger().debug("Find peripheral {} for {}", (Object)targetPeripheral, (Object)it.getPos());
                        this$0.trackRecord(record, targetPeripheral);
                    }
                }
            }
        }
    }

    public static final /* synthetic */ PeripheralProxyPeripheral access$getPeripheral(PeripheralProxyBlockEntity $this) {
        return (PeripheralProxyPeripheral)$this.getPeripheral();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$Companion;", "", "<init>", "()V", "REMOTE_PERIPHERALS_TAG", "", "TARGET_BLOCK_TAG", "DIRECTION_TAG", "PERIPHERAL_NAME_TAG", "RESERVED_IDS_TAG", "fromTag", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemotePeripheralRecord fromTag(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            BlockPos targetBlock = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(PeripheralProxyBlockEntity.TARGET_BLOCK_TAG));
            Direction direction = (Direction)Direction.f_175356_.m_262792_(tag.m_128461_(PeripheralProxyBlockEntity.DIRECTION_TAG), (Enum)Direction.NORTH);
            String peripheralName = tag.m_128441_(PeripheralProxyBlockEntity.PERIPHERAL_NAME_TAG) ? tag.m_128461_(PeripheralProxyBlockEntity.PERIPHERAL_NAME_TAG) : null;
            Intrinsics.checkNotNull((Object)targetBlock);
            Intrinsics.checkNotNull((Object)direction);
            return new RemotePeripheralRecord(targetBlock, peripheralName, direction, false, false, null, 56, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$PeripheralProxyWiredElement;", "Ldan200/computercraft/shared/peripheral/modem/wired/WiredModemElement;", "be", "Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity;", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity;)V", "attachPeripheral", "", "name", "", "peripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "detachPeripheral", "getLevel", "Lnet/minecraft/world/level/Level;", "getPosition", "Lnet/minecraft/world/phys/Vec3;", "peripheralworks-forge-1.20.1"})
    public static final class PeripheralProxyWiredElement
    extends WiredModemElement {
        @NotNull
        private final PeripheralProxyBlockEntity be;

        public PeripheralProxyWiredElement(@NotNull PeripheralProxyBlockEntity be) {
            Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
            this.be = be;
        }

        protected void attachPeripheral(@NotNull String name, @NotNull IPeripheral peripheral) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
                PeripheralProxyPeripheral peripheralProxyPeripheral = PeripheralProxyBlockEntity.access$getPeripheral(this.be);
                if (peripheralProxyPeripheral == null) break block0;
                PeripheralHubPeripheral.attachRemotePeripheral$default(peripheralProxyPeripheral, peripheral, name, false, 4, null);
            }
        }

        protected void detachPeripheral(@NotNull String name) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                PeripheralProxyPeripheral peripheralProxyPeripheral = PeripheralProxyBlockEntity.access$getPeripheral(this.be);
                if (peripheralProxyPeripheral == null) break block0;
                peripheralProxyPeripheral.removeRemotePeripheral(name);
            }
        }

        @Nullable
        public Level getLevel() {
            return this.be.f_58857_;
        }

        @NotNull
        public Vec3 getPosition() {
            BlockPos blockPos = this.be.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            return BlockPosExtKt.toVec3((BlockPos)blockPos);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003JG\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/PeripheralProxyBlockEntity$RemotePeripheralRecord;", "", "targetBlock", "Lnet/minecraft/core/BlockPos;", "peripheralName", "", "direction", "Lnet/minecraft/core/Direction;", "connectedToListener", "", "connectedToPeripheral", "stack", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/core/BlockPos;Ljava/lang/String;Lnet/minecraft/core/Direction;ZZLnet/minecraft/world/item/ItemStack;)V", "getTargetBlock", "()Lnet/minecraft/core/BlockPos;", "getPeripheralName", "()Ljava/lang/String;", "setPeripheralName", "(Ljava/lang/String;)V", "getDirection", "()Lnet/minecraft/core/Direction;", "getConnectedToListener", "()Z", "setConnectedToListener", "(Z)V", "getConnectedToPeripheral", "setConnectedToPeripheral", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "toTag", "Lnet/minecraft/nbt/CompoundTag;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "peripheralworks-forge-1.20.1"})
    public static final class RemotePeripheralRecord {
        @NotNull
        private final BlockPos targetBlock;
        @Nullable
        private String peripheralName;
        @NotNull
        private final Direction direction;
        private boolean connectedToListener;
        private boolean connectedToPeripheral;
        @NotNull
        private ItemStack stack;

        public RemotePeripheralRecord(@NotNull BlockPos targetBlock, @Nullable String peripheralName, @NotNull Direction direction, boolean connectedToListener, boolean connectedToPeripheral, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)PeripheralProxyBlockEntity.TARGET_BLOCK_TAG);
            Intrinsics.checkNotNullParameter((Object)direction, (String)PeripheralProxyBlockEntity.DIRECTION_TAG);
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.targetBlock = targetBlock;
            this.peripheralName = peripheralName;
            this.direction = direction;
            this.connectedToListener = connectedToListener;
            this.connectedToPeripheral = connectedToPeripheral;
            this.stack = stack;
        }

        public /* synthetic */ RemotePeripheralRecord(BlockPos blockPos, String string, Direction direction, boolean bl, boolean bl2, ItemStack itemStack, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                ItemStack itemStack2 = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
                itemStack = itemStack2;
            }
            this(blockPos, string, direction, bl, bl2, itemStack);
        }

        @NotNull
        public final BlockPos getTargetBlock() {
            return this.targetBlock;
        }

        @Nullable
        public final String getPeripheralName() {
            return this.peripheralName;
        }

        public final void setPeripheralName(@Nullable String string) {
            this.peripheralName = string;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final boolean getConnectedToListener() {
            return this.connectedToListener;
        }

        public final void setConnectedToListener(boolean bl) {
            this.connectedToListener = bl;
        }

        public final boolean getConnectedToPeripheral() {
            return this.connectedToPeripheral;
        }

        public final void setConnectedToPeripheral(boolean bl) {
            this.connectedToPeripheral = bl;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        public final void setStack(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
            this.stack = itemStack;
        }

        @NotNull
        public final CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(PeripheralProxyBlockEntity.TARGET_BLOCK_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.targetBlock));
            tag.m_128359_(PeripheralProxyBlockEntity.DIRECTION_TAG, this.direction.m_7912_());
            if (this.peripheralName != null) {
                String string = this.peripheralName;
                Intrinsics.checkNotNull((Object)string);
                tag.m_128359_(PeripheralProxyBlockEntity.PERIPHERAL_NAME_TAG, string);
            }
            return tag;
        }

        @NotNull
        public final BlockPos component1() {
            return this.targetBlock;
        }

        @Nullable
        public final String component2() {
            return this.peripheralName;
        }

        @NotNull
        public final Direction component3() {
            return this.direction;
        }

        public final boolean component4() {
            return this.connectedToListener;
        }

        public final boolean component5() {
            return this.connectedToPeripheral;
        }

        @NotNull
        public final ItemStack component6() {
            return this.stack;
        }

        @NotNull
        public final RemotePeripheralRecord copy(@NotNull BlockPos targetBlock, @Nullable String peripheralName, @NotNull Direction direction, boolean connectedToListener, boolean connectedToPeripheral, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)PeripheralProxyBlockEntity.TARGET_BLOCK_TAG);
            Intrinsics.checkNotNullParameter((Object)direction, (String)PeripheralProxyBlockEntity.DIRECTION_TAG);
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new RemotePeripheralRecord(targetBlock, peripheralName, direction, connectedToListener, connectedToPeripheral, stack);
        }

        public static /* synthetic */ RemotePeripheralRecord copy$default(RemotePeripheralRecord remotePeripheralRecord, BlockPos blockPos, String string, Direction direction, boolean bl, boolean bl2, ItemStack itemStack, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = remotePeripheralRecord.targetBlock;
            }
            if ((n & 2) != 0) {
                string = remotePeripheralRecord.peripheralName;
            }
            if ((n & 4) != 0) {
                direction = remotePeripheralRecord.direction;
            }
            if ((n & 8) != 0) {
                bl = remotePeripheralRecord.connectedToListener;
            }
            if ((n & 0x10) != 0) {
                bl2 = remotePeripheralRecord.connectedToPeripheral;
            }
            if ((n & 0x20) != 0) {
                itemStack = remotePeripheralRecord.stack;
            }
            return remotePeripheralRecord.copy(blockPos, string, direction, bl, bl2, itemStack);
        }

        @NotNull
        public String toString() {
            return "RemotePeripheralRecord(targetBlock=" + this.targetBlock + ", peripheralName=" + this.peripheralName + ", direction=" + this.direction + ", connectedToListener=" + this.connectedToListener + ", connectedToPeripheral=" + this.connectedToPeripheral + ", stack=" + this.stack + ")";
        }

        public int hashCode() {
            int result = this.targetBlock.hashCode();
            result = result * 31 + (this.peripheralName == null ? 0 : this.peripheralName.hashCode());
            result = result * 31 + this.direction.hashCode();
            result = result * 31 + Boolean.hashCode(this.connectedToListener);
            result = result * 31 + Boolean.hashCode(this.connectedToPeripheral);
            result = result * 31 + this.stack.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemotePeripheralRecord)) {
                return false;
            }
            RemotePeripheralRecord remotePeripheralRecord = (RemotePeripheralRecord)other;
            if (!Intrinsics.areEqual((Object)this.targetBlock, (Object)remotePeripheralRecord.targetBlock)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.peripheralName, (Object)remotePeripheralRecord.peripheralName)) {
                return false;
            }
            if (this.direction != remotePeripheralRecord.direction) {
                return false;
            }
            if (this.connectedToListener != remotePeripheralRecord.connectedToListener) {
                return false;
            }
            if (this.connectedToPeripheral != remotePeripheralRecord.connectedToPeripheral) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stack, (Object)remotePeripheralRecord.stack);
        }
    }
}

