/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.peripheralworks.xplat.ModPlatform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001cR\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEEnergyStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "Lappeng/api/networking/energy/IEnergyService;", "energyService", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "entity", "<init>", "(Lappeng/api/networking/energy/IEnergyService;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "", "setChanged", "()V", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "stack", "storeEnergy", "(Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Ljava/util/function/Predicate;", "predicate", "", "limit", "takeEnergy", "(Ljava/util/function/Predicate;J)Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "Lappeng/api/networking/energy/IEnergyService;", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "getCapacity", "()J", "capacity", "", "getCanExtract", "()Z", "canExtract", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "energy", "getCanReceive", "canReceive", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "unit", "peripheralworks-fabric-1.20.1"})
public final class AEEnergyStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final IEnergyService energyService;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEEnergyStorage(@NotNull IEnergyService energyService, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)energyService, (String)"energyService");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.energyService = energyService;
        this.entity = entity;
    }

    public long getCapacity() {
        return (long)this.energyService.getMaxStoredPower();
    }

    public boolean getCanExtract() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)this.energyService.getStoredPower());
    }

    public void setChanged() {
        this.entity.method_5431();
    }

    public boolean getCanReceive() {
        return true;
    }

    @NotNull
    public EnergyUnit getUnit() {
        return ModPlatform.INSTANCE.getCommonEnergy();
    }

    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)Energies.INSTANCE.getREDSTONE_FLUX())) {
            return stack;
        }
        double leftover = this.energyService.injectPower((double)stack.getAmount(), Actionable.MODULATE);
        return stack.copyWithCount((long)leftover);
    }

    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(ModPlatform.INSTANCE.getCommonEnergy(), 0L);
        }
        double extracted = this.energyService.extractAEPower((double)limit, Actionable.MODULATE, PowerMultiplier.CONFIG);
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)extracted);
    }
}

