/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.powah;

import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.EnergyStorageUtils;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0010H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0016J&\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0010H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006,"}, d2={"Lsite/siredvin/peripheralworks/integrations/powah/PowahEnergyStorageWrapper;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "storage", "Lowmii/powah/lib/block/AbstractEnergyStorage;", "<init>", "(Lowmii/powah/lib/block/AbstractEnergyStorage;)V", "maxStackSize", "", "getMaxStackSize", "()Ljava/lang/Long;", "operator", "Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getOperator", "()Lsite/siredvin/broccolium/modules/storage/base/api/SomethingOperator;", "canExtract", "", "getCanExtract", "()Z", "firstEnergy", "getFirstEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "receiveRateLimit", "getReceiveRateLimit", "()J", "extractRateLimit", "getExtractRateLimit", "setChanged", "", "canReceive", "getCanReceive", "unit", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "store", "stack", "simulate", "getContent", "", "take", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class PowahEnergyStorageWrapper
implements AgnosticEnergyStorage {
    @NotNull
    private final AbstractEnergyStorage<?, ?> storage;

    public PowahEnergyStorageWrapper(@NotNull AbstractEnergyStorage<?, ?> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    @NotNull
    public Long getMaxStackSize() {
        return this.storage.getEnergy().getCapacity();
    }

    @NotNull
    public SomethingOperator<AgnosticEnergyStack, Long> getOperator() {
        return (SomethingOperator)EnergyStorageUtils.INSTANCE;
    }

    public boolean getCanExtract() {
        return this.storage.canExtractEnergy(null);
    }

    @NotNull
    public AgnosticEnergyStack getFirstEnergy() {
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), this.storage.getEnergy().getStored());
    }

    public long getReceiveRateLimit() {
        AbstractBlock abstractBlock = this.storage.getBlock();
        AbstractEnergyBlock abstractEnergyBlock = abstractBlock instanceof AbstractEnergyBlock ? (AbstractEnergyBlock)abstractBlock : null;
        return abstractEnergyBlock != null && (abstractEnergyBlock = (IEnergyConfig)abstractEnergyBlock.getConfig()) != null ? abstractEnergyBlock.getTransfer((Enum)this.storage.getVariant()) : Long.MAX_VALUE;
    }

    public long getExtractRateLimit() {
        return this.getReceiveRateLimit();
    }

    public void setChanged() {
        this.storage.m_6596_();
    }

    public boolean getCanReceive() {
        return this.storage.canReceiveEnergy(null);
    }

    @NotNull
    public final EnergyUnit getUnit() {
        return PlatformToolkit.INSTANCE.get().getCommonEnergy();
    }

    @NotNull
    public AgnosticEnergyStack store(@NotNull AgnosticEnergyStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(PlatformToolkit.INSTANCE.get().getCommonEnergy())) {
            return stack;
        }
        if (!this.storage.canReceiveEnergy(null)) {
            return stack;
        }
        long receivedEnergy = this.storage.receiveEnergy(stack.getAmount(), simulate, null);
        return stack.copyWithCount(stack.getAmount() - receivedEnergy);
    }

    @NotNull
    public Iterator<AgnosticEnergyStack> getContent() {
        return CollectionsKt.listOf((Object)this.getFirstEnergy()).iterator();
    }

    @NotNull
    public AgnosticEnergyStack take(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit, boolean simulate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getFirstEnergy())) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        long extractedEnergy = this.storage.extractEnergy(limit, simulate, null);
        if (extractedEnergy == 0L) {
            return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), 0L);
        }
        return new AgnosticEnergyStack(PlatformToolkit.INSTANCE.get().getCommonEnergy(), extractedEnergy);
    }
}

