/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.client.configurator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import site.siredvin.peripheralworks.client.configurator.ConfigurationModeRender;
import site.siredvin.peripheralworks.client.configurator.FlareRenderer;
import site.siredvin.peripheralworks.common.blockentity.NetworkManagerBlockEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000fJ@\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Lsite/siredvin/peripheralworks/client/configurator/NetworkManagerClientRender;", "Lsite/siredvin/peripheralworks/client/configurator/ConfigurationModeRender;", "<init>", "()V", "renderText", "", "matrices", "Lcom/mojang/blaze3d/vertex/PoseStack;", "text", "", "x", "", "y", "z", "lightLevel", "", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "color", "render", "minecraft", "Lnet/minecraft/client/Minecraft;", "source", "Lnet/minecraft/core/BlockPos;", "poseStack", "partialTick", "", "camera", "Lnet/minecraft/client/Camera;", "gameRenderer", "Lnet/minecraft/client/renderer/GameRenderer;", "projectionMatrix", "Lorg/joml/Matrix4f;", "DrawingInstructions", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNetworkManagerClientRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkManagerClientRender.kt\nsite/siredvin/peripheralworks/client/configurator/NetworkManagerClientRender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 NetworkManagerClientRender.kt\nsite/siredvin/peripheralworks/client/configurator/NetworkManagerClientRender\n*L\n62#1:106,2\n*E\n"})
public final class NetworkManagerClientRender
implements ConfigurationModeRender {
    @NotNull
    public static final NetworkManagerClientRender INSTANCE = new NetworkManagerClientRender();

    private NetworkManagerClientRender() {
    }

    public final void renderText(@NotNull PoseStack matrices, @NotNull String text, double x, double y, double z, int lightLevel, @NotNull MultiBufferSource buffer, int color) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        matrices.m_85836_();
        float scaleFactor = 0.01f;
        matrices.m_85837_(x, y, z);
        matrices.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        Font font = Minecraft.m_91087_().f_91062_;
        float offset = -font.m_92895_(text) / 2;
        int opacity = 0x66000000;
        font.m_271703_(text, offset, 0.0f, color, false, matrix4f, buffer, Font.DisplayMode.NORMAL, opacity, lightLevel);
        matrices.m_85849_();
    }

    public static /* synthetic */ void renderText$default(NetworkManagerClientRender networkManagerClientRender, PoseStack poseStack, String string, double d, double d2, double d3, int n, MultiBufferSource multiBufferSource, int n2, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = 0xFFFFFF;
        }
        networkManagerClientRender.renderText(poseStack, string, d, d2, d3, n, multiBufferSource, n2);
    }

    @Override
    public void render(@NotNull Minecraft minecraft, @NotNull BlockPos source, @NotNull PoseStack poseStack, float partialTick, @NotNull Camera camera, @NotNull GameRenderer gameRenderer, @NotNull Matrix4f projectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)gameRenderer, (String)"gameRenderer");
        Intrinsics.checkNotNullParameter((Object)projectionMatrix, (String)"projectionMatrix");
        FlareRenderer.INSTANCE.initFlareRenderer(poseStack, camera);
        ClientLevel clientLevel = minecraft.f_91073_;
        BlockEntity blockEntity = clientLevel != null ? clientLevel.m_7702_(source) : null;
        NetworkManagerBlockEntity networkManagerBlockEntity = blockEntity instanceof NetworkManagerBlockEntity ? (NetworkManagerBlockEntity)blockEntity : null;
        if (networkManagerBlockEntity == null) {
            return;
        }
        NetworkManagerBlockEntity entity = networkManagerBlockEntity;
        Iterable $this$forEach$iv = entity.getClientBlockCache().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            double baseHeight = 1.2;
            String string = ((NetworkManagerBlockEntity.DrawingInstructions)it.getValue()).getPeripheralName();
            double d = (double)((BlockPos)it.getKey()).m_123341_() + 0.5;
            double d2 = (double)((BlockPos)it.getKey()).m_123342_() + baseHeight;
            double d3 = (double)((BlockPos)it.getKey()).m_123343_() + 0.5;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            Intrinsics.checkNotNullExpressionValue((Object)bufferSource, (String)"bufferSource(...)");
            NetworkManagerClientRender.renderText$default(INSTANCE, poseStack, string, d, d2, d3, 0xF00000, (MultiBufferSource)bufferSource, 0, 128, null);
            for (String extraName : ((NetworkManagerBlockEntity.DrawingInstructions)it.getValue()).getExtraNames()) {
                double d4 = (double)((BlockPos)it.getKey()).m_123341_() + 0.5;
                double d5 = (double)((BlockPos)it.getKey()).m_123342_() + (baseHeight += 0.15);
                double d6 = (double)((BlockPos)it.getKey()).m_123343_() + 0.5;
                MultiBufferSource.BufferSource bufferSource2 = minecraft.m_91269_().m_110104_();
                Intrinsics.checkNotNullExpressionValue((Object)bufferSource2, (String)"bufferSource(...)");
                INSTANCE.renderText(poseStack, extraName, d4, d5, d6, 0xF00000, (MultiBufferSource)bufferSource2, 0xFF0000);
            }
            for (String group : ((NetworkManagerBlockEntity.DrawingInstructions)it.getValue()).getGroups()) {
                baseHeight += 0.15;
                NetworkManagerBlockEntity.PeripheralGroup peripheralGroup = entity.getPeripheralGroups().get(group);
                Intrinsics.checkNotNull((Object)peripheralGroup);
                int color = peripheralGroup.getColor();
                String string2 = "group:" + group;
                double d7 = (double)((BlockPos)it.getKey()).m_123341_() + 0.5;
                double d8 = (double)((BlockPos)it.getKey()).m_123342_() + baseHeight;
                double d9 = (double)((BlockPos)it.getKey()).m_123343_() + 0.5;
                MultiBufferSource.BufferSource bufferSource3 = minecraft.m_91269_().m_110104_();
                Intrinsics.checkNotNullExpressionValue((Object)bufferSource3, (String)"bufferSource(...)");
                INSTANCE.renderText(poseStack, string2, d7, d8, d9, 0xF00000, (MultiBufferSource)bufferSource3, color == -1 ? 0xFFFFFF : color);
            }
        }
        FlareRenderer.INSTANCE.uninitFlareRenderer(poseStack);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/peripheralworks/client/configurator/NetworkManagerClientRender$DrawingInstructions;", "", "peripheralName", "", "<init>", "(Ljava/lang/String;)V", "getPeripheralName", "()Ljava/lang/String;", "extraNames", "", "getExtraNames", "()Ljava/util/List;", "groups", "getGroups", "peripheralworks-forge-1.20.1"})
    public static final class DrawingInstructions {
        @NotNull
        private final String peripheralName;
        @NotNull
        private final List<String> extraNames;
        @NotNull
        private final List<String> groups;

        public DrawingInstructions(@NotNull String peripheralName) {
            Intrinsics.checkNotNullParameter((Object)peripheralName, (String)"peripheralName");
            this.peripheralName = peripheralName;
            this.extraNames = new ArrayList();
            this.groups = new ArrayList();
        }

        @NotNull
        public final String getPeripheralName() {
            return this.peripheralName;
        }

        @NotNull
        public final List<String> getExtraNames() {
            return this.extraNames;
        }

        @NotNull
        public final List<String> getGroups() {
            return this.groups;
        }
    }
}

