/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.common.blockentity;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.base.api.IObservingBlockEntity;
import site.siredvin.broccolium.modules.base.api.ISyncingBlockEntity;
import site.siredvin.broccolium.modules.base.block.FacingBlockEntityBlock;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.common.events.BlockStateUpdateEventBus;
import site.siredvin.peripheralworks.common.setup.BlockEntityTypes;
import site.siredvin.peripheralworks.computercraft.peripherals.RemoteObserverPeripheral;
import site.siredvin.tweakium.modules.peripheral.blockentity.MutablePeripheralBlockEntity;
import site.siredvin.tweakium.modules.peripheral.representation.EnrichersKt;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001*B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u001a\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u0007H\u0016J \u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity;", "Lsite/siredvin/tweakium/modules/peripheral/blockentity/MutablePeripheralBlockEntity;", "Lsite/siredvin/peripheralworks/computercraft/peripherals/RemoteObserverPeripheral;", "Lsite/siredvin/broccolium/modules/base/api/IObservingBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "lastConsumedEventID", "", "trackedBlocks", "", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "trackedBlocksView", "", "getTrackedBlocksView", "()Ljava/util/List;", "createPeripheral", "side", "isPosApplicable", "", "pos", "togglePos", "addPosToTrack", "", "removePosToTrack", "unload", "saveInternalData", "Lnet/minecraft/nbt/CompoundTag;", "data", "loadInternalData", "state", "handleTick", "level", "Lnet/minecraft/world/level/Level;", "setRemoved", "destroy", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRemoteObserverBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteObserverBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1863#2,2:119\n1863#2,2:121\n1863#2,2:123\n*S KotlinDebug\n*F\n+ 1 RemoteObserverBlockEntity.kt\nsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity\n*L\n79#1:119,2\n87#1:121,2\n94#1:123,2\n*E\n"})
public final class RemoteObserverBlockEntity
extends MutablePeripheralBlockEntity<RemoteObserverPeripheral>
implements IObservingBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastConsumedEventID;
    @NotNull
    private final List<BlockPos> trackedBlocks;
    @NotNull
    public static final String TRACKED_BLOCKS_TAG = "trackedBlocks";

    public RemoteObserverBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntityType<RemoteObserverBlockEntity> blockEntityType = BlockEntityTypes.INSTANCE.getREMOTE_OBSERVER().get();
        Intrinsics.checkNotNullExpressionValue(blockEntityType, (String)"get(...)");
        super(blockEntityType, blockPos, blockState);
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.getLastEventID() - 1L;
        this.trackedBlocks = new ArrayList();
    }

    private final Direction getFacing() {
        Comparable comparable = this.m_58900_().m_61143_((Property)FacingBlockEntityBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Direction)comparable;
    }

    @NotNull
    public final List<BlockPos> getTrackedBlocksView() {
        return this.trackedBlocks;
    }

    @NotNull
    protected RemoteObserverPeripheral createPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new RemoteObserverPeripheral(this);
    }

    public final boolean isPosApplicable(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)pos, (Object)this.m_58899_())) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_58899_(), (double)PeripheralWorksConfig.INSTANCE.getRemoteObserverMaxRange());
    }

    public final boolean togglePos(@NotNull BlockPos pos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.trackedBlocks.contains(pos)) {
            this.removePosToTrack(pos);
            bl = false;
        } else {
            this.addPosToTrack(pos);
            bl = true;
        }
        boolean blockAdded = bl;
        ISyncingBlockEntity.DefaultImpls.pushInternalDataChangeToClient$default((ISyncingBlockEntity)((ISyncingBlockEntity)this), null, (int)1, null);
        return blockAdded;
    }

    public final void addPosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.trackedBlocks.add(pos);
        BlockPos[] blockPosArray = new BlockPos[]{pos};
        BlockStateUpdateEventBus.INSTANCE.addBlockPos(blockPosArray);
    }

    public final void removePosToTrack(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.trackedBlocks.remove(pos)) {
            BlockPos[] blockPosArray = new BlockPos[]{pos};
            BlockStateUpdateEventBus.INSTANCE.removeBlockPos(blockPosArray);
        }
    }

    private final void unload() {
        BlockStateUpdateEventBus.INSTANCE.removeBlockPos((Collection<? extends BlockPos>)this.trackedBlocks);
    }

    @NotNull
    public CompoundTag saveInternalData(@NotNull CompoundTag data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ListTag trackedBlockTag = new ListTag();
        Iterable $this$forEach$iv = this.trackedBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            trackedBlockTag.add((Object)NbtUtils.m_129224_((BlockPos)it));
        }
        data.m_128365_(TRACKED_BLOCKS_TAG, (Tag)trackedBlockTag);
        return data;
    }

    @NotNull
    public BlockState loadInternalData(@NotNull CompoundTag data, @Nullable BlockState state) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.m_128441_(TRACKED_BLOCKS_TAG)) {
            ListTag internalList = data.m_128437_(TRACKED_BLOCKS_TAG, 10);
            Intrinsics.checkNotNull((Object)internalList);
            Iterable $this$forEach$iv = (Iterable)internalList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)((CompoundTag)it));
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"readBlockPos(...)");
                this.addPosToTrack(blockPos);
            }
        }
        if ((blockState = state) == null) {
            BlockState blockState2 = this.m_58900_();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
        }
        return blockState;
    }

    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.lastConsumedEventID = BlockStateUpdateEventBus.INSTANCE.traverseEvents(this.lastConsumedEventID, arg_0 -> RemoteObserverBlockEntity.handleTick$lambda$0(this, arg_0));
    }

    public void m_7651_() {
        this.unload();
        super.m_7651_();
    }

    public void destroy() {
        this.unload();
    }

    private static final void handleTick$lambda$0(RemoteObserverBlockEntity this$0, BlockStateUpdateEventBus.BlockStateUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.getConnectedComputers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IComputerAccess computer = (IComputerAccess)element$iv;
            boolean bl = false;
            Map previousState = LuaRepresentation.INSTANCE.forBlockState(it.getPrevious());
            Map currentState = LuaRepresentation.INSTANCE.forBlockState(it.getCurrent());
            EnrichersKt.getStateProperties().accept(it.getPrevious(), previousState);
            EnrichersKt.getStateProperties().accept(it.getCurrent(), currentState);
            Object[] objectArray = new Object[3];
            BlockPos blockPos = it.getPos();
            Direction direction = this$0.getFacing();
            BlockPos blockPos2 = this$0.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            objectArray[0] = LuaRepresentation.INSTANCE.forBlockPos(blockPos, direction, blockPos2);
            objectArray[1] = previousState;
            objectArray[2] = currentState;
            computer.queueEvent("block_change", objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/common/blockentity/RemoteObserverBlockEntity$Companion;", "", "<init>", "()V", "TRACKED_BLOCKS_TAG", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

