/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.configurator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.common.blockentity.EntityLinkBlockEntity;
import site.siredvin.peripheralworks.data.ModText;
import site.siredvin.peripheralworks.data.ModTooltip;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;
import site.siredvin.peripheralworks.utils.HelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralworks/subsystem/configurator/EntityLinkMode;", "Lsite/siredvin/peripheralworks/subsystem/configurator/ConfigurationMode;", "<init>", "()V", "modeID", "Lnet/minecraft/resources/ResourceLocation;", "getModeID", "()Lnet/minecraft/resources/ResourceLocation;", "description", "Lnet/minecraft/network/chat/Component;", "getDescription", "()Lnet/minecraft/network/chat/Component;", "onBlockClick", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "configurationTarget", "Lnet/minecraft/core/BlockPos;", "stack", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "level", "Lnet/minecraft/world/level/Level;", "peripheralworks-forge-1.20.1"})
public final class EntityLinkMode
implements ConfigurationMode {
    @NotNull
    public static final EntityLinkMode INSTANCE = new EntityLinkMode();

    private EntityLinkMode() {
    }

    @Override
    @NotNull
    public ResourceLocation getModeID() {
        return HelpersKt.modId("entity_link");
    }

    @Override
    @NotNull
    public Component getDescription() {
        return (Component)ModTooltip.ENTITY_LINK_MODE.getText();
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onBlockClick(@NotNull BlockPos configurationTarget, @NotNull ItemStack stack, @NotNull Player player, @NotNull BlockHitResult hit, @NotNull Level level) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)configurationTarget, (String)"configurationTarget");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack itemInOffhand = player.m_21120_(InteractionHand.OFF_HAND);
        BlockEntity blockEntity2 = level.m_7702_(configurationTarget);
        EntityLinkBlockEntity entityLinkBlockEntity = blockEntity2 instanceof EntityLinkBlockEntity ? (EntityLinkBlockEntity)blockEntity2 : null;
        if (entityLinkBlockEntity == null) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        EntityLinkBlockEntity blockEntity3 = entityLinkBlockEntity;
        if (player.m_20089_() != Pose.CROUCHING) {
            MutableComponent message;
            MutableComponent mutableComponent = message = blockEntity3.getUpgrades().getScanner() ? ModText.ENTITY_LINK_UPGRADES.getText().m_130946_("\n").m_130946_("  ").m_7220_((Component)ModText.ENTITY_LINK_UPGRADE_SCANNER.getText()) : ModText.ENTITY_LINK_DOES_NOT_HAVE_UPGRADES.getText();
            if (level.f_46443_) {
                player.m_213846_((Component)message);
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19090_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        if (!itemInOffhand.m_41619_()) {
            InteractionResultHolder interactionResultHolder;
            Intrinsics.checkNotNull((Object)itemInOffhand);
            if (blockEntity3.isSuitableUpgrade(itemInOffhand)) {
                player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                blockEntity3.injectUpgrade(itemInOffhand);
                InteractionResultHolder message = InteractionResultHolder.m_19090_((Object)stack);
                Intrinsics.checkNotNull((Object)message);
                interactionResultHolder = message;
            } else {
                if (level.f_46443_) {
                    player.m_5661_((Component)ModText.ITEM_IS_NOT_SUITABLE_FOR_UPGRADE.getText(), false);
                }
                InteractionResultHolder message = InteractionResultHolder.m_19090_((Object)stack);
                Intrinsics.checkNotNull((Object)message);
                interactionResultHolder = message;
            }
            return interactionResultHolder;
        }
        ItemStack ejectedUpdate = blockEntity3.ejectUpgrade();
        if (!ejectedUpdate.m_41619_()) {
            player.m_21008_(InteractionHand.OFF_HAND, ejectedUpdate);
            blockEntity2 = InteractionResultHolder.m_19090_((Object)stack);
            Intrinsics.checkNotNull((Object)blockEntity2);
            blockEntity = blockEntity2;
        } else {
            if (level.f_46443_) {
                player.m_5661_((Component)ModText.ENTITY_LINK_DOES_NOT_HAVE_UPGRADES.getText(), false);
            }
            blockEntity2 = InteractionResultHolder.m_19090_((Object)stack);
            Intrinsics.checkNotNull((Object)blockEntity2);
            blockEntity = blockEntity2;
        }
        return blockEntity;
    }
}

