/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import site.siredvin.peripheralworks.api.IItemStackHolder;
import site.siredvin.peripheralworks.common.block.BasePedestal;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001(B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001cJ@\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0010H\u0002J8\u0010#\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001aH\u0002\u00a8\u0006)"}, d2={"Lsite/siredvin/peripheralworks/client/renderer/PedestalTileRenderer;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsite/siredvin/peripheralworks/api/IItemStackHolder;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "<init>", "()V", "getItemTranslate", "Lorg/joml/Vector3d;", "direction", "Lnet/minecraft/core/Direction;", "getLabelTranslate", "itemRotation", "Lorg/joml/Quaternionf;", "itemTimeRotation", "time", "", "render", "", "blockEntity", "f", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "(Lnet/minecraft/world/level/block/entity/BlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "renderItem", "stack", "Lnet/minecraft/world/item/ItemStack;", "combinedOverlay", "lightLevel", "scale", "renderLabel", "translation", "text", "Lnet/minecraft/network/chat/Component;", "color", "Companion", "peripheralworks-forge-1.20.1"})
public final class PedestalTileRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_UP = new Vector3d(0.5, 0.8, 0.5);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_UP = new Vector3d(0.5, 1.2, 0.5);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_DOWN = new Vector3d(0.5, 0.2, 0.5);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_DOWN = new Vector3d(0.5, -0.1, 0.5);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_NORTH = new Vector3d(0.5, 0.5, 0.1);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_NORTH = new Vector3d(0.5, 1.0, 0.5);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_SOUTH = new Vector3d(0.5, 0.5, 0.9);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_SOUTH = new Vector3d(0.5, 1.0, 0.5);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_EAST = new Vector3d(0.9, 0.5, 0.5);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_EAST = new Vector3d(0.5, 1.0, 0.5);
    @NotNull
    private static final Vector3d ITEM_TRANSLATE_WEST = new Vector3d(0.05, 0.5, 0.5);
    @NotNull
    private static final Vector3d LABEL_TRANSLATE_WEST = new Vector3d(0.5, 1.0, 0.5);

    @NotNull
    public final Vector3d getItemTranslate(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> ITEM_TRANSLATE_DOWN;
            case 2 -> ITEM_TRANSLATE_NORTH;
            case 3 -> ITEM_TRANSLATE_SOUTH;
            case 4 -> ITEM_TRANSLATE_EAST;
            case 5 -> ITEM_TRANSLATE_WEST;
            default -> ITEM_TRANSLATE_UP;
        };
    }

    @NotNull
    public final Vector3d getLabelTranslate(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> LABEL_TRANSLATE_DOWN;
            case 2 -> LABEL_TRANSLATE_NORTH;
            case 3 -> LABEL_TRANSLATE_SOUTH;
            case 4 -> LABEL_TRANSLATE_EAST;
            case 5 -> LABEL_TRANSLATE_WEST;
            case 6 -> LABEL_TRANSLATE_UP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Quaternionf itemRotation(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 2 -> Axis.f_252436_.m_252977_(90.0f);
            case 3 -> Axis.f_252436_.m_252977_(270.0f);
            case 5 -> Axis.f_252403_.m_252977_(90.0f);
            case 1 -> Axis.f_252529_.m_252977_(180.0f);
            default -> null;
        };
    }

    @NotNull
    public final Quaternionf itemTimeRotation(@NotNull Direction direction, float time) {
        Quaternionf quaternionf;
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        if (direction == Direction.WEST) {
            Quaternionf quaternionf2 = Axis.f_252529_.m_252977_(time % (float)360);
            Intrinsics.checkNotNull((Object)quaternionf2);
            quaternionf = quaternionf2;
        } else {
            Quaternionf quaternionf3 = Axis.f_252436_.m_252977_(time % (float)360);
            Intrinsics.checkNotNull((Object)quaternionf3);
            quaternionf = quaternionf3;
        }
        return quaternionf;
    }

    public void m_6922_(@NotNull T blockEntity, float f, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter(blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ItemStack storedStack = ((IItemStackHolder)blockEntity).getStoredStack();
        if (storedStack.m_41619_()) {
            return;
        }
        Direction blockDirection = (Direction)blockEntity.m_58900_().m_61143_((Property)BasePedestal.Companion.getFACING());
        if (((IItemStackHolder)blockEntity).getRenderItem()) {
            Intrinsics.checkNotNull((Object)blockDirection);
            this.renderItem(storedStack, blockDirection, poseStack, buffer, packedOverlay, packedLight, 0.8f);
        }
        if (((IItemStackHolder)blockEntity).getRenderLabel()) {
            Intrinsics.checkNotNull((Object)blockDirection);
            Vector3d vector3d = this.getLabelTranslate(blockDirection);
            Component component = storedStack.m_41786_();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getHoverName(...)");
            this.renderLabel(poseStack, buffer, packedLight, vector3d, component, 0xFFFFFF);
        }
    }

    private final void renderItem(ItemStack stack, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel, float scale) {
        Level level = (Level)Minecraft.m_91087_().f_91073_;
        Objects.requireNonNull(level);
        Level level2 = level;
        Intrinsics.checkNotNull((Object)level2);
        float time = level2.m_46467_() * (long)5;
        Vector3d translation = this.getItemTranslate(direction);
        Quaternionf itemRotation = this.itemRotation(direction);
        poseStack.m_85836_();
        poseStack.m_85837_(translation.x, translation.y, translation.z);
        if (itemRotation != null) {
            poseStack.m_252781_(itemRotation);
        }
        poseStack.m_252781_(this.itemTimeRotation(direction, time));
        poseStack.m_85841_(scale, scale, scale);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, level, null, lightLevel);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.GROUND, true, poseStack, buffer, lightLevel, combinedOverlay, model);
        poseStack.m_85849_();
    }

    private final void renderLabel(PoseStack stack, MultiBufferSource buffer, int lightLevel, Vector3d translation, Component text, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        stack.m_85836_();
        float scale = 0.01f;
        int opacity = 0x66000000;
        float offset = -font.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix = stack.m_85850_().m_252922_();
        stack.m_85837_(translation.x, translation.y, translation.z);
        stack.m_85841_(scale, scale, scale);
        stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        font.m_272077_(text, offset, 0.0f, color, false, matrix, buffer, Font.DisplayMode.NORMAL, opacity, lightLevel);
        stack.m_85849_();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/peripheralworks/client/renderer/PedestalTileRenderer$Companion;", "", "<init>", "()V", "ITEM_TRANSLATE_UP", "Lorg/joml/Vector3d;", "LABEL_TRANSLATE_UP", "getLABEL_TRANSLATE_UP", "()Lorg/joml/Vector3d;", "ITEM_TRANSLATE_DOWN", "LABEL_TRANSLATE_DOWN", "ITEM_TRANSLATE_NORTH", "LABEL_TRANSLATE_NORTH", "ITEM_TRANSLATE_SOUTH", "LABEL_TRANSLATE_SOUTH", "ITEM_TRANSLATE_EAST", "LABEL_TRANSLATE_EAST", "ITEM_TRANSLATE_WEST", "LABEL_TRANSLATE_WEST", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3d getLABEL_TRANSLATE_UP() {
            return LABEL_TRANSLATE_UP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

