/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.gtceu;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.computercraft.ComputerCraftProxy;
import site.siredvin.peripheralworks.integrations.gtceu.ControllablePeripheralPlugin;
import site.siredvin.peripheralworks.integrations.gtceu.WorkablePeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralworks/integrations/gtceu/Integration;", "Ljava/lang/Runnable;", "<init>", "()V", "run", "", "WorkablePeripheralPluginProvider", "ControllablePeripheralPluginProvider", "peripheralworks-forge-1.20.1"})
public final class Integration
implements Runnable {
    @Override
    public void run() {
        ComputerCraftProxy.INSTANCE.addProvider(WorkablePeripheralPluginProvider.INSTANCE);
        ComputerCraftProxy.INSTANCE.addProvider(ControllablePeripheralPluginProvider.INSTANCE);
        VanillaDetailRegistries.ITEM_STACK.addProvider(Integration::run$lambda$0);
    }

    private static final void run$lambda$0(Map data, ItemStack stack) {
        Item item = stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (item instanceof IGTTool) {
                IGTToolDefinition stats = ((IGTTool)item).getToolStats();
                Map gregData = new LinkedHashMap();
                int remainingDamage = ((IGTTool)item).getTotalMaxDurability(stack) - stack.m_41773_() + 1;
                if (stats.isSuitableForCrafting(stack)) {
                    gregData.put("craftingUses", remainingDamage / Math.max(1, stats.getDamagePerCraftingAction(stack)));
                }
                gregData.put("maxUses", ((IGTTool)item).getTotalMaxDurability(stack));
                gregData.put("generalUses", remainingDamage);
                Intrinsics.checkNotNull((Object)data);
                data.put("gtceu", gregData);
            }
            if (IntCircuitBehaviour.isIntegratedCircuit((ItemStack)stack)) {
                Intrinsics.checkNotNull((Object)data);
                data.put("gtceu", MapsKt.mapOf((Pair)TuplesKt.to((Object)"circuitConfiguration", (Object)IntCircuitBehaviour.getCircuitConfiguration((ItemStack)stack))));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/integrations/gtceu/Integration$ControllablePeripheralPluginProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class ControllablePeripheralPluginProvider
    implements PeripheralPluginProvider {
        @NotNull
        public static final ControllablePeripheralPluginProvider INSTANCE = new ControllablePeripheralPluginProvider();

        private ControllablePeripheralPluginProvider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return "gtceu:workable";
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            LazyOptional capability;
            BlockEntity blockEntity;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            BlockEntity blockEntity2 = blockEntity = level.m_7702_(pos);
            Object object = capability = blockEntity2 != null ? blockEntity2.getCapability(GTCapability.CAPABILITY_CONTROLLABLE) : null;
            if (capability != null && capability.isPresent()) {
                Object t = capability.resolve().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                return new ControllablePeripheralPlugin((IControllable)t);
            }
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralworks/integrations/gtceu/Integration$WorkablePeripheralPluginProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
    public static final class WorkablePeripheralPluginProvider
    implements PeripheralPluginProvider {
        @NotNull
        public static final WorkablePeripheralPluginProvider INSTANCE = new WorkablePeripheralPluginProvider();

        private WorkablePeripheralPluginProvider() {
        }

        @Override
        @NotNull
        public String getPluginType() {
            return "gtceu:workable";
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
            LazyOptional capability;
            BlockEntity blockEntity;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            BlockEntity blockEntity2 = blockEntity = level.m_7702_(pos);
            Object object = capability = blockEntity2 != null ? blockEntity2.getCapability(GTCapability.CAPABILITY_WORKABLE) : null;
            if (capability != null && capability.isPresent()) {
                Object t = capability.resolve().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                return new WorkablePeripheralPlugin((IWorkable)t);
            }
            return null;
        }
    }
}

