/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.blockentity.grid.AENetworkBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.storage.fluid.AgnosticFluidStack;
import site.siredvin.broccolium.modules.storage.fluid.ExtensionsKt;
import site.siredvin.broccolium.modules.storage.fluid.api.AgnosticFluidStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0019\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010\u0018\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage;", "Lsite/siredvin/broccolium/modules/storage/fluid/api/AgnosticFluidStorage;", "Lappeng/api/storage/MEStorage;", "storage", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "entity", "<init>", "(Lappeng/api/storage/MEStorage;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "", "Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "getFluids", "()Ljava/util/Iterator;", "", "setChanged", "()V", "", "", "getCapacities", "()Ljava/util/List;", "stack", "storeFluid", "(Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;)Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "Ljava/util/function/Predicate;", "predicate", "limit", "takeFluid", "(Ljava/util/function/Predicate;D)Lsite/siredvin/broccolium/modules/storage/fluid/AgnosticFluidStack;", "Lappeng/api/storage/MEStorage;", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "peripheralworks-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAEFluidStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AEFluidStorage.kt\nsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1611#2,9:51\n1863#2:60\n1864#2:62\n1620#2:63\n1#3:61\n1#3:64\n*S KotlinDebug\n*F\n+ 1 AEFluidStorage.kt\nsite/siredvin/peripheralworks/integrations/ae2/AEFluidStorage\n*L\n17#1:51,9\n17#1:60\n17#1:62\n17#1:63\n17#1:61\n*E\n"})
public final class AEFluidStorage
implements AgnosticFluidStorage {
    @NotNull
    private final MEStorage storage;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEFluidStorage(@NotNull MEStorage storage, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.storage = storage;
        this.entity = entity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<AgnosticFluidStack> getFluids() {
        void $this$mapNotNullTo$iv$iv;
        KeyCounter keyCounter = this.storage.getAvailableStacks();
        Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"getAvailableStacks(...)");
        Iterable $this$mapNotNull$iv = (Iterable)keyCounter;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AgnosticFluidStack agnosticFluidStack;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object2LongMap.Entry it = (Object2LongMap.Entry)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKey() instanceof AEFluidKey)) {
                agnosticFluidStack = null;
            } else {
                Object object = it.getKey();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
                FluidVariant fluidVariant = ((AEFluidKey)object).toVariant();
                Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"toVariant(...)");
                agnosticFluidStack = ExtensionsKt.toVanilla((FluidVariant)fluidVariant, (double)it.getLongValue());
            }
            if (agnosticFluidStack == null) continue;
            AgnosticFluidStack it$iv$iv = agnosticFluidStack;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ((List)destination$iv$iv).iterator();
    }

    public void setChanged() {
        this.entity.method_5431();
    }

    @NotNull
    public List<Double> getCapacities() {
        int n = SequencesKt.count((Sequence)SequencesKt.asSequence(this.getFluids())) + 1;
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Double.POSITIVE_INFINITY);
        }
        return arrayList;
    }

    @NotNull
    public AgnosticFluidStack storeFluid(@NotNull AgnosticFluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        long insertedAmount = this.storage.insert((AEKey)AEFluidKey.of((FluidVariant)ExtensionsKt.toVariant((AgnosticFluidStack)stack)), (long)stack.getPlatformAmount(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        if (insertedAmount == 0L) {
            return stack;
        }
        stack.shrink((double)insertedAmount / (double)PlatformToolkit.INSTANCE.get().getFluidCompactDivider());
        return stack;
    }

    @NotNull
    public AgnosticFluidStack takeFluid(@NotNull Predicate<AgnosticFluidStack> predicate, double limit) {
        Object v3;
        double platformLimit;
        block5: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            platformLimit = limit * (double)PlatformToolkit.INSTANCE.get().getFluidCompactDivider();
            KeyCounter keyCounter = this.storage.getAvailableStacks();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"getAvailableStacks(...)");
            Iterable iterable = (Iterable)keyCounter;
            for (Object t : iterable) {
                boolean bl;
                Object2LongMap.Entry it = (Object2LongMap.Entry)t;
                boolean bl2 = false;
                AEKey aeKey = (AEKey)it.getKey();
                if (!(aeKey instanceof AEFluidKey)) {
                    bl = false;
                } else {
                    FluidVariant fluidVariant = ((AEFluidKey)aeKey).toVariant();
                    Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"toVariant(...)");
                    bl = predicate.test(ExtensionsKt.toVanilla((FluidVariant)fluidVariant, (double)it.getLongValue()));
                }
                if (!bl) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        Object2LongMap.Entry entry = v3;
        if (entry == null) {
            return AgnosticFluidStack.Companion.getEMPTY();
        }
        Object2LongMap.Entry fluidToTransfer = entry;
        long extractedAmount = this.storage.extract((AEKey)fluidToTransfer.getKey(), Math.min((long)platformLimit, fluidToTransfer.getLongValue()), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        if (extractedAmount == 0L) {
            return AgnosticFluidStack.Companion.getEMPTY();
        }
        Object object = fluidToTransfer.getKey();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
        FluidVariant fluidVariant = ((AEFluidKey)object).toVariant();
        Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"toVariant(...)");
        return ExtensionsKt.toVanilla((FluidVariant)fluidVariant, (double)extractedAmount);
    }
}

