/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.peripherals;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.util.NBTUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.peripheralworks.common.blockentity.RecipeRegistryBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.computercraft.peripherals.RecipeRegistryPeripheral;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeRegistryToolkit;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.ext.IArgumentsKt;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 $2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0013H\u0007J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0013H\u0007J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0013\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u001f\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RecipeRegistryPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/peripheralworks/common/blockentity/RecipeRegistryBlockEntity;", "blockEntity", "<init>", "(Lsite/siredvin/peripheralworks/common/blockentity/RecipeRegistryBlockEntity;)V", "air", "Lnet/minecraft/world/item/Item;", "kotlin.jvm.PlatformType", "getAir$annotations", "()V", "getAir", "()Lnet/minecraft/world/item/Item;", "isEnabled", "", "()Z", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "getTypes", "Ldan200/computercraft/api/lua/MethodResult;", "get", "recipeID", "getRaw", "list", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "search", "equals", "other", "hashCode", "", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRecipeRegistryPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeRegistryPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RecipeRegistryPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n774#2:141\n865#2,2:142\n1557#2:144\n1628#2,3:145\n1368#2:148\n1454#2,5:149\n1557#2:154\n1628#2,3:155\n*S KotlinDebug\n*F\n+ 1 RecipeRegistryPeripheral.kt\nsite/siredvin/peripheralworks/computercraft/peripherals/RecipeRegistryPeripheral\n*L\n95#1:141\n95#1:142,2\n95#1:144\n95#1:145,3\n113#1:148\n113#1:149,5\n118#1:154\n118#1:155,3\n*E\n"})
public final class RecipeRegistryPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<RecipeRegistryBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Item air;
    @NotNull
    public static final String TYPE = "recipe_registry";

    public RecipeRegistryPeripheral(@NotNull RecipeRegistryBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, null, 2, null));
        this.air = (Item)PlatformRegistries.INSTANCE.getITEMS().get(new ResourceLocation("minecraft", "air"));
    }

    public final Item getAir() {
        return this.air;
    }

    public static /* synthetic */ void getAir$annotations() {
    }

    public boolean isEnabled() {
        return PeripheralWorksConfig.INSTANCE.getEnableRecipeRegistry();
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map base;
        Map map = base = super.getPeripheralConfiguration();
        String string = "apiVersion";
        Object object = new Integer[]{2, 0};
        object = CollectionsKt.listOf((Object[])object);
        map.put(string, object);
        return base;
    }

    @LuaFunction
    @NotNull
    public final MethodResult getTypes() throws LuaException {
        MethodResult methodResult = MethodResult.of(PlatformRegistries.INSTANCE.getRECIPE_TYPES().keySet().stream().filter(arg_0 -> RecipeRegistryPeripheral.getTypes$lambda$1(RecipeRegistryPeripheral::getTypes$lambda$0, arg_0)).map(arg_0 -> RecipeRegistryPeripheral.getTypes$lambda$2(getTypes.2.INSTANCE, arg_0)).collect(Collectors.toList()));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction
    @NotNull
    public final MethodResult get(@NotNull String recipeID) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)recipeID, (String)"recipeID");
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)recipeID);
        if (resourceLocation == null) {
            MethodResult methodResult = MethodResult.of(null);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ResourceLocation id = resourceLocation;
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Optional optional = level.m_7465_().m_44043_(id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"byKey(...)");
        Recipe recipe = (Recipe)OptionalsKt.getOrNull((Optional)optional);
        if (recipe == null) {
            MethodResult methodResult = MethodResult.of(null);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Recipe recipe2 = recipe;
        Level level2 = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level2);
        RegistryAccess registryAccess = level2.m_9598_();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        MethodResult methodResult = MethodResult.of(RecipeRegistryToolkit.INSTANCE.serializeRecipe(recipe2, registryAccess));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction
    @NotNull
    public final MethodResult getRaw(@NotNull String recipeID) {
        Intrinsics.checkNotNullParameter((Object)recipeID, (String)"recipeID");
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)recipeID);
        if (resourceLocation == null) {
            MethodResult methodResult = MethodResult.of(null);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ResourceLocation recipeId = resourceLocation;
        ResourceLocation recipePath = new ResourceLocation(recipeId.m_135827_(), "recipes/" + recipeId.m_135815_() + ".json");
        MinecraftServer minecraftServer = PlatformToolkit.INSTANCE.get().getMinecraftServer();
        if (minecraftServer == null || (minecraftServer = minecraftServer.m_177941_()) == null) {
            Object[] objectArray = new Object[]{null, "Cannot find server variabel"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        MinecraftServer resourceManager = minecraftServer;
        try {
            Resource resource = (Resource)resourceManager.m_213713_(recipePath).orElseThrow();
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_()));
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            reader.close();
            CompoundTag tag = TagParser.m_129359_((String)jsonObject.toString());
            MethodResult methodResult = MethodResult.of((Object)NBTUtil.toLua((Tag)((Tag)tag)));
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{null, e.toString()};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final MethodResult list(@NotNull IArguments arguments) throws LuaException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Recipe it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Object types = arguments.get(0);
        Set recipeTypes = CollectionsKt.toSet((Iterable)RecipeRegistryToolkit.INSTANCE.collectRecipeTypes(types));
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Collection collection = level.m_7465_().m_44051_();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRecipes(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Recipe)element$iv$iv;
            boolean bl = false;
            if (!recipeTypes.contains(it.m_6671_())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Recipe)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.m_6423_().toString());
        }
        MethodResult methodResult = MethodResult.of((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final MethodResult search(@NotNull IArguments arguments) throws LuaException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        RecipeType it;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        ResourceLocation itemID = IArgumentsKt.getResourceLocation((IArguments)arguments, (int)0);
        Object types = arguments.get(1);
        Item targetItem = (Item)PlatformRegistries.INSTANCE.getITEMS().tryGet(itemID);
        if (targetItem == null || Intrinsics.areEqual((Object)targetItem, (Object)this.air)) {
            String string = "Cannot find item with id %s";
            Object[] objectArray = new Object[]{itemID};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new LuaException(string2);
        }
        List<RecipeType<?>> recipeTypes = RecipeRegistryToolkit.INSTANCE.collectRecipeTypes(types);
        Iterable $this$flatMap$iv = recipeTypes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (RecipeType)element$iv$iv;
            boolean bl = false;
            Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            RecipeManager recipeManager = level.m_7465_();
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.RecipeType<net.minecraft.world.item.crafting.Recipe<net.minecraft.world.Container>>");
            List<Object> list = recipeManager.m_44013_(it).stream().filter(arg_0 -> RecipeRegistryPeripheral.search$lambda$0$1(arg_0 -> RecipeRegistryPeripheral.search$lambda$0$0(this, targetItem, arg_0), arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Recipe)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            RegistryAccess registryAccess = level.m_9598_();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            collection.add(RecipeRegistryToolkit.INSTANCE.serializeRecipe((Recipe<?>)it, registryAccess));
        }
        MethodResult methodResult = MethodResult.of((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecipeRegistryPeripheral)) {
            return false;
        }
        if (!super.equals((IPeripheral)other)) {
            return false;
        }
        if (this.isEnabled() != ((RecipeRegistryPeripheral)((Object)other)).isEnabled()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getPeripheralOwner(), (Object)((RecipeRegistryPeripheral)((Object)other)).getPeripheralOwner());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.isEnabled());
        result = 31 * result + ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).hashCode();
        return result;
    }

    private static final boolean getTypes$lambda$0(ResourceLocation it) {
        return !RecipeRegistryToolkit.INSTANCE.getExcludedRecipeTypes().contains(it);
    }

    private static final boolean getTypes$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getTypes$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean search$lambda$0$0(RecipeRegistryPeripheral this$0, Item $targetItem, Recipe recipe) {
        Level level = ((BlockEntityPeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        return recipe.m_8043_(level.m_9598_()).m_150930_($targetItem);
    }

    private static final boolean search$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/computercraft/peripherals/RecipeRegistryPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

