/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.plugins.specific;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.ContainerWrapper;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemSink;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.plugins.PeripheralPluginUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nH\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\"\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralworks/computercraft/plugins/specific/JukeboxPlugin;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "target", "Lnet/minecraft/world/level/block/entity/JukeboxBlockEntity;", "<init>", "(Lnet/minecraft/world/level/block/entity/JukeboxBlockEntity;)V", "assertDisc", "", "assertNoDisc", "getDisc", "", "", "", "replay", "stop", "ejectDisc", "Ldan200/computercraft/api/lua/MethodResult;", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "toName", "injectDisc", "fromName", "itemQuery", "peripheralworks-forge-1.20.1"})
public final class JukeboxPlugin
implements IPeripheralPlugin {
    @NotNull
    private final JukeboxBlockEntity target;

    public JukeboxPlugin(@NotNull JukeboxBlockEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    private final void assertDisc() {
        if (this.target.m_8020_(0).m_41619_()) {
            throw new LuaException("Disc should present in jukebox");
        }
    }

    private final void assertNoDisc() {
        if (!this.target.m_8020_(0).m_41619_()) {
            throw new LuaException("Jukebox should be empty");
        }
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> getDisc() {
        ItemStack record = this.target.m_8020_(0);
        if (record.m_41619_()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)record);
        return LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)record, null, (int)2, null);
    }

    @LuaFunction(mainThread=true)
    public final void replay() {
        this.assertDisc();
        if (!this.target.m_272025_()) {
            this.target.m_271687_();
        }
    }

    @LuaFunction(mainThread=true)
    public final void stop() {
        if (this.target.m_272025_()) {
            this.target.m_272088_();
        }
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult ejectDisc(@NotNull IComputerAccess computer, @NotNull String toName) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        this.assertDisc();
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Level level = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        AgnosticItemSink agnosticItemSink = AgnosticItemStorageLookup.INSTANCE.extractItemSinkFromUnknown(level, location.getTarget());
        if (agnosticItemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an item inventory");
        }
        AgnosticItemSink toStorage = agnosticItemSink;
        ItemStack itemStack = this.target.m_8020_(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack stored = toStorage.storeItem(itemStack);
        if (!stored.m_41619_()) {
            Object[] objectArray = new Object[]{null, "Not enough space in target inventory"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        this.target.m_7407_(0, 1);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult injectDisc(@NotNull IComputerAccess computer, @NotNull String fromName, @Nullable Object itemQuery) {
        int moved;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        this.assertNoDisc();
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Level level = this.target.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        AgnosticItemStorage agnosticItemStorage = AgnosticItemStorageLookup.INSTANCE.extractStorageFromUnknown(level, location.getTarget());
        if (agnosticItemStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an item inventory");
        }
        AgnosticItemStorage fromStorage = agnosticItemStorage;
        Predicate<ItemStack> predicate = JukeboxPlugin::injectDisc$lambda$0;
        if (itemQuery != null) {
            Predicate<ItemStack> predicate2 = predicate.and(PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery));
            Intrinsics.checkNotNullExpressionValue(predicate2, (String)"and(...)");
            predicate = predicate2;
        }
        if ((moved = AgnosticItemSink.DefaultImpls.moveFrom$default((AgnosticItemSink)((AgnosticItemSink)new ContainerWrapper((Container)this.target)), (AgnosticItemStorage)fromStorage, (int)1, (int)0, predicate, (int)4, null)) == 0) {
            Object[] objectArray = new Object[]{null, "Cannot find disc in desired inventory"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        this.replay();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final boolean injectDisc$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.m_204117_(ItemTags.f_13158_);
    }
}

