/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.mna;

import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskIntegerParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskItemStackParameter;
import com.mna.entities.constructs.ai.ConstructMove;
import com.mna.entities.constructs.ai.ConstructPlaceItem;
import com.mna.entities.constructs.ai.ConstructTakeItem;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.constructs.animated.ConstructDiagnostics;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.utils.ExtensionsKt;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.ext.IArgumentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0007J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/peripheralworks/integrations/mna/ConstructPlugin;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "entity", "Lcom/mna/entities/constructs/animated/Construct;", "<init>", "(Lcom/mna/entities/constructs/animated/Construct;)V", "move", "", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "store", "take", "listCommands", "", "", "", "diagnose", "", "getCommand", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nConstructPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructPlugin.kt\nsite/siredvin/peripheralworks/integrations/mna/ConstructPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1187#2,2:90\n1261#2,4:92\n1557#2:96\n1628#2,3:97\n*S KotlinDebug\n*F\n+ 1 ConstructPlugin.kt\nsite/siredvin/peripheralworks/integrations/mna/ConstructPlugin\n*L\n71#1:90,2\n71#1:92,4\n76#1:96\n76#1:97,3\n*E\n"})
public final class ConstructPlugin
implements IPeripheralPlugin {
    @NotNull
    private final Construct entity;

    public ConstructPlugin(@NotNull Construct entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entity = entity;
    }

    @LuaFunction(mainThread=true)
    public final void move(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Player player = this.entity.getOwner();
        if (player == null) {
            return;
        }
        Player player2 = player;
        ConstructAITask currentCommand = this.entity.getCurrentCommand();
        if (currentCommand != null && currentCommand.isFinished()) {
            throw new LuaException("Current command is still now finished");
        }
        Vec3i vector = ExtensionsKt.getVec3i(arguments, 1);
        ConstructMove newCommand = new ConstructMove((IConstruct)this.entity, ResourceLocation.parse((String)"none"));
        newCommand.setDesiredLocation((BlockPos)this.entity.m_20183_().m_122032_().m_122193_(vector));
        this.entity.setCurrentCommand(player2, (ConstructAITask)newCommand);
    }

    @LuaFunction(mainThread=true)
    public final void store(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Player player = this.entity.getOwner();
        if (player == null) {
            return;
        }
        Player player2 = player;
        ConstructAITask currentCommand = this.entity.getCurrentCommand();
        if (currentCommand != null && currentCommand.isFinished()) {
            throw new LuaException("Current command is still now finished");
        }
        Vec3i vector = ExtensionsKt.getVec3i(arguments, 1);
        Direction direction = ExtensionsKt.optDirection(arguments, 2);
        if (direction == null) {
            direction = Direction.NORTH;
        }
        Direction direction2 = direction;
        ConstructPlaceItem newCommand = new ConstructPlaceItem((IConstruct)this.entity, ResourceLocation.parse((String)"none"));
        newCommand.setTileEntity((BlockPos)this.entity.m_20183_().m_122032_().m_122193_(vector), direction2);
        this.entity.setCurrentCommand(player2, (ConstructAITask)newCommand);
    }

    @LuaFunction(mainThread=true)
    public final void take(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Player player = this.entity.getOwner();
        if (player == null) {
            return;
        }
        Player player2 = player;
        ConstructAITask currentCommand = this.entity.getCurrentCommand();
        if (currentCommand != null && currentCommand.isFinished()) {
            throw new LuaException("Current command is still now finished");
        }
        Vec3i vector = ExtensionsKt.getVec3i(arguments, 1);
        Direction direction = ExtensionsKt.optDirection(arguments, 2);
        if (direction == null) {
            direction = Direction.NORTH;
        }
        Direction direction2 = direction;
        ItemStack itemToTake = IArgumentsKt.getItemStack((IArguments)arguments, (int)3);
        int amount = arguments.optInt(4, 64);
        ConstructTakeItem newCommand = new ConstructTakeItem((IConstruct)this.entity, ResourceLocation.parse((String)"none"));
        ConstructTaskItemStackParameter filter = new ConstructTaskItemStackParameter("take.stack");
        ConstructTaskIntegerParameter amountParameter = new ConstructTaskIntegerParameter("take.quantity");
        filter.setStack(itemToTake.m_255036_(amount));
        amountParameter.setValue(amount);
        newCommand.getParameters().add(filter);
        newCommand.getParameters().add(amountParameter);
        newCommand.setTileEntity((BlockPos)this.entity.m_20183_().m_122032_().m_122193_(vector), direction2);
        this.entity.setCurrentCommand(player2, (ConstructAITask)newCommand);
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> listCommands() {
        void $this$associateTo$iv$iv;
        Set set = ((IForgeRegistry)Registries.ConstructTasks.get()).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getEntries(...)");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)((ResourceKey)it.getKey()).toString(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final List<String> diagnose() {
        void $this$mapTo$iv$iv;
        LinkedList linkedList = this.entity.getDiagnostics().getMessages();
        Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"getMessages(...)");
        Iterable $this$map$iv = linkedList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConstructDiagnostics.LogEntry logEntry = (ConstructDiagnostics.LogEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.message);
        }
        return (List)destination$iv$iv;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getCommand() {
        ConstructAITask command = this.entity.getCurrentCommand();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)command.getType().toString()), TuplesKt.to((Object)"isFinished", (Object)command.isFinished()), TuplesKt.to((Object)"isSuccess", (Object)command.isSuccess()), TuplesKt.to((Object)"isStart", (Object)command.isSuccess())};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

