/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import java.util.Map;
import java.util.OptionalInt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStorageLookup;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyRegistry;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;
import site.siredvin.broccolium.modules.storage.item.ContainerWrapper;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lsite/siredvin/peripheralworks/computercraft/EnergyRefuelHandler;", "Ldan200/computercraft/api/turtle/TurtleRefuelHandler;", "<init>", "()V", "refuel", "Ljava/util/OptionalInt;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "stack", "Lnet/minecraft/world/item/ItemStack;", "slot", "", "limit", "peripheralworks-forge-1.20.1"})
public final class EnergyRefuelHandler
implements TurtleRefuelHandler {
    @NotNull
    public static final EnergyRefuelHandler INSTANCE = new EnergyRefuelHandler();

    private EnergyRefuelHandler() {
    }

    @NotNull
    public OptionalInt refuel(@NotNull ITurtleAccess turtle, @NotNull ItemStack stack, int slot, int limit) {
        AgnosticEnergyStack turtleEnergy;
        Fraction fraction;
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!PeripheralWorksConfig.INSTANCE.getEnableTurtleRefuelWithEnergy()) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        Level level = turtle.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Container container = turtle.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        AgnosticEnergyStorage agnosticEnergyStorage = (AgnosticEnergyStorage)AgnosticEnergyStorageLookup.INSTANCE.extractFromInventoryStack(level, (SlottedAgnosticItemStorage)new ContainerWrapper(container), slot);
        if (agnosticEnergyStorage == null) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        AgnosticEnergyStorage energyStorage = agnosticEnergyStorage;
        AgnosticEnergyStack energy = energyStorage.getEnergy();
        if (energy.isEmpty()) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        if (!Intrinsics.areEqual((Object)energy.getUnit(), (Object)Energies.INSTANCE.getTURTLE_FUEL()) && !EnergyRegistry.INSTANCE.isConvertible(energy.getUnit(), Energies.INSTANCE.getTURTLE_FUEL())) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        if (Intrinsics.areEqual((Object)energy.getUnit(), (Object)Energies.INSTANCE.getTURTLE_FUEL())) {
            fraction = Fraction.getFraction((int)1, (int)1);
        } else {
            Object v = EnergyRegistry.INSTANCE.getCONVERSIONS().get(energy.getUnit());
            Intrinsics.checkNotNull(v);
            Object v2 = ((Map)v).get(Energies.INSTANCE.getTURTLE_FUEL());
            Intrinsics.checkNotNull(v2);
            fraction = (Fraction)v2;
        }
        Fraction conversionRate = fraction;
        int fuelLimit = (int)((double)RangesKt.coerceAtLeast((int)(turtle.getFuelLimit() - turtle.getFuelLevel()), (int)0) / conversionRate.doubleValue());
        long roundedLimit = Fraction.getFraction((int)conversionRate.multiplyBy(Fraction.getFraction((int)limit, (int)1)).intValue(), (int)1).divideBy(conversionRate).longValue();
        int realLimit = Math.min((int)roundedLimit, fuelLimit);
        if (realLimit == 0) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        long slidingLimit = realLimit;
        AgnosticEnergyStack slidingStack = new AgnosticEnergyStack(energyStorage.getUnit(), 0L);
        for (int i = 1; i < 5; ++i) {
            AgnosticEnergyStack extractedEnergy = energyStorage.takeEnergy(EnergyRefuelHandler::refuel$lambda$0, slidingLimit);
            if (extractedEnergy.isEmpty()) {
                if (!slidingStack.isEmpty()) break;
                OptionalInt optionalInt = OptionalInt.empty();
                Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
                return optionalInt;
            }
            slidingStack.grow(extractedEnergy.getAmount());
            if ((slidingLimit -= extractedEnergy.getAmount()) <= 0L) break;
        }
        AgnosticEnergyStack agnosticEnergyStack = turtleEnergy = Intrinsics.areEqual((Object)slidingStack.getUnit(), (Object)Energies.INSTANCE.getTURTLE_FUEL()) ? slidingStack : EnergyRegistry.convert$default((EnergyRegistry)EnergyRegistry.INSTANCE, (AgnosticEnergyStack)slidingStack, (EnergyUnit)Energies.INSTANCE.getTURTLE_FUEL(), (boolean)false, (int)4, null);
        if (turtleEnergy.isEmpty()) {
            OptionalInt optionalInt = OptionalInt.empty();
            Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"empty(...)");
            return optionalInt;
        }
        OptionalInt optionalInt = OptionalInt.of((int)turtleEnergy.getAmount());
        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
        return optionalInt;
    }

    private static final boolean refuel$lambda$0(AgnosticEnergyStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

