/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyService;
import appeng.blockentity.grid.AENetworkBlockEntity;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.energy.AgnosticEnergyStack;
import site.siredvin.broccolium.modules.storage.energy.Energies;
import site.siredvin.broccolium.modules.storage.energy.EnergyUnit;
import site.siredvin.broccolium.modules.storage.energy.api.AgnosticEnergyStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u001e\u0010\u001e\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010!\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/AEEnergyStorage;", "Lsite/siredvin/broccolium/modules/storage/energy/api/AgnosticEnergyStorage;", "energyService", "Lappeng/api/networking/energy/IEnergyService;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "<init>", "(Lappeng/api/networking/energy/IEnergyService;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "capacity", "", "getCapacity", "()J", "canExtract", "", "getCanExtract", "()Z", "energy", "Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "getEnergy", "()Lsite/siredvin/broccolium/modules/storage/energy/AgnosticEnergyStack;", "setChanged", "", "canReceive", "getCanReceive", "unit", "Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "getUnit", "()Lsite/siredvin/broccolium/modules/storage/energy/EnergyUnit;", "storeEnergy", "stack", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class AEEnergyStorage
implements AgnosticEnergyStorage {
    @NotNull
    private final IEnergyService energyService;
    @NotNull
    private final AENetworkBlockEntity entity;

    public AEEnergyStorage(@NotNull IEnergyService energyService, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)energyService, (String)"energyService");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.energyService = energyService;
        this.entity = entity;
    }

    public long getCapacity() {
        return (long)this.energyService.getMaxStoredPower();
    }

    public boolean getCanExtract() {
        return true;
    }

    @NotNull
    public AgnosticEnergyStack getEnergy() {
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)this.energyService.getStoredPower());
    }

    public void setChanged() {
        this.entity.m_6596_();
    }

    public boolean getCanReceive() {
        return true;
    }

    @NotNull
    public EnergyUnit getUnit() {
        return Energies.INSTANCE.getREDSTONE_FLUX();
    }

    @NotNull
    public AgnosticEnergyStack storeEnergy(@NotNull AgnosticEnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getUnit(), (Object)Energies.INSTANCE.getREDSTONE_FLUX())) {
            return stack;
        }
        double leftover = this.energyService.injectPower((double)stack.getAmount(), Actionable.MODULATE);
        return stack.copyWithCount((long)leftover);
    }

    @NotNull
    public AgnosticEnergyStack takeEnergy(@NotNull Predicate<AgnosticEnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), 0L);
        }
        double extracted = this.energyService.extractAEPower((double)limit, Actionable.MODULATE, PowerMultiplier.CONFIG);
        return new AgnosticEnergyStack(Energies.INSTANCE.getREDSTONE_FLUX(), (long)extracted);
    }
}

