/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.emi;

import com.google.gson.Gson;
import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.shared.ModRegistry;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.peripheralworks.integrations.emi.ComputerRecipeHandler;
import site.siredvin.peripheralworks.networking.ClientNetworking;
import site.siredvin.peripheralworks.networking.MapBasedEventMessage;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.representation.RepresentationMode;
import site.siredvin.tweakium.modules.platform.ComputerPlatformToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/peripheralworks/integrations/emi/CommonEntrypoint;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "mapStack", "", "", "stack", "Ldev/emi/emi/api/stack/EmiStack;", "mapIngredient", "ingredient", "Ldev/emi/emi/api/stack/EmiIngredient;", "register", "", "registry", "Ldev/emi/emi/api/EmiRegistry;", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nCommonEntrypoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonEntrypoint.kt\nsite/siredvin/peripheralworks/integrations/emi/CommonEntrypoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1557#2:81\n1628#2,3:82\n*S KotlinDebug\n*F\n+ 1 CommonEntrypoint.kt\nsite/siredvin/peripheralworks/integrations/emi/CommonEntrypoint\n*L\n57#1:81\n57#1:82,3\n*E\n"})
public final class CommonEntrypoint {
    @NotNull
    public static final CommonEntrypoint INSTANCE = new CommonEntrypoint();
    @NotNull
    private static final Gson GSON = new Gson();

    private CommonEntrypoint() {
    }

    @NotNull
    public final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public final Map<String, Object> mapStack(@NotNull EmiStack stack) {
        String nbtHash;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"empty")};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }
        if (!stack.getItemStack().m_41619_()) {
            ItemStack itemStack = stack.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            Map base = LuaRepresentation.INSTANCE.forItemStack(itemStack, RepresentationMode.BASE);
            base.put("type", "item");
            base.put("chance", Float.valueOf(stack.getChance()));
            return base;
        }
        Map base = new LinkedHashMap();
        base.put("name", stack.getId().toString());
        base.put("amount", stack.getAmount());
        base.put("displayName", stack.getName().getString());
        base.put("chance", Float.valueOf(stack.getChance()));
        if (stack.getNbt() != null && (nbtHash = ComputerPlatformToolkit.INSTANCE.get().nbtHash(stack.getNbt())) != null) {
            base.put("nbt", nbtHash);
        }
        if (stack instanceof FluidEmiStack) {
            base.put("type", "fluid");
            Map map = base;
            String string = "amount";
            Object v = base.get("amount");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            Double d = ((Number)v).doubleValue() / (double)PlatformToolkit.INSTANCE.get().getFluidCompactDivider();
            map.put(string, d);
        }
        return base;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> mapIngredient(@NotNull EmiIngredient ingredient) {
        Pair[] pairArray;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        if (ingredient.isEmpty()) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"type", (Object)"empty")};
            return MapsKt.mutableMapOf((Pair[])pairArray2);
        }
        List list = ingredient.getEmiStacks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEmiStacks(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            EmiStack emiStack = (EmiStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapStack((EmiStack)p0));
        }
        List ingredients = (List)destination$iv$iv;
        if (ingredients.isEmpty()) {
            pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"empty")};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }
        if (ingredients.size() == 1) {
            return (Map)ingredients.get(0);
        }
        pairArray = new Pair[]{TuplesKt.to((Object)"candidates", (Object)ingredients)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public final void register(@NotNull EmiRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addGenericDragDropHandler(CommonEntrypoint::register$lambda$0);
        registry.addRecipeHandler((MenuType)ModRegistry.Menus.COMPUTER.get(), (EmiRecipeHandler)new ComputerRecipeHandler());
    }

    private static final boolean register$lambda$0(Screen screen, EmiIngredient stack, int x, int y) {
        if (screen instanceof AbstractComputerScreen) {
            AbstractContainerMenu abstractContainerMenu = ((AbstractComputerScreen)screen).m_6262_();
            Intrinsics.checkNotNullExpressionValue((Object)abstractContainerMenu, (String)"getMenu(...)");
            Intrinsics.checkNotNull((Object)stack);
            ClientNetworking.INSTANCE.sendToServer(new MapBasedEventMessage(abstractContainerMenu, "emi_ingredient_paste", INSTANCE.mapIngredient(stack)));
            return true;
        }
        return false;
    }
}

