/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.peripheralworks.subsystem.recipe.DefaultRecipeTransformer;
import site.siredvin.peripheralworks.subsystem.recipe.NBTCheckMode;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeSearchPredicate;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeSerializableRecord;
import site.siredvin.peripheralworks.subsystem.recipe.RecipeTransformer;
import site.siredvin.peripheralworks.subsystem.recipe.integration.ShapedCraftingRecipeTransformer;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.platform.ComputerPlatformToolkit;
import site.siredvin.tweakium.modules.platform.api.InnerComputerPlatformToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cJB\u0010%\u001a\u00020#\"\b\b\u0000\u0010&*\u00020'\"\u000e\b\u0001\u0010(*\b\u0012\u0004\u0012\u0002H&0\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u00122\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u0002H(0\u0014JH\u0010+\u001a\u00020#\"\b\b\u0000\u0010&*\u00020'\"\u000e\b\u0001\u0010(*\b\u0012\u0004\u0012\u0002H&0\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u00122\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00130\u0014J0\u0010,\u001a\u00020#\"\u0004\b\u0000\u0010(2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H(0\u00122\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u0002H(\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016J*\u0010/\u001a\u00020#\"\f\b\u0000\u0010(*\u0006\u0012\u0002\b\u00030\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u0002H(0\u00182\u0006\u00101\u001a\u00020\u0019J\u0012\u00102\u001a\u0004\u0018\u00010\u00012\b\u00103\u001a\u0004\u0018\u000104J\u0012\u00105\u001a\u0004\u0018\u00010\u00012\b\u00103\u001a\u0004\u0018\u00010\u0001J\u0012\u00106\u001a\u0004\u0018\u00010\u00012\b\u00103\u001a\u0004\u0018\u00010\u0001J&\u00107\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u00109\u001a\u00020:J\u0012\u0010;\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010$\u001a\u00020\u001cJ$\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130=2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010>\u001a\u00020?J2\u0010@\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010A2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010B\u001a\u00020C2\u0006\u0010>\u001a\u00020?2\u0006\u0010D\u001a\u00020EJ\u001a\u0010F\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180=2\b\u0010G\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR4\u0010\u0010\u001a(\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\u0012\u0012\u0012\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0015\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeRegistryToolkit;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "SERIALIZATION_SKIP", "getSERIALIZATION_SKIP", "()Ljava/lang/Object;", "SERIALIZATION_EMPTY_SLOT", "", "", "getSERIALIZATION_EMPTY_SLOT", "()Ljava/util/Map;", "RECIPE_SERIALIZERS", "", "Ljava/lang/Class;", "Lnet/minecraft/world/item/crafting/Recipe;", "Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeTransformer;", "SERIALIZERS", "Ljava/util/function/Function;", "RECIPE_PREDICATES", "Lnet/minecraft/world/item/crafting/RecipeType;", "Lsite/siredvin/peripheralworks/subsystem/recipe/RecipeSearchPredicate;", "EXCLUDED_RECIPE_TYPES", "", "Lnet/minecraft/resources/ResourceLocation;", "excludedRecipeTypes", "", "getExcludedRecipeTypes", "()Ljava/util/Set;", "DEFAULT_RECIPE_PREDICATE", "excludeRecipeType", "", "type", "registerRecipeSerializer", "V", "Lnet/minecraft/world/Container;", "T", "recipeClass", "transformer", "registerRecipeSerializerRaw", "registerSerializer", "clazz", "serializer", "registerRecipePredicate", "recipeType", "searchFunction", "serializeJson", "obj", "Lcom/google/gson/JsonObject;", "serializePossibleCollection", "serialize", "serializeRecipe", "recipe", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "getRecipeType", "getRecipesForType", "", "level", "Lnet/minecraft/world/level/Level;", "findRecipesForType", "", "result", "Lnet/minecraft/world/item/ItemStack;", "checkMode", "Lsite/siredvin/peripheralworks/subsystem/recipe/NBTCheckMode;", "collectRecipeTypes", "types", "peripheralworks-forge-1.20.1"})
public final class RecipeRegistryToolkit {
    @NotNull
    public static final RecipeRegistryToolkit INSTANCE = new RecipeRegistryToolkit();
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final Object SERIALIZATION_SKIP = new Object();
    @NotNull
    private static final Map<String, String> SERIALIZATION_EMPTY_SLOT = MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"empty"));
    @NotNull
    private static final Map<Class<? extends Recipe<?>>, RecipeTransformer<?, Recipe<?>>> RECIPE_SERIALIZERS = new LinkedHashMap();
    @NotNull
    private static final Map<Class<?>, Function<Object, Object>> SERIALIZERS = new LinkedHashMap();
    @NotNull
    private static final Map<RecipeType<?>, RecipeSearchPredicate> RECIPE_PREDICATES = new LinkedHashMap();
    @NotNull
    private static final Set<ResourceLocation> EXCLUDED_RECIPE_TYPES = new LinkedHashSet();
    @NotNull
    private static final RecipeSearchPredicate DEFAULT_RECIPE_PREDICATE = RecipeRegistryToolkit::DEFAULT_RECIPE_PREDICATE$lambda$0;

    private RecipeRegistryToolkit() {
    }

    @NotNull
    public final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public final Object getSERIALIZATION_SKIP() {
        return SERIALIZATION_SKIP;
    }

    @NotNull
    public final Map<String, String> getSERIALIZATION_EMPTY_SLOT() {
        return SERIALIZATION_EMPTY_SLOT;
    }

    @NotNull
    public final Set<ResourceLocation> getExcludedRecipeTypes() {
        return EXCLUDED_RECIPE_TYPES;
    }

    public final void excludeRecipeType(@NotNull ResourceLocation type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        EXCLUDED_RECIPE_TYPES.add(type2);
    }

    public final <V extends Container, T extends Recipe<V>> void registerRecipeSerializer(@NotNull Class<T> recipeClass, @NotNull RecipeTransformer<V, T> transformer) {
        Intrinsics.checkNotNullParameter(recipeClass, (String)"recipeClass");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        RECIPE_SERIALIZERS.put(recipeClass, transformer);
    }

    public final <V extends Container, T extends Recipe<V>> void registerRecipeSerializerRaw(@NotNull Class<T> recipeClass, @NotNull RecipeTransformer<Container, Recipe<Container>> transformer) {
        Intrinsics.checkNotNullParameter(recipeClass, (String)"recipeClass");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        RECIPE_SERIALIZERS.put(recipeClass, transformer);
    }

    public final <T> void registerSerializer(@NotNull Class<T> clazz, @NotNull Function<T, Object> serializer) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        SERIALIZERS.put(clazz, serializer);
    }

    public final <T extends Recipe<?>> void registerRecipePredicate(@NotNull RecipeType<T> recipeType, @NotNull RecipeSearchPredicate searchFunction) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)searchFunction, (String)"searchFunction");
        RECIPE_PREDICATES.put(recipeType, searchFunction);
    }

    @Nullable
    public final Object serializeJson(@Nullable JsonObject obj) {
        return GSON.fromJson((JsonElement)obj, HashMap.class);
    }

    @Nullable
    public final Object serializePossibleCollection(@Nullable Object obj) {
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().map(INSTANCE::serialize).collect(Collectors.toList());
        }
        if (obj != null && obj.getClass().isArray()) {
            return Arrays.stream((Object[])obj).map(INSTANCE::serialize).collect(Collectors.toList());
        }
        return this.serialize(obj);
    }

    @Nullable
    public final Object serialize(@Nullable Object obj) {
        if (obj instanceof RecipeSerializableRecord) {
            return ((RecipeSerializableRecord)obj).serializeForToolkit();
        }
        for (Class<?> clazz : SERIALIZERS.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            Function<Object, Object> function = SERIALIZERS.get(clazz);
            Intrinsics.checkNotNull(function);
            return function.apply(clazz.cast(obj));
        }
        return obj;
    }

    @NotNull
    public final Map<String, Object> serializeRecipe(@NotNull Recipe<?> recipe, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (Class<Recipe<?>> recipeClass : RECIPE_SERIALIZERS.keySet()) {
            if (!recipeClass.isInstance(recipe)) continue;
            RecipeTransformer<?, Recipe<?>> recipeTransformer = RECIPE_SERIALIZERS.get(recipeClass);
            Intrinsics.checkNotNull(recipeTransformer);
            return recipeTransformer.transform(recipe, registryAccess);
        }
        return DefaultRecipeTransformer.INSTANCE.transform(recipe, registryAccess);
    }

    @NotNull
    public final RecipeType<?> getRecipeType(@NotNull ResourceLocation type2) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        RecipeType recipeType = (RecipeType)PlatformRegistries.INSTANCE.getRECIPE_TYPES().tryGet(type2);
        if (recipeType == null) {
            String string = "Incorrect recipe type %s";
            Object[] objectArray = new Object[]{type2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new LuaException(string2);
        }
        return recipeType;
    }

    @NotNull
    public final List<Recipe<?>> getRecipesForType(@NotNull RecipeType<?> recipeType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List list = level.m_7465_().m_44013_(recipeType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
        return list;
    }

    @Nullable
    public final List<Object> findRecipesForType(@NotNull RecipeType<?> recipeType, @NotNull ItemStack result, @NotNull Level level, @NotNull NBTCheckMode checkMode) {
        Intrinsics.checkNotNullParameter(recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        RecipeSearchPredicate searchPredicate = RECIPE_PREDICATES.getOrDefault(recipeType, DEFAULT_RECIPE_PREDICATE);
        List<Recipe<?>> recipes = this.getRecipesForType(recipeType, level);
        return recipes.stream().filter(arg_0 -> RecipeRegistryToolkit.findRecipesForType$lambda$1(arg_0 -> RecipeRegistryToolkit.findRecipesForType$lambda$0(searchPredicate, result, checkMode, arg_0), arg_0)).collect(Collectors.toList());
    }

    @NotNull
    public final List<RecipeType<?>> collectRecipeTypes(@Nullable Object types) throws LuaException {
        if (types == null || Intrinsics.areEqual((Object)types.toString(), (Object)"*")) {
            return SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)PlatformRegistries.INSTANCE.getRECIPE_TYPES().iterator()));
        }
        if (types instanceof String) {
            return StringsKt.contains$default((CharSequence)((CharSequence)types), (CharSequence)":", (boolean)false, (int)2, null) ? CollectionsKt.listOf(this.getRecipeType(new ResourceLocation(((String)types).toString()))) : SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)PlatformRegistries.INSTANCE.getRECIPE_TYPES().iterator()), arg_0 -> RecipeRegistryToolkit.collectRecipeTypes$lambda$0(types, arg_0)));
        }
        if (types instanceof Map) {
            List recipeTypes = new ArrayList();
            for (Object el : ((Map)types).values()) {
                recipeTypes.add(this.getRecipeType(new ResourceLocation(String.valueOf(el))));
            }
            return recipeTypes;
        }
        throw new LuaException("types should be string or table!");
    }

    private static final boolean DEFAULT_RECIPE_PREDICATE$lambda$0(ItemStack stack, Recipe recipe, NBTCheckMode checkMode) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        ItemStack itemStack = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getResultItem(...)");
        return checkMode.itemStackEquals(itemStack, stack);
    }

    private static final Object _init_$lambda$0(Ingredient it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.m_43947_()) {
            return SERIALIZATION_EMPTY_SLOT;
        }
        try {
            return GSON.fromJson(it.m_43942_(), HashMap.class);
        }
        catch (JsonSyntaxException ignored) {
            try {
                return GSON.fromJson(it.m_43942_(), ArrayList.class);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static final Object _init_$lambda$1(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.m_41619_()) {
            return SERIALIZATION_EMPTY_SLOT;
        }
        return LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)it, null, (int)2, null);
    }

    private static final Object _init_$lambda$2(EntityType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)PlatformRegistries.INSTANCE.getENTITY_TYPES().getKey((Object)it).toString())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final boolean findRecipesForType$lambda$0(RecipeSearchPredicate $searchPredicate, ItemStack $result, NBTCheckMode $checkMode, Recipe it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.Recipe<net.minecraft.world.Container>");
        return $searchPredicate.test($result, (Recipe<Container>)it, $checkMode);
    }

    private static final boolean findRecipesForType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean collectRecipeTypes$lambda$0(Object $types, RecipeType p) {
        return StringsKt.startsWith$default((String)p.toString(), (String)((String)$types), (boolean)false, (int)2, null);
    }

    static {
        INSTANCE.registerSerializer(Ingredient.class, RecipeRegistryToolkit::_init_$lambda$0);
        INSTANCE.registerSerializer(ItemStack.class, RecipeRegistryToolkit::_init_$lambda$1);
        INSTANCE.registerSerializer(Item.class, arg_0 -> ((LuaRepresentation)LuaRepresentation.INSTANCE).forItem(arg_0));
        INSTANCE.registerSerializer(Fluid.class, arg_0 -> ((LuaRepresentation)LuaRepresentation.INSTANCE).forFluid(arg_0));
        INSTANCE.registerSerializer(JsonObject.class, INSTANCE::serializeJson);
        INSTANCE.registerSerializer(EntityType.class, RecipeRegistryToolkit::_init_$lambda$2);
        INSTANCE.registerSerializer(Tag.class, arg_0 -> ((InnerComputerPlatformToolkit)ComputerPlatformToolkit.INSTANCE.get()).nbtToLua(arg_0));
        INSTANCE.registerRecipeSerializer(ShapedRecipe.class, ShapedCraftingRecipeTransformer.INSTANCE);
    }
}

