/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft.modem;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.computer.core.ServerContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.peripheralworks.computercraft.modem.PeripheralHubPeripheral;
import site.siredvin.peripheralworks.computercraft.modem.RemoteComputerWrapper;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017J*\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralRecord;", "O", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "", "peripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "name", "", "internalID", "modelPeripheral", "Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;", "<init>", "(Ldan200/computercraft/api/peripheral/IPeripheral;Ljava/lang/String;Ljava/lang/String;Lsite/siredvin/peripheralworks/computercraft/modem/PeripheralHubPeripheral;)V", "getPeripheral", "()Ldan200/computercraft/api/peripheral/IPeripheral;", "getName", "()Ljava/lang/String;", "getInternalID", "methodMap", "", "Ldan200/computercraft/core/methods/PeripheralMethod;", "wrappers", "Ljava/util/concurrent/ConcurrentMap;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "Lsite/siredvin/peripheralworks/computercraft/modem/RemoteComputerWrapper;", "methodNames", "", "getMethodNames", "()Ljava/util/Collection;", "attach", "", "computer", "detach", "callMethod", "Ldan200/computercraft/api/lua/MethodResult;", "access", "context", "Ldan200/computercraft/api/lua/ILuaContext;", "methodName", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "peripheralworks-forge-1.20.1"})
public final class PeripheralRecord<O extends IPeripheralOwner> {
    @NotNull
    private final IPeripheral peripheral;
    @NotNull
    private final String name;
    @NotNull
    private final String internalID;
    @NotNull
    private final PeripheralHubPeripheral<O> modelPeripheral;
    @NotNull
    private final Map<String, PeripheralMethod> methodMap;
    @NotNull
    private final ConcurrentMap<IComputerAccess, RemoteComputerWrapper<O>> wrappers;

    public PeripheralRecord(@NotNull IPeripheral peripheral, @NotNull String name, @NotNull String internalID, @NotNull PeripheralHubPeripheral<O> modelPeripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)internalID, (String)"internalID");
        Intrinsics.checkNotNullParameter(modelPeripheral, (String)"modelPeripheral");
        this.peripheral = peripheral;
        this.name = name;
        this.internalID = internalID;
        this.modelPeripheral = modelPeripheral;
        MinecraftServer minecraftServer = PlatformToolkit.INSTANCE.get().getMinecraftServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        Map map = ServerContext.get((MinecraftServer)minecraftServer).peripheralMethods().getSelfMethods((Object)this.peripheral);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getSelfMethods(...)");
        this.methodMap = map;
        this.wrappers = new ConcurrentHashMap();
    }

    @NotNull
    public final IPeripheral getPeripheral() {
        return this.peripheral;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getInternalID() {
        return this.internalID;
    }

    @NotNull
    public final Collection<String> getMethodNames() {
        return this.methodMap.keySet();
    }

    public final void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        ((Map)this.wrappers).put(computer, new RemoteComputerWrapper<O>(computer, this, this.modelPeripheral));
        this.peripheral.attach((IComputerAccess)this.wrappers.get(computer));
        Object[] objectArray = new Object[]{this.name};
        computer.queueEvent("peripheral", objectArray);
    }

    public final void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.peripheral.detach((IComputerAccess)this.wrappers.get(computer));
        Object[] objectArray = new Object[]{this.name};
        computer.queueEvent("peripheral_detach", objectArray);
        this.wrappers.remove(computer);
    }

    @NotNull
    public final MethodResult callMethod(@NotNull IComputerAccess access, @Nullable ILuaContext context, @NotNull String methodName, @Nullable IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        PeripheralMethod peripheralMethod = this.methodMap.get(methodName);
        if (peripheralMethod == null) {
            throw new LuaException("No such method " + methodName);
        }
        PeripheralMethod method = peripheralMethod;
        MethodResult methodResult = method.apply((Object)this.peripheral, context, (IComputerAccess)this.wrappers.get(access), arguments);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"apply(...)");
        return methodResult;
    }
}

