/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.projecte;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.platform.PlatformRegistries;
import site.siredvin.broccolium.modules.platform.api.RegistryWrapper;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemSink;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.representation.RepresentationMode;
import site.siredvin.tweakium.modules.peripheral.util.ValidationHelpersKt;
import site.siredvin.tweakium.modules.plugins.SuppliedRudimentInventoryPlugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001cB\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0019H\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/peripheralworks/integrations/projecte/TransmutationTabletPeripheral;", "O", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "peripheralOwner", "isEnabled", "", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;Z)V", "()Z", "knowledge", "Lmoze_intel/projecte/api/capabilities/IKnowledgeProvider;", "getKnowledge", "()Lmoze_intel/projecte/api/capabilities/IKnowledgeProvider;", "getEMC", "Ljava/math/BigInteger;", "getAvailableItems", "", "", "", "", "syntize", "Ldan200/computercraft/api/lua/MethodResult;", "id", "amount", "", "transmute", "slot", "Companion", "peripheralworks-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nTransmutationTabletPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransmutationTabletPeripheral.kt\nsite/siredvin/peripheralworks/integrations/projecte/TransmutationTabletPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1557#2:106\n1628#2,3:107\n295#2,2:110\n*S KotlinDebug\n*F\n+ 1 TransmutationTabletPeripheral.kt\nsite/siredvin/peripheralworks/integrations/projecte/TransmutationTabletPeripheral\n*L\n41#1:106\n41#1:107,3\n55#1:110,2\n*E\n"})
public final class TransmutationTabletPeripheral<O extends IPeripheralOwner>
extends OwnedPeripheral<O> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isEnabled;
    @NotNull
    public static final String TYPE = "transmutation_table";

    public TransmutationTabletPeripheral(@NotNull O peripheralOwner, boolean isEnabled) {
        Intrinsics.checkNotNullParameter(peripheralOwner, (String)"peripheralOwner");
        super(TYPE, peripheralOwner);
        this.isEnabled = isEnabled;
        this.addPlugin((IPeripheralPlugin)new SuppliedRudimentInventoryPlugin(() -> TransmutationTabletPeripheral._init_$lambda$0(peripheralOwner), () -> TransmutationTabletPeripheral._init_$lambda$1(peripheralOwner)));
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private final IKnowledgeProvider getKnowledge() {
        Object object = this.getPeripheralOwner().getOwner();
        return object != null && (object = object.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY)) != null && (object = object.resolve()) != null ? (IKnowledgeProvider)((Optional)object).get() : null;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final BigInteger getEMC() {
        Object object = this.getKnowledge();
        if (object == null || (object = object.getEmc()) == null) {
            BigInteger bigInteger = BigInteger.ZERO;
            object = bigInteger;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> getAvailableItems() {
        List list;
        Object object = this.getKnowledge();
        if (object != null && (object = object.getKnowledge()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ItemInfo itemInfo = (ItemInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ItemStack itemStack = it.createStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createStack(...)");
                Map base = LuaRepresentation.INSTANCE.forItemStack(itemStack, RepresentationMode.BASE);
                base.remove("count");
                collection.add(base);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult syntize(@NotNull String id, int amount) {
        Object object;
        Object v6;
        IKnowledgeProvider kp;
        block5: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            ValidationHelpersKt.assertBetween((int)amount, (int)1, (int)1024, (String)"amount");
            IKnowledgeProvider iKnowledgeProvider = this.getKnowledge();
            if (iKnowledgeProvider == null) {
                Object[] objectArray = new Object[]{null, "Cannot find player"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
            kp = iKnowledgeProvider;
            RegistryWrapper registryWrapper = PlatformRegistries.INSTANCE.getITEMS();
            ResourceLocation resourceLocation = ResourceLocation.parse((String)id);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
            Item item = (Item)registryWrapper.get(resourceLocation);
            if (Intrinsics.areEqual((Object)item, (Object)Items.f_41852_)) {
                Object[] objectArray = new Object[]{null, "There is no such item"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
            Set set = kp.getKnowledge();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKnowledge(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemInfo it = (ItemInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getItem(), (Object)item)) continue;
                v6 = element$iv;
                break block5;
            }
            v6 = null;
        }
        ItemInfo itemInfo = v6;
        if (itemInfo == null) {
            Object[] $i$f$firstOrNull = new Object[]{null, "Such item is not learned"};
            MethodResult methodResult = MethodResult.of((Object[])$i$f$firstOrNull);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ItemInfo itemInfo2 = itemInfo;
        long cost = EMCHelper.getEmcValue((ItemInfo)itemInfo2);
        if (kp.getEmc().longValue() < cost * (long)amount) {
            object = new Object[]{null, "Not enough EMC"};
            MethodResult methodResult = MethodResult.of((Object[])object);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ItemStack stack = itemInfo2.createStack().m_255036_(amount);
        Intrinsics.checkNotNull((Object)stack);
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = this.getPeripheralOwner().getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        AgnosticItemSink agnosticItemSink = (AgnosticItemSink)slottedAgnosticItemStorage;
        BlockPos blockPos = this.getPeripheralOwner().getPos();
        Level level = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)level);
        ItemStorageUtils.INSTANCE.toInventoryOrToWorld(stack, agnosticItemSink, blockPos, level);
        BigInteger bigInteger = kp.getEmc();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getEmc(...)");
        object = bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(cost * (long)amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        BigInteger bigInteger3 = ((BigInteger)object).subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"subtract(...)");
        kp.setEmc(bigInteger3);
        Player player = this.getPeripheralOwner().getOwner();
        Intrinsics.checkNotNull((Object)player);
        kp.syncEmc((ServerPlayer)player);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult transmute(int slot) {
        IKnowledgeProvider iKnowledgeProvider = this.getKnowledge();
        if (iKnowledgeProvider == null) {
            Object[] objectArray = new Object[]{null, "Cannot find player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IKnowledgeProvider kp = iKnowledgeProvider;
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = this.getPeripheralOwner().getStorage();
        if (slottedAgnosticItemStorage == null) {
            Object[] objectArray = new Object[]{null, "Cannot find inventory"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        SlottedAgnosticItemStorage inventory = slottedAgnosticItemStorage;
        ValidationHelpersKt.assertBetween((int)slot, (int)1, (int)inventory.getSize(), (String)"slot");
        int realSlot = slot - 1;
        ItemStack stack = inventory.getItem(realSlot);
        if (!EMCHelper.doesItemHaveEmc((ItemStack)stack)) {
            Object[] objectArray = new Object[]{null, "Cannot transmute item"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        long cost = EMCHelper.getEmcSellValue((ItemStack)stack) * (long)stack.m_41613_();
        if (cost == 0L) {
            Object[] objectArray = new Object[]{null, "Cannot transmute item"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ItemStack realStack = inventory.takeItems(stack.m_41613_(), realSlot, realSlot, ItemStorageUtils.INSTANCE.getALWAYS());
        if (realStack.m_41619_()) {
            Object[] objectArray = new Object[]{null, "Something gone wrong"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        BigInteger bigInteger = kp.getEmc();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getEmc(...)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.valueOf(EMCHelper.getEmcSellValue((ItemStack)realStack) * (long)realStack.m_41613_());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
        BigInteger bigInteger4 = bigInteger2.add(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"add(...)");
        kp.setEmc(bigInteger4);
        ItemInfo info = ItemInfo.fromStack((ItemStack)realStack);
        ItemInfo itemInfo = NBTManager.getPersistentInfo((ItemInfo)info);
        Intrinsics.checkNotNullExpressionValue((Object)itemInfo, (String)"getPersistentInfo(...)");
        ItemInfo cleanedInfo = itemInfo;
        Player player = this.getPeripheralOwner().getOwner();
        Intrinsics.checkNotNull((Object)player);
        ServerPlayer player2 = (ServerPlayer)player;
        if (!kp.hasKnowledge(cleanedInfo) && !MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent((Player)player2, info, cleanedInfo)) && kp.addKnowledge(cleanedInfo)) {
            kp.syncKnowledgeChange(player2, cleanedInfo, true);
        }
        kp.syncEmc(player2);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final Level _init_$lambda$0(IPeripheralOwner $peripheralOwner) {
        Level level = $peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        return level;
    }

    private static final SlottedAgnosticItemStorage _init_$lambda$1(IPeripheralOwner $peripheralOwner) {
        SlottedAgnosticItemStorage slottedAgnosticItemStorage = $peripheralOwner.getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticItemStorage);
        return slottedAgnosticItemStorage;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralworks/integrations/projecte/TransmutationTabletPeripheral$Companion;", "", "<init>", "()V", "TYPE", "", "peripheralworks-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

