/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.subsystem.configurator;

import dan200.computercraft.api.peripheral.IPeripheral;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralworks.PeripheralWorksCore;
import site.siredvin.peripheralworks.common.blockentity.PeripheralProxyBlockEntity;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.peripheralworks.data.ModText;
import site.siredvin.peripheralworks.data.ModTooltip;
import site.siredvin.peripheralworks.subsystem.configurator.ConfigurationMode;
import site.siredvin.peripheralworks.tags.BlockTags;
import site.siredvin.tweakium.modules.platform.ComputerPlatformToolkit;
import site.siredvin.tweakium.modules.platform.api.InnerComputerPlatformToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/subsystem/configurator/PeripheralProxyMode;", "Lsite/siredvin/peripheralworks/subsystem/configurator/ConfigurationMode;", "<init>", "()V", "modeID", "Lnet/minecraft/resources/ResourceLocation;", "getModeID$annotations", "getModeID", "()Lnet/minecraft/resources/ResourceLocation;", "description", "Lnet/minecraft/network/chat/Component;", "getDescription", "()Lnet/minecraft/network/chat/Component;", "onBlockClick", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "configurationTarget", "Lnet/minecraft/core/BlockPos;", "stack", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "level", "Lnet/minecraft/world/level/Level;", "peripheralworks-forge-1.20.1"})
public final class PeripheralProxyMode
implements ConfigurationMode {
    @NotNull
    public static final PeripheralProxyMode INSTANCE = new PeripheralProxyMode();
    @NotNull
    private static final ResourceLocation modeID = new ResourceLocation("peripheralworks", "peripheral_proxy");
    @NotNull
    private static final Component description = (Component)ModTooltip.PERIPHERAL_PROXY_MODE.getText();

    private PeripheralProxyMode() {
    }

    @Override
    @NotNull
    public ResourceLocation getModeID() {
        return modeID;
    }

    public static /* synthetic */ void getModeID$annotations() {
    }

    @Override
    @NotNull
    public Component getDescription() {
        return description;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onBlockClick(@NotNull BlockPos configurationTarget, @NotNull ItemStack stack, @NotNull Player player, @NotNull BlockHitResult hit, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)configurationTarget, (String)"configurationTarget");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        BlockEntity entity = ((ServerLevel)level).m_7702_(configurationTarget);
        if (!(entity instanceof PeripheralProxyBlockEntity)) {
            PeripheralWorksCore.INSTANCE.getLogger().error("Peripheral proxy configuration mode renderer process " + configurationTarget + " which is not peripheral proxy");
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        if (Intrinsics.areEqual((Object)((PeripheralProxyBlockEntity)entity).m_58899_(), (Object)hit.m_82425_())) {
            player.m_5661_((Component)ModText.PERIPHERAL_PROXY_NOT_SELF.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        BlockState targetBlock = ((ServerLevel)level).m_8055_(hit.m_82425_());
        if (targetBlock.m_204336_(BlockTags.INSTANCE.getPERIPHERAL_PROXY_FORBIDDEN())) {
            player.m_5661_((Component)ModText.PERIPHERAL_PROXY_FORBIDDEN.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        PeripheralProxyBlockEntity peripheralProxyBlockEntity = (PeripheralProxyBlockEntity)entity;
        BlockPos blockPos = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        if (!peripheralProxyBlockEntity.isPosApplicable(blockPos)) {
            player.m_5661_((Component)ModText.PERIPHERAL_PROXY_TOO_FAR.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        if (!((PeripheralProxyBlockEntity)entity).getRemotePeripherals().containsKey(hit.m_82425_()) && ((PeripheralProxyBlockEntity)entity).getRemotePeripherals().size() >= PeripheralWorksConfig.INSTANCE.getPeripheralProxyMaxCapacity()) {
            player.m_5661_((Component)ModText.PERIPHERAL_PROXY_TOO_MANY.getText(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        InnerComputerPlatformToolkit innerComputerPlatformToolkit = ComputerPlatformToolkit.INSTANCE.get();
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos2 = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Direction direction = hit.m_82434_();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getDirection(...)");
        IPeripheral targetPeripheral = innerComputerPlatformToolkit.getPeripheral(serverLevel, blockPos2, direction);
        if (targetPeripheral == null) {
            PeripheralProxyBlockEntity peripheralProxyBlockEntity2 = (PeripheralProxyBlockEntity)entity;
            BlockPos blockPos3 = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"getBlockPos(...)");
            if (!peripheralProxyBlockEntity2.containsPos(blockPos3)) {
                player.m_5661_((Component)ModText.PERIPHERAL_PROXY_IS_NOT_A_PERIPHERAL.getText(), true);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                return interactionResultHolder;
            }
        }
        if (targetPeripheral != null) {
            PeripheralProxyBlockEntity peripheralProxyBlockEntity3 = (PeripheralProxyBlockEntity)entity;
            BlockPos blockPos4 = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"getBlockPos(...)");
            Direction direction2 = hit.m_82434_();
            Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getDirection(...)");
            if (peripheralProxyBlockEntity3.togglePos(blockPos4, direction2, targetPeripheral)) {
                player.m_5661_((Component)ModText.PERIPHERAL_PROXY_BLOCK_ADDED.getText(), true);
            } else {
                player.m_5661_((Component)ModText.PERIPHERAL_PROXY_BLOCK_REMOVED.getText(), true);
            }
        } else {
            PeripheralProxyBlockEntity peripheralProxyBlockEntity4 = (PeripheralProxyBlockEntity)entity;
            BlockPos blockPos5 = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"getBlockPos(...)");
            if (peripheralProxyBlockEntity4.removePosToTrack(blockPos5)) {
                player.m_5661_((Component)ModText.PERIPHERAL_PROXY_BLOCK_REMOVED.getText(), true);
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }
}

