/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.computercraft;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;
import site.siredvin.broccolium.modules.storage.item.api.SlottedAgnosticItemStorage;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.common.configuration.PeripheralWorksConfig;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.plugins.InventoryPlugin;
import site.siredvin.tweakium.modules.plugins.ItemStoragePlugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/peripheralworks/computercraft/StorageProvider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "<init>", "()V", "pluginType", "", "getPluginType", "()Ljava/lang/String;", "conflictWith", "", "getConflictWith", "()Ljava/util/Set;", "provide", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "side", "Lnet/minecraft/core/Direction;", "peripheralworks-forge-1.20.1"})
public final class StorageProvider
implements PeripheralPluginProvider {
    @NotNull
    public static final StorageProvider INSTANCE = new StorageProvider();

    private StorageProvider() {
    }

    @Override
    @NotNull
    public String getPluginType() {
        return "storage";
    }

    @Override
    @NotNull
    public Set<String> getConflictWith() {
        Object[] objectArray = new String[]{"inventory", "item_storage"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public IPeripheralPlugin provide(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (!PeripheralWorksConfig.INSTANCE.getEnableGenericItemStorage() && !PeripheralWorksConfig.INSTANCE.getEnableGenericInventory()) {
            return null;
        }
        AgnosticItemStorage agnosticItemStorage = AgnosticItemStorageLookup.INSTANCE.extractFromBlock(level, pos, level.m_7702_(pos), side);
        if (agnosticItemStorage == null) {
            return null;
        }
        AgnosticItemStorage storage = agnosticItemStorage;
        if (storage instanceof SlottedAgnosticItemStorage && PeripheralWorksConfig.INSTANCE.getEnableGenericInventory() && ((SlottedAgnosticItemStorage)storage).getSize() != 0) {
            return (IPeripheralPlugin)new InventoryPlugin(level, (SlottedAgnosticItemStorage)storage);
        }
        if (PeripheralWorksConfig.INSTANCE.getEnableGenericItemStorage()) {
            return (IPeripheralPlugin)new ItemStoragePlugin(storage, level, PeripheralWorksConfig.INSTANCE.getItemStorageTransferLimit());
        }
        return null;
    }
}

