/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.occultism;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u001e\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lsite/siredvin/peripheralworks/integrations/occultism/OccultismItemStorage;", "Lsite/siredvin/broccolium/modules/storage/item/api/AgnosticItemStorage;", "storageController", "Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;", "<init>", "(Lcom/klikli_dev/occultism/api/common/blockentity/IStorageController;)V", "getItems", "", "Lnet/minecraft/world/item/ItemStack;", "maxStackSize", "", "getMaxStackSize", "()I", "setChanged", "", "storeItem", "stack", "takeItems", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralworks-forge-1.20.1"})
public final class OccultismItemStorage
implements AgnosticItemStorage {
    @NotNull
    private final IStorageController storageController;

    public OccultismItemStorage(@NotNull IStorageController storageController) {
        Intrinsics.checkNotNullParameter((Object)storageController, (String)"storageController");
        this.storageController = storageController;
    }

    @NotNull
    public Iterator<ItemStack> getItems() {
        return this.storageController.getStacks().iterator();
    }

    public int getMaxStackSize() {
        int n;
        if (((Boolean)Occultism.SERVER_CONFIG.storage.overrideItemStackSizes.get()).booleanValue()) {
            Object object = Occultism.SERVER_CONFIG.storage.controllerStackSize.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            n = ((Number)object).intValue();
        } else {
            n = 64;
        }
        return n;
    }

    public void setChanged() {
        this.storageController.onContentsChanged();
    }

    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int returnedAmount = this.storageController.insertStack(stack, false);
        ItemStack itemStack = stack.m_255036_(returnedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack takeItems(@NotNull Predicate<ItemStack> predicate, int limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ItemStack itemStack = this.storageController.getItemStack(predicate, limit, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        return itemStack;
    }
}

