/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.Weather;
import java.util.HashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1702;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public final class Temperature {
    private static final int TICKS_AMPLIFIER = Math.max(4, 1);
    private static final int UPDATE_EVERY_TICKS = 5 * TICKS_AMPLIFIER;
    public static final float MIN_COMFORTABLE_TEMPERATURE = 15.0f;
    public static final float MAX_COMFORTABLE_TEMPERATURE = 30.0f;
    public static final float MIN_TEMPERATURE_BODY = 27.0f;
    public static final float MAX_TEMPERATURE_BODY = 43.0f;
    public static final float AVERAGE_TEMPERATURE_BODY = 36.6f;
    final class_1282 hypothermia;
    final class_1282 hyperthermia;
    final Health health;
    float temperature = 36.6f;
    float warm = 0.0f;
    int i = 0;

    public Temperature(Health health) {
        this.health = health;
        this.hypothermia = Util.getDamageSource(ModDamageTypes.HYPOTHERMIA, health.getPlayer());
        this.hyperthermia = Util.getDamageSource(ModDamageTypes.HYPERTHERMIA, health.getPlayer());
    }

    public void update() {
        if (ModServer.getInstance().getProperties().hasTemperature()) {
            if (this.i++ >= TICKS_AMPLIFIER - 1) {
                Weather weather = ModServer.getInstance().getWeather();
                float worldTemp = 22.0f;
                float d = 0.0f;
                HashMap<class_2338, class_2680> map = Util.getBlocksInRadius(this.getHealth().getPlayer().method_37908(), this.getHealth().getPlayer().method_24515(), 5);
                for (class_2338 pos : map.keySet()) {
                    if (!map.get(pos).method_26204().equals(class_2246.field_10164)) continue;
                    float distance = (float)pos.method_46558().method_1022(this.getHealth().getPlayer().method_19538());
                    this.warm = Math.max(5.0f - distance, this.warm);
                }
                if (weather.getWorld().equals(this.getHealth().getPlayer().method_37908())) {
                    worldTemp = weather.getTemperatureOnPos(this.getHealth().getPlayer().method_24515());
                    worldTemp += this.warm * 6.0f;
                    worldTemp -= weather.getInfluenceOnEntity(this.getHealth().getPlayer());
                    d = weather.getWeatherProtection(this.getHealth().getPlayer());
                    worldTemp += d * 3.0f;
                }
                class_1702 hunger = this.getHealth().getPlayer().method_7344();
                float foodLevelPercent = (float)hunger.method_7586() / 20.0f;
                float thirstLevel = this.getHealth().getThirst().getAmount();
                float hpPercent = this.getHealth().getMaxSumHp() / this.getHealth().getSumHp();
                if (worldTemp < 15.0f) {
                    this.temperature -= (15.0f - worldTemp) / 2.0f / 10000.0f / Math.max((36.6f - this.temperature) / 5.0f, 1.0f) / (1.0f + this.getHealth().getExhaustion().getAmount() / 3.0f) / (hpPercent * hpPercent) / ((foodLevelPercent + 2.0f) / 3.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                } else if (worldTemp - this.warm / 2.0f - d / 2.0f > 30.0f) {
                    this.temperature += (worldTemp - 30.0f) / 2.0f / 10000.0f / Math.max(36.6f - this.temperature, 1.0f) * (1.0f + this.getHealth().getExhaustion().getAmount() / 2.0f) / 5.0f * (thirstLevel + 1.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                } else if (this.temperature < 36.5f) {
                    this.temperature += 0.003f * (foodLevelPercent / 2.0f + 0.5f) * (hpPercent * hpPercent) * Math.max(this.warm / 3.0f, 1.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                    this.getHealth().getHunger().reduceHunger(0.01f);
                } else if (this.temperature > 36.699997f) {
                    this.temperature -= 0.003f / ((thirstLevel + 1.0f) * 1.5f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                    this.getHealth().getThirst().setAmount(this.getHealth().getThirst().getAmount() + 0.001f * (float)UPDATE_EVERY_TICKS);
                }
                this.setWarm(0.0f);
                this.i = 0;
            }
            if (this.temperature < 34.0f) {
                this.getHealth().getExhaustion().addAmplifier(Float.valueOf(1.35f));
                this.getHealth().updateStatusEffect(ModStatusEffects.HYPOTHERMIA, 1);
                if (this.temperature < 27.0f) {
                    this.getHealth().onDeath(this.hypothermia);
                }
            } else if (this.temperature > 39.0f) {
                this.getHealth().getExhaustion().addAmplifier(Float.valueOf(1.35f));
                this.getHealth().updateStatusEffect(ModStatusEffects.HYPERTHERMIA, 1);
                if (this.temperature > 43.0f) {
                    this.getHealth().onDeath(this.hyperthermia);
                }
            }
        } else {
            this.setTemperature(36.6f);
        }
    }

    public void onSleep() {
        if (Math.pow(36.6f - this.getTemperature(), 1.0) > 1.0) {
            this.heal(5);
        }
    }

    public void heal(int divisor) {
        this.setTemperature((36.6f * (float)divisor + this.getTemperature()) / (float)(2 + (divisor - 1)));
    }

    public void cool(float amount) {
        this.temperature = this.getTemperature() - amount > 36.6f ? (this.temperature -= amount) : (this.temperature -= Math.max(amount / 5.0f, this.getTemperature() - 36.6f));
    }

    public Health getHealth() {
        return this.health;
    }

    public void setWarm(float warm) {
        this.warm = warm;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature > 0.0f ? temperature : 0.0f;
    }
}

