/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.AbstractCondition;
import java.util.ArrayList;
import net.minecraft.class_1291;
import net.minecraft.class_1294;

public class Exhaustion
extends AbstractCondition {
    float amount;
    ArrayList<Float> amplifiers = new ArrayList();

    public Exhaustion(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.EXHAUSTION;
    }

    @Override
    public float getAmount() {
        return this.amount;
    }

    @Override
    public String getName() {
        return "exhaustion";
    }

    @Override
    public void setAmount(float amount) {
        this.amount = amount > 0.0f ? amount : 0.0f;
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getHealth().getPlayer().method_6029();
        if (speed > 0.1f) {
            this.setAmount(this.getAmount() + 0.001f * ConfigArgs.EXHAUSTION_MULTIPLIER.getFloatValue().floatValue() * this.getSumAmplifiers() * 5.0f);
        } else {
            this.setAmount(this.getAmount() - 0.001f * ConfigArgs.EXHAUSTION_MULTIPLIER.getFloatValue().floatValue() * 5.0f);
        }
        if (this.amount > 1.5f) {
            this.getHealth().updateStatusEffect(class_1294.field_5909, (int)this.amount);
            this.getHealth().updateStatusEffect(class_1294.field_5901, (int)this.amount);
        }
        this.amplifiers.clear();
    }

    public void onSleep() {
        this.setAmount(0.0f);
        this.amplifiers.clear();
    }

    public void addAmplifier(Float amplifier) {
        if (!this.amplifiers.contains(amplifier)) {
            this.amplifiers.add(amplifier);
        }
    }

    public float getSumAmplifiers() {
        float sum = 1.0f;
        for (float f : this.amplifiers) {
            sum += f - 1.0f;
        }
        return sum;
    }
}

