/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import aiven.zomboidhealthsystem.infrastructure.config.JsonObject;
import java.io.IOException;

public class Config {
    private static Config INSTANCE = null;
    public final String minecraftDir;
    private JsonHelper helper;

    private Config(String minecraftDir) throws IOException {
        this.minecraftDir = minecraftDir;
        this.helper = new JsonHelper(new JsonObject(minecraftDir + "/config", "zomboidhealthsystem-1.1.json"));
        if (!this.helper.file().wasFile()) {
            this.helper.setDefault(new Codec[0]);
        }
    }

    public <T> Argument<T> addArgument(Codec<T> codec) {
        Argument<T> argument = new Argument<T>(codec, this.helper);
        if (this.helper != null && !this.helper.file().wasFile()) {
            try {
                this.helper.writeCodecsInConfig(codec);
                this.helper.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return argument;
    }

    public static void initialize() throws IOException {
        INSTANCE = new Config(Util.getMinecraftDirectory());
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    public static class Argument<T> {
        private final Codec<T> codec;
        private final T defaultValue;
        private final JsonHelper helper;
        private String value;

        private Argument(Codec<T> defaultValue, JsonHelper helper) {
            this.codec = defaultValue;
            this.defaultValue = defaultValue.getValue();
            this.helper = helper;
        }

        public void setValue(T value) {
            try {
                this.codec.setValue(value);
                this.helper.writeCodecsInConfig(this.codec);
                this.helper.save();
                this.value = value.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getStringValue() {
            if (this.value == null) {
                try {
                    this.value = this.helper.getValue(this.codec);
                    if (this.value == null) {
                        this.value = this.defaultValue.toString();
                    }
                }
                catch (Exception e) {
                    this.value = this.defaultValue.toString();
                }
                return this.value;
            }
            return this.value;
        }

        public Float getFloatValue() {
            return Float.valueOf(Float.parseFloat(this.getStringValue()));
        }

        public Double getDoubleValue() {
            return Double.parseDouble(this.getStringValue());
        }

        public Integer getIntegerValue() {
            return Integer.parseInt(this.getStringValue());
        }

        public Boolean getBooleanValue() {
            return Boolean.parseBoolean(this.getStringValue());
        }
    }
}

