/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem;

import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import java.io.File;
import java.io.IOException;
import net.fabricmc.api.DedicatedServerModInitializer;

public class ZomboidHealthSystemServer
implements DedicatedServerModInitializer {
    public static final String PATH = System.getProperty("user.dir");
    public static final Codec<WorldProperties> DEFAULT_PROPERTIES = new Codec<Object>("default world properties", null);

    public void onInitializeServer() {
        ZomboidHealthSystem.isServer = true;
    }

    public static void initialize() throws IOException {
        File file = new File(PATH, "zomboidhealthsystem-server.json");
        boolean bl = file.exists();
        if (!bl) {
            DEFAULT_PROPERTIES.setValue(ModServer.WORLD_PROPERTIES_ON_START);
        }
        JsonConfig config = new JsonConfig(file);
        if (!bl) {
            DEFAULT_PROPERTIES.setValue(ModServer.WORLD_PROPERTIES_ON_START);
            config.add(DEFAULT_PROPERTIES);
        } else {
            DEFAULT_PROPERTIES.setValue(WorldProperties.parseWorldProperties(config.getValue(DEFAULT_PROPERTIES)));
            ModServer.WORLD_PROPERTIES_ON_START = DEFAULT_PROPERTIES.getValue();
        }
    }
}

