/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.foundation.player.Health;
import net.minecraft.class_1291;
import net.minecraft.class_1657;

public abstract class Condition {
    final Health health;
    protected float amount;

    public Condition(Health health) {
        this.health = health;
    }

    public boolean hasIcon() {
        return this.getAmount() >= 1.0f;
    }

    public void update() {
        if (this.getEffect() != null) {
            if (!this.hasIcon()) {
                if (this.getPlayer().method_6059(this.getEffect())) {
                    this.getHealth().clearEffect(this.getEffect());
                }
            } else {
                if (this.getPlayer().method_6059(this.getEffect()) && this.getPlayer().method_6112(this.getEffect()).method_5578() != this.getEffectAmplifier() - 1) {
                    this.getHealth().clearEffect(this.getEffect());
                }
                this.getHealth().addStatusEffect(this.getEffect(), Math.min((int)this.getAmount(), 10), 300);
            }
        }
    }

    public void onSleep() {
    }

    boolean random(int time) {
        return Health.random(time);
    }

    public String getNbt() {
        if (this.amount == 0.0f) {
            return null;
        }
        return String.valueOf(this.getAmount());
    }

    public void readNbt(String value) {
        this.setAmount(Float.parseFloat(value));
    }

    public Health getHealth() {
        return this.health;
    }

    public class_1657 getPlayer() {
        return this.getHealth().getPlayer();
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public void addAmount(float amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public int getEffectAmplifier() {
        return (int)this.getAmount();
    }

    abstract class_1291 getEffect();

    public abstract String getId();
}

