/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_2561;

public class Drowsiness
extends Condition {
    public static int DROWSINESS_TIME = 24000 * ModServer.WORLD_PROPERTIES_ON_START.getDayLengthMultiplier();
    public class_1282 source = Util.getDamageSource(ModDamageTypes.DROWSINESS, this.getPlayer().method_37908());
    private float caffeine = 0.0f;
    private float max_caffeine = 0.0f;
    private boolean caffeine_effect = true;
    private float sleeping_pills = 0.0f;
    private float max_sleeping_pills = 0.0f;

    public Drowsiness(Health health) {
        super(health);
        DROWSINESS_TIME = 24000 * ModServer.getInstance().getProperties().getDayLengthMultiplier();
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.DROWSINESS;
    }

    @Override
    public String getId() {
        return "drowsiness";
    }

    @Override
    public String getNbt() {
        if (this.getAmount() != 0.0f || this.caffeine != 0.0f || this.max_caffeine != 0.0f) {
            JsonBuilder builder = new JsonBuilder();
            if (this.getAmount() != 0.0f) {
                builder.append("amount", String.valueOf(this.getAmount()));
            }
            if (this.caffeine != 0.0f) {
                builder.append("caffeine", String.valueOf(this.caffeine));
            }
            if (this.max_caffeine != 0.0f) {
                builder.append("max_caffeine", String.valueOf(this.max_caffeine));
            }
            if (!this.caffeine_effect) {
                builder.append("caffeine_effect", String.valueOf(this.caffeine_effect));
            }
            if (this.sleeping_pills != 0.0f) {
                builder.append("sleeping_pills", String.valueOf(this.sleeping_pills));
            }
            if (this.max_sleeping_pills != 0.0f) {
                builder.append("max_sleeping_pills", String.valueOf(this.max_sleeping_pills));
            }
            return builder.get();
        }
        return null;
    }

    @Override
    public void readNbt(String value) {
        String amount = JsonConfig.getValue(value, "amount");
        String caffeine = JsonConfig.getValue(value, "caffeine");
        String max_caffeine = JsonConfig.getValue(value, "max_caffeine");
        String caffeine_effect = JsonConfig.getValue(value, "caffeine_effect");
        String sleeping_pills = JsonConfig.getValue(value, "sleeping_pills");
        String max_sleeping_pills = JsonConfig.getValue(value, "max_sleeping_pills");
        if (amount != null) {
            this.setAmount(Float.parseFloat(amount));
        }
        if (caffeine != null && max_caffeine != null) {
            this.caffeine = Float.parseFloat(caffeine);
            this.max_caffeine = Float.parseFloat(max_caffeine);
        }
        if (caffeine_effect != null) {
            this.caffeine_effect = Boolean.parseBoolean(caffeine_effect);
        }
        if (sleeping_pills != null && max_sleeping_pills != null) {
            this.sleeping_pills = Float.parseFloat(sleeping_pills);
            this.max_sleeping_pills = Float.parseFloat(max_sleeping_pills);
        }
    }

    @Override
    public void update() {
        super.update();
        this.addTicks(1.0f * (this.getHealth().getExhaustion().getAmount() + 1.0f) * 1.85f * ConfigArgs.DROWSINESS_MULTIPLIER.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY);
        if (this.caffeine_effect) {
            if (this.caffeine < this.max_caffeine) {
                this.caffeine += 8.3333335E-4f * (float)Health.UPDATE_FREQUENCY;
            } else if (this.max_caffeine != 0.0f) {
                this.caffeine_effect = false;
            }
        } else if (this.caffeine > this.max_caffeine * -0.75f) {
            this.caffeine -= 1.0f / ((float)DROWSINESS_TIME / 4.0f) * (float)Health.UPDATE_FREQUENCY;
        }
        if (this.sleeping_pills < this.max_sleeping_pills) {
            float speed = ConfigArgs.SLEEPING_PILLS_SPEED.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY;
            this.sleeping_pills = Math.min(this.sleeping_pills + speed, this.max_sleeping_pills);
            this.addAmount(speed);
        } else {
            this.sleeping_pills = 0.0f;
            this.max_sleeping_pills = 0.0f;
        }
        this.getHealth().getExhaustion().addMultiplier(Float.valueOf(this.getAmplifier() / 3.0f + 1.0f));
        if (this.getAmplifier() >= 1.0f) {
            if (this.random((int)(6000.0f / this.getAmplifier()))) {
                this.getHealth().addStatusEffect(class_1294.field_5919, 1, 100);
            }
            if (this.getAmplifier() >= 2.0f) {
                if (this.random((int)(6000.0f / (this.getAmplifier() / 2.0f))) && this.getHealth().getPlayer().method_6029() > 0.1f) {
                    this.getHealth().stumble();
                }
                this.getHealth().getExhaustion().addMultiplier(Float.valueOf(this.getAmplifier()));
                if (this.getAmplifier() >= 3.0f) {
                    this.getHealth().addStatusEffect(class_1294.field_5901, (int)(this.getAmplifier() / 2.0f), 300);
                    if (this.getAmplifier() >= 5.0f) {
                        this.getHealth().onDeath(this.source);
                    }
                }
            }
        }
        if (this.getPlayer().method_6113() && this.getAmplifier() < (float)ConfigArgs.MIN_DROWSINESS_FOR_SLEEP.getValue().intValue()) {
            this.getPlayer().method_18400();
            this.getPlayer().method_7353((class_2561)class_2561.method_43471((String)"zomboidhealthsystem.message.dont_want_sleep"), true);
        }
    }

    @Override
    public void onSleep() {
        this.max_caffeine = 0.0f;
        this.caffeine = 0.0f;
        this.caffeine_effect = true;
        this.sleeping_pills = 0.0f;
        this.max_sleeping_pills = 0.0f;
        this.amount = 0.0f;
    }

    @Override
    public boolean hasIcon() {
        return this.getAmplifier() >= 1.0f;
    }

    @Override
    public int getEffectAmplifier() {
        return (int)this.getAmplifier();
    }

    public float getAmplifier() {
        return this.amount - this.caffeine;
    }

    public void addCaffeine(float amount) {
        this.max_caffeine += amount;
        this.caffeine_effect = true;
    }

    public void addSleepingPills(float amount) {
        this.max_sleeping_pills += amount;
    }

    public boolean hasCaffeine() {
        return this.caffeine != 0.0f && this.max_caffeine != 0.0f;
    }

    public void addTicks(float amount) {
        this.addAmount(amount / (float)DROWSINESS_TIME);
    }
}

