/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public class Pain
extends Condition {
    private float painkillerAmount = 0.0f;
    private float painkillerMaxAmount = 0.0f;
    private boolean painkillerEffect = true;

    public Pain(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.PAIN;
    }

    @Override
    public void update() {
        super.update();
        class_1657 player = this.getHealth().getPlayer();
        if (this.painkillerEffect) {
            if (this.painkillerAmount < this.painkillerMaxAmount) {
                this.painkillerAmount += 8.3333335E-4f * (float)Health.UPDATE_FREQUENCY;
            } else {
                this.painkillerEffect = false;
            }
        } else if (this.painkillerAmount > 0.0f) {
            float speed = 8.333333E-5f * (float)Health.UPDATE_FREQUENCY;
            this.painkillerAmount -= speed;
            this.painkillerMaxAmount -= speed;
        } else {
            this.painkillerAmount = 0.0f;
            this.painkillerMaxAmount = 0.0f;
        }
        if (player.method_6113() && ConfigArgs.PAIN_KEEPS_AWAKE.getValue().booleanValue() && this.getAmount() >= 1.0f && this.getHealth().getDrowsiness().getAmplifier() < 2.0f) {
            player.method_18400();
            player.method_7353((class_2561)class_2561.method_43471((String)"zomboidhealthsystem.message.pain_not_sleep"), true);
        }
    }

    @Override
    public void onSleep() {
        super.onSleep();
        this.painkillerAmount = 0.0f;
        this.painkillerMaxAmount = 0.0f;
        this.painkillerEffect = true;
    }

    @Override
    public float getAmount() {
        return this.getPain();
    }

    @Override
    public void setAmount(float amount) {
    }

    @Override
    public String getId() {
        return "pain";
    }

    @Override
    public String getNbt() {
        if (this.painkillerAmount != 0.0f) {
            JsonBuilder builder = new JsonBuilder();
            builder.append("painkiller_amount", String.valueOf(this.painkillerAmount));
            builder.append("painkiller_max_amount", String.valueOf(this.painkillerMaxAmount));
            builder.append("painkiller_effect", String.valueOf(this.painkillerEffect));
            return builder.get();
        }
        return null;
    }

    @Override
    public void readNbt(String value) {
        String amount = JsonConfig.getValue(value, "painkiller_amount");
        String max_amount = JsonConfig.getValue(value, "painkiller_max_amount");
        String effect = JsonConfig.getValue(value, "painkiller_effect");
        if (amount != null) {
            this.painkillerAmount = Float.parseFloat(amount);
        }
        if (max_amount != null) {
            this.painkillerMaxAmount = Float.parseFloat(max_amount);
        }
        if (effect != null) {
            this.painkillerEffect = Boolean.parseBoolean(effect);
        }
    }

    public void applyEffects() {
        if (this.getPain() >= 1.0f && this.getPain() >= 10.0f) {
            this.health.addStatusEffect(class_1294.field_5919, 1, 100);
        }
    }

    public void addPainkiller(float amount) {
        this.painkillerMaxAmount += amount;
        this.painkillerEffect = true;
    }

    public float getPain() {
        float pain = 0.0f;
        for (Health.BodyPart part : this.getHealth().getBodyParts()) {
            pain += part.getPain() / 2.0f;
        }
        return pain / (this.painkillerAmount + 1.0f);
    }
}

