/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;

public class Thirst
extends Condition {
    private final class_1282 source = Util.getDamageSource(ModDamageTypes.THIRST, this.getPlayer().method_37908());
    private final float speed = 3.3333334E-5f;

    public Thirst(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.THIRST;
    }

    @Override
    public String getId() {
        return "thirst";
    }

    @Override
    public void setAmount(float amount) {
        this.amount = Math.max(0.0f, amount);
    }

    @Override
    public void update() {
        super.update();
        this.addAmount(3.3333334E-5f * (this.getHealth().getExhaustion().getAmount() / 1.5f + 1.0f) * ConfigArgs.THIRST_MULTIPLIER.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY);
        if (this.amount >= 1.0f) {
            this.getHealth().getExhaustion().addMultiplier(Float.valueOf(this.amount));
            if (this.amount >= 2.0f) {
                if (this.random(4800)) {
                    this.getHealth().addStatusEffect(class_1294.field_5919, 1, 200);
                }
                if (this.amount >= 2.4f) {
                    if (this.random(2400)) {
                        this.getHealth().stumble(0.0f);
                    }
                    if (this.amount >= 2.8f) {
                        this.getHealth().addStatusEffect(class_1294.field_5919, 1, 300);
                        if (this.random(1200)) {
                            this.getHealth().stumble(0.0f);
                        }
                        if (this.amount >= 3.1f) {
                            this.getHealth().onDeath(this.source);
                        }
                    }
                }
            }
        }
    }

    public void drink(float amount, boolean clean) {
        if (clean) {
            this.addAmount(-amount);
        }
        this.getHealth().getTemperature().cool(0.5f);
    }

    @Override
    public void onSleep() {
        this.setAmount(this.getAmount() + 0.35f);
    }

    public float getSpeed() {
        return 3.3333334E-5f;
    }
}

