/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.util.HashMap;
import net.minecraft.class_1291;
import net.minecraft.class_1657;

public abstract class Condition {
    public static int UPDATE_EVERY_TICKS = 5;
    final Health health;
    protected float amount;

    public Condition(Health health) {
        this.health = health;
    }

    public boolean hasIcon() {
        return this.getAmount() >= 1.0f;
    }

    public void update() {
        if (!this.hasIcon()) {
            if (this.getPlayer().method_6059(this.getEffect())) {
                this.getHealth().clearEffect(this.getEffect());
            }
        } else {
            if (this.getPlayer().method_6059(this.getEffect()) && this.getPlayer().method_6112(this.getEffect()).method_5578() != this.getEffectAmplifier() - 1) {
                this.getHealth().clearEffect(this.getEffect());
            }
            this.getHealth().updateStatusEffect(this.getEffect(), Math.min((int)this.getAmount(), 10));
        }
    }

    public void onSleep() {
    }

    boolean random(int time) {
        return Health.random(time);
    }

    public HashMap<String, String> getNbt() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.amount == 0.0f) {
            return null;
        }
        map.put(this.getId(), String.valueOf(this.amount));
        return map;
    }

    public void readNbt(String text) {
        String value = JsonHelper.getValue(text, this.getId());
        if (value != null) {
            this.setAmount(Float.parseFloat(value));
        } else {
            this.setAmount(0.0f);
        }
    }

    public Health getHealth() {
        return this.health;
    }

    public class_1657 getPlayer() {
        return this.getHealth().getPlayer();
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public int getEffectAmplifier() {
        return (int)this.getAmount();
    }

    abstract class_1291 getEffect();

    public abstract String getId();
}

