/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class JsonFile
extends File {
    private final boolean wasFile;
    private String content = "";

    public JsonFile(String path, String name) throws IOException {
        super(path, name);
        if (super.exists()) {
            this.wasFile = true;
            this.content = this.read();
        } else {
            this.wasFile = false;
            super.createNewFile();
        }
    }

    public void write(String text) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this);
        fileOutputStream.write(text.getBytes());
        fileOutputStream.close();
        this.content = text;
    }

    public void add(String text) {
        this.content = this.content + text;
    }

    public void delete(String text) {
        this.content = this.content.replaceAll(text, "");
    }

    public void clear() throws IOException {
        this.write("");
    }

    public boolean save() throws IOException {
        this.write(this.content);
        return this.createNewFile();
    }

    public String read() throws IOException {
        StringBuilder text = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(this);
        for (byte i : fileInputStream.readAllBytes()) {
            text.append((char)i);
        }
        fileInputStream.close();
        return text.toString();
    }

    public boolean wasFile() {
        return this.wasFile;
    }

    public String getContent() {
        return this.content;
    }
}

