/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public record JsonHelper(JsonFile file) {
    public void save() throws IOException {
        this.file.save();
    }

    public void setDefault(Codec<?> ... codecs) throws IOException {
        int index = 0;
        this.file.write("{\n\t");
        for (Codec<?> codec : codecs) {
            this.file.add(codec.toString());
            if (index == codecs.length - 1) break;
            this.file.add(",\n\t");
            ++index;
        }
        this.file.add("\n}");
        this.file.save();
    }

    private synchronized void addCodecInConfig(Codec<?> codec) {
        this.file.delete("\n}");
        if (this.file.getContent().length() != 3) {
            this.file.add(",\n\t" + codec.toString() + "\n}");
        } else {
            this.file.add(codec.toString() + "\n}");
        }
    }

    public synchronized void writeCodecsInConfig(Codec<?> ... codecs) throws IOException {
        for (Codec<?> codec : codecs) {
            Character symbol = null;
            String value = this.getValue(codec);
            StringBuilder text = new StringBuilder();
            if (value == null) {
                this.addCodecInConfig(codec);
                continue;
            }
            if (!(codec.getValue() instanceof String)) {
                if (codec.getStringValue().contains("}")) {
                    symbol = Character.valueOf('}');
                } else if (codec.getStringValue().contains("]")) {
                    symbol = Character.valueOf(']');
                }
            }
            char[] chars = this.file.getContent().toCharArray();
            int index = 0;
            while (text.indexOf("\"" + codec.getName() + "\"") == -1) {
                text.append(chars[index]);
                ++index;
            }
            if (symbol == null) {
                text.append(": " + codec.getStringValue());
                while (chars[index] != ',' && chars[index] != '\n') {
                    ++index;
                }
            } else {
                text.append(": " + codec.getStringValue());
                int i = 0;
                boolean bl = false;
                while (i != 0 || !bl) {
                    if (chars[index] == '{' || chars[index] == '[') {
                        ++i;
                        bl = true;
                    } else if (chars[index] == '}' || chars[index] == ']') {
                        --i;
                    }
                    ++index;
                }
            }
            while (index < chars.length) {
                text.append(chars[index]);
                ++index;
            }
            this.file.write(text.toString());
        }
    }

    public String getValue(Codec<?> codec) {
        return this.getValue(codec.getName());
    }

    public String getValue(String name) {
        return JsonHelper.getValue(this.file.getContent(), name);
    }

    @Override
    @NotNull
    public String toString() {
        return this.file.getContent();
    }

    public static String getValue(String text, String ... path) {
        StringBuilder text1 = new StringBuilder(text);
        try {
            for (int i = 0; i < path.length; ++i) {
                StringBuilder value = new StringBuilder();
                path[i] = "\"" + path[i] + "\"";
                int index = text1.indexOf(path[i]);
                if (index == -1) {
                    return null;
                }
                index += path[i].length() + 1;
                boolean bl = false;
                while (text1.charAt(index) != '{' && text1.charAt(index) != '[') {
                    if (text1.charAt(index) == ',' || text1.charAt(index) == ']' || text1.charAt(index) == '}') {
                        bl = true;
                        break;
                    }
                    value.append(text1.charAt(index));
                    ++index;
                }
                if (bl) {
                    char[] chars = value.toString().toCharArray();
                    Object val = "";
                    for (int d = 0; d <= chars.length - 1; ++d) {
                        if (chars[d] == '\"') continue;
                        val = (String)val + Character.toString(chars[d]);
                    }
                    text1 = new StringBuilder(((String)val).trim());
                    break;
                }
                value = new StringBuilder();
                Character symbol = Character.valueOf(text1.charAt(index));
                Character symbol2 = symbol.equals(Character.valueOf('[')) ? Character.valueOf(']') : (symbol.equals(Character.valueOf('{')) ? Character.valueOf('}') : null);
                value.append(symbol);
                ++index;
                int k = 1;
                Object string = "";
                string = (String)string + symbol;
                while (k != 0) {
                    if (symbol.equals(Character.valueOf(text1.charAt(index)))) {
                        ++k;
                    }
                    if (symbol2.equals(Character.valueOf(text1.charAt(index)))) {
                        --k;
                    }
                    string = (String)string + text1.charAt(index);
                    ++index;
                }
                text1 = new StringBuilder((String)string);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | StringIndexOutOfBoundsException e) {
            return null;
        }
        return text1.toString();
    }
}

