/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem;

import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class ConfigKeys {
    private static final ArrayList<Codec<?>> CODECS = new ArrayList();
    public static final Codec<Boolean> PAIN_KEEPS_AWAKE = ConfigKeys.add(new Codec<Boolean>("pain_keeps_awake", true));
    public static final Codec<Boolean> CRAWL_DELAY = ConfigKeys.add(new Codec<Boolean>("crawl_delay", true));
    public static final Codec<Boolean> TIME_HUD = ConfigKeys.add(new Codec<Boolean>("time_hud", true));
    public static final Codec<Boolean> HEALTH_HUD = ConfigKeys.add(new Codec<Boolean>("health_hud", true));
    public static final Codec<Boolean> TEMP_DEPENDENCE_ON_Z_COORD = ConfigKeys.add(new Codec<Boolean>("temp_dependence_on_z_coord", true));
    public static final Codec<Boolean> FROZEN_OCEANS_IN_WINTER = ConfigKeys.add(new Codec<Boolean>("frozen_ocean_in_winter", false));
    public static final Codec<Float> TEMPERATURE_MULTIPLIER = ConfigKeys.add(new Codec<Float>("temperature_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> COLD_MULTIPLIER = ConfigKeys.add(new Codec<Float>("cold_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> DROWSINESS_MULTIPLIER = ConfigKeys.add(new Codec<Float>("drowsiness_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> THIRST_MULTIPLIER = ConfigKeys.add(new Codec<Float>("thirst_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> EXHAUSTION_MULTIPLIER = ConfigKeys.add(new Codec<Float>("exhaustion_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> WET_MULTIPLIER = ConfigKeys.add(new Codec<Float>("wet_multiplier", Float.valueOf(1.0f)));
    public static final Codec<Float> DAMAGE_MULTIPLIER = ConfigKeys.add(new Codec<Float>("damage_multiplier", Float.valueOf(1.1f)));
    public static final Codec<Float> MAX_SEASON_TEMPERATURE = ConfigKeys.add(new Codec<Float>("max_season_temperature", Float.valueOf(20.0f)));
    public static final Codec<Float> WIND_CHANCE = ConfigKeys.add(new Codec<Float>("wind_chance", Float.valueOf(0.33f)));
    public static final Codec<Float> SLEEPING_PILLS_SPEED = ConfigKeys.add(new Codec<Float>("sleeping_pills_speed", Float.valueOf(5.0E-4f)));
    public static final Codec<Float> COOLING_WORLD_MULTIPLIER = ConfigKeys.add(new Codec<Float>("cooling_world_multiplier", Float.valueOf(1.1f)));
    public static final Codec<Float> HEATING_WORLD_MULTIPLIER = ConfigKeys.add(new Codec<Float>("heating_world_multiplier", Float.valueOf(0.9f)));
    public static final Codec<Integer> MIN_HUNGER_FOR_SLEEP = ConfigKeys.add(new Codec<Integer>("min_hunger_for_sleep", 11));
    public static final Codec<Integer> HEAL_TIME = ConfigKeys.add(new Codec<Integer>("heal_time", 48000));
    public static final Codec<Integer> FOOD_HEAL_AMOUNT = ConfigKeys.add(new Codec<Integer>("food_heal_amount", 2));
    public static final Codec<Integer> UPDATE_FREQUENCY = ConfigKeys.add(new Codec<Integer>("update_frequency", 5));
    public static final Codec<Integer> MIN_DROWSINESS_FOR_SLEEP = ConfigKeys.add(new Codec<Integer>("min_drowsiness_for_sleep", 1));
    public static final Codec<Integer> INFECTION_TIME = ConfigKeys.add(new Codec<Integer>("infection_time", 6000));
    public static final Codec<Integer> AUTOSAVE_FREQUENCY = ConfigKeys.add(new Codec<Integer>("autosave_frequency", 1200));
    public static final Codec<Integer> HEALTH_HUD_X = ConfigKeys.add(new Codec<Integer>("health_hud_x", 10));
    public static final Codec<Integer> HEALTH_HUD_Y = ConfigKeys.add(new Codec<Integer>("health_hud_y", 30));
    public static final Codec<Integer> TIME_HUD_X = ConfigKeys.add(new Codec<Integer>("time_hud_x", 6));
    public static final Codec<Integer> TIME_HUD_Y = ConfigKeys.add(new Codec<Integer>("time_hud_y", 6));
    public static final JsonConfig CONFIG;

    private static void read() {
        PAIN_KEEPS_AWAKE.setValue(CONFIG.getBooleanValue(PAIN_KEEPS_AWAKE.getName()));
        CRAWL_DELAY.setValue(CONFIG.getBooleanValue(CRAWL_DELAY.getName()));
        TIME_HUD.setValue(CONFIG.getBooleanValue(TIME_HUD.getName()));
        HEALTH_HUD.setValue(CONFIG.getBooleanValue(HEALTH_HUD.getName()));
        TEMP_DEPENDENCE_ON_Z_COORD.setValue(CONFIG.getBooleanValue(TEMP_DEPENDENCE_ON_Z_COORD.getName()));
        FROZEN_OCEANS_IN_WINTER.setValue(CONFIG.getBooleanValue(FROZEN_OCEANS_IN_WINTER.getName()));
        TEMPERATURE_MULTIPLIER.setValue(CONFIG.getFloatValue(TEMPERATURE_MULTIPLIER.getName()));
        COLD_MULTIPLIER.setValue(CONFIG.getFloatValue(COLD_MULTIPLIER.getName()));
        DROWSINESS_MULTIPLIER.setValue(CONFIG.getFloatValue(DROWSINESS_MULTIPLIER.getName()));
        THIRST_MULTIPLIER.setValue(CONFIG.getFloatValue(THIRST_MULTIPLIER.getName()));
        EXHAUSTION_MULTIPLIER.setValue(CONFIG.getFloatValue(EXHAUSTION_MULTIPLIER.getName()));
        WET_MULTIPLIER.setValue(CONFIG.getFloatValue(WET_MULTIPLIER.getName()));
        DAMAGE_MULTIPLIER.setValue(CONFIG.getFloatValue(DAMAGE_MULTIPLIER.getName()));
        MAX_SEASON_TEMPERATURE.setValue(CONFIG.getFloatValue(MAX_SEASON_TEMPERATURE.getName()));
        WIND_CHANCE.setValue(CONFIG.getFloatValue(WIND_CHANCE.getName()));
        SLEEPING_PILLS_SPEED.setValue(CONFIG.getFloatValue(SLEEPING_PILLS_SPEED.getName()));
        COOLING_WORLD_MULTIPLIER.setValue(CONFIG.getFloatValue(COOLING_WORLD_MULTIPLIER.getName()));
        HEATING_WORLD_MULTIPLIER.setValue(CONFIG.getFloatValue(HEATING_WORLD_MULTIPLIER.getName()));
        MIN_HUNGER_FOR_SLEEP.setValue(CONFIG.getIntValue(MIN_HUNGER_FOR_SLEEP.getName()));
        HEAL_TIME.setValue(CONFIG.getIntValue(HEAL_TIME.getName()));
        FOOD_HEAL_AMOUNT.setValue(CONFIG.getIntValue(FOOD_HEAL_AMOUNT.getName()));
        UPDATE_FREQUENCY.setValue(CONFIG.getIntValue(UPDATE_FREQUENCY.getName()));
        MIN_DROWSINESS_FOR_SLEEP.setValue(CONFIG.getIntValue(MIN_DROWSINESS_FOR_SLEEP.getName()));
        INFECTION_TIME.setValue(CONFIG.getIntValue(INFECTION_TIME.getName()));
        AUTOSAVE_FREQUENCY.setValue(CONFIG.getIntValue(AUTOSAVE_FREQUENCY.getName()));
        HEALTH_HUD_X.setValue(CONFIG.getIntValue(HEALTH_HUD_X.getName()));
        HEALTH_HUD_Y.setValue(CONFIG.getIntValue(HEALTH_HUD_Y.getName()));
        TIME_HUD_X.setValue(CONFIG.getIntValue(TIME_HUD_X.getName()));
        TIME_HUD_Y.setValue(CONFIG.getIntValue(TIME_HUD_Y.getName()));
        CONFIG.clear();
        for (Codec<?> codec : CODECS) {
            CONFIG.add(codec);
        }
    }

    private static <T> Codec<T> add(Codec<T> codec) {
        CODECS.add(codec);
        return codec;
    }

    public static void initialize() {
    }

    static {
        try {
            File file = new File(System.getProperty("user.dir") + "\\config", "zomboidhealthsystem-1.3.4.json");
            boolean exists = file.exists();
            if (!exists && !file.createNewFile()) {
                System.err.println("failed to create a file " + file.getName() + ", ignoring");
            }
            CONFIG = new JsonConfig(file);
            if (!exists) {
                for (Codec<?> codec : CODECS) {
                    CONFIG.add(codec);
                }
            } else {
                ConfigKeys.read();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    CONFIG.save();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

