/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4050;

public final class Weather {
    private final WorldProperties properties;
    private long timeOfDay;
    private float worldTemperature;
    private final class_3218 world;
    private float wind;
    private boolean newDay = false;
    private Integer sleep = null;
    private int i = 0;

    public Weather(class_3218 world, WorldProperties properties) {
        this.world = world;
        this.properties = properties;
        this.timeOfDay = world.method_8532();
        this.worldTemperature = this.getSeasonTemperature();
    }

    void tick() {
        if (this.i++ > ModServer.UPDATE_FREQUENCY - 1 && this.properties.hasTemperature()) {
            this.update();
            this.i = 0;
        }
    }

    private void update() {
        this.timeOfDay = this.getWorld().method_8532() % 24000L;
        if (this.timeOfDay < (long)ModServer.UPDATE_FREQUENCY * 2L) {
            if (!this.newDay) {
                this.onNewDay();
                this.newDay = true;
            }
        } else {
            this.newDay = false;
        }
        if (this.properties.hasWind()) {
            for (class_1657 player : this.getWorld().method_18456()) {
                float wind = this.getWind(player);
                if (wind >= 1.0f) {
                    player.method_6092(new class_1293(ModStatusEffects.WIND, 60, (int)wind, false, false, true));
                    continue;
                }
                if (!player.method_6059(ModStatusEffects.WIND)) continue;
                player.method_6016(ModStatusEffects.WIND);
            }
        }
        if (!((class_1928.class_4310)this.getWorld().method_8450().method_20746(class_1928.field_19396)).method_20753()) {
            return;
        }
        if (this.properties.hasTemperature()) {
            this.worldTemperature = this.getTemperatureOnTimeOfDay(ModServer.UPDATE_FREQUENCY, (int)this.timeOfDay);
        }
    }

    private float getWind(class_2338 pos) {
        if (this.wind >= 1.0f && Util.isInOpenSpace(this.getWorld(), pos)) {
            return this.wind;
        }
        return 0.0f;
    }

    private float getWind(class_1657 player) {
        float wind = player.method_18376() != class_4050.field_18079 ? this.getWind(player.method_24515().method_10086(1)) : this.getWind(player.method_24515());
        return wind;
    }

    public float getTemperatureOnPos(class_2338 pos) {
        return this.getTemperatureOnPos(pos, (class_1959)this.getWorld().method_23753(pos).comp_349());
    }

    public float getTemperatureOnPos(class_2338 pos, class_1959 biome) {
        float temperatureBiome = biome.method_8712();
        float height = pos.method_10264() - 63;
        float d = ConfigKeys.TEMP_DEPENDENCE_ON_Z_COORD.getValue() != false ? (float)pos.method_10260() / 1000.0f : 0.0f;
        float t = this.getWorldTemperature() - height / 25.0f + d;
        if (temperatureBiome > 0.5f) {
            t += 10.0f * temperatureBiome;
        } else if (temperatureBiome < 0.15f) {
            temperatureBiome -= 0.15f;
            t += 15.0f * (temperatureBiome *= 3.0f);
        }
        return t;
    }

    public boolean doesNotSnow(class_2338 pos, class_1959 biome) {
        return this.getTemperatureOnPos(pos, biome) > 0.0f;
    }

    private float getTemperatureOnTimeOfDay(int ticks, int timeOfDay) {
        float temperature = this.worldTemperature;
        float average_temperature = this.getSeasonTemperature();
        float amount = 8.3333335E-4f * (float)ticks / (float)this.properties.getDayLengthMultiplier();
        float divisor = (float)Math.max(Math.pow(Math.abs((average_temperature - this.worldTemperature) / 2.0f), 2.0), 1.0);
        temperature = timeOfDay > 10000 ? (temperature -= temperature < average_temperature ? amount / divisor * ConfigKeys.COOLING_WORLD_MULTIPLIER.getValue().floatValue() : amount * ConfigKeys.COOLING_WORLD_MULTIPLIER.getValue().floatValue()) : (temperature += temperature > average_temperature ? amount / divisor * ConfigKeys.HEATING_WORLD_MULTIPLIER.getValue().floatValue() : amount * ConfigKeys.HEATING_WORLD_MULTIPLIER.getValue().floatValue());
        if (this.world.method_8419() && temperature > average_temperature - 5.0f) {
            temperature -= (temperature < average_temperature ? amount / divisor : amount) * 1.5f;
        }
        return temperature;
    }

    private void onNewDay() {
        if (this.properties.hasWind()) {
            this.wind = new Random().nextFloat(0.0f, 1.0f) < ConfigKeys.WIND_CHANCE.getValue().floatValue() ? new Random().nextFloat(0.0f, 10.0f) : 0.0f;
        }
    }

    public void onSleep() {
        if (this.sleep != null) {
            int ticks = 24000 - this.sleep;
            int timeOfDay = this.sleep;
            this.sleep = null;
            this.worldTemperature = this.getTemperatureOnTimeOfDay(ticks, timeOfDay);
            this.properties.addTicks(ticks);
        }
    }

    public float getSeasonTemperature() {
        return Weather.getSeasonTemperature(this.properties);
    }

    public float getWorldTemperature() {
        return this.worldTemperature;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public float getWind() {
        return this.wind;
    }

    public void setWind(float wing) {
        this.wind = wing;
    }

    public void setSleep(long sleep) {
        this.sleep = (int)(sleep % 24000L);
    }

    public void setWorldTemperature(float worldTemperature) {
        this.worldTemperature = worldTemperature;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder();
        builder.append("world_temperature", String.valueOf(this.getWorldTemperature()));
        builder.append("wind", String.valueOf(this.getWind()));
        return builder.get();
    }

    public static float getSeasonTemperature(WorldProperties properties) {
        float temp;
        int durationYear = properties.getDaysInSeason() * 24000 * 4;
        int duration = properties.getDaysInSeason() * 24000;
        int time = properties.getTicks();
        float MAX_TEMP = ConfigKeys.MAX_SEASON_TEMPERATURE.getValue().floatValue();
        time = (time %= durationYear) >= duration / 2 ? (time -= duration / 2 + 1) : durationYear - duration / 2 + time + 1;
        float divisor = 27.0f / MAX_TEMP;
        if (time > durationYear / 2) {
            int d = (time %= durationYear / 2) / (duration / 28);
            temp = MAX_TEMP * -1.0f;
            temp += (float)d / divisor;
        } else {
            int d = (time %= durationYear / 2) / (duration / 28);
            temp = MAX_TEMP;
            temp -= (float)d / divisor;
        }
        return temp;
    }

    public static Weather parseWeather(class_3218 world, WorldProperties properties, String value) {
        Weather weather = new Weather(world, properties);
        try {
            weather.setWorldTemperature(Float.parseFloat(JsonConfig.getValue(value, "world_temperature")));
        }
        catch (Exception e) {
            throw new RuntimeException("error in world.data " + String.valueOf(e));
        }
        try {
            weather.setWind(Float.parseFloat(JsonConfig.getValue(value, "wind")));
        }
        catch (NullPointerException e) {
            weather.setWind(0.0f);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("error in world.data " + String.valueOf(e));
        }
        return weather;
    }
}

