/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import net.minecraft.class_1291;

public abstract class AbstractCondition {
    public static int UPDATE_EVERY_TICKS = 5;
    final Health health;

    public AbstractCondition(Health health) {
        this.health = health;
    }

    abstract class_1291 getEffect();

    public abstract float getAmount();

    public abstract void setAmount(float var1);

    public abstract String getName();

    public boolean hasIcon() {
        return this.getAmount() >= 1.0f;
    }

    public void update() {
        if (!this.hasIcon()) {
            this.getHealth().clearEffect(this.getEffect());
        } else {
            this.getHealth().updateStatusEffect(this.getEffect(), Math.min((int)this.getAmount(), 10));
        }
    }

    boolean random(int time) {
        return Health.random(time);
    }

    public String[][] getNbt() {
        String[][] strings = new String[1][2];
        strings[0][0] = this.getName();
        strings[0][1] = String.valueOf(this.getAmount());
        return strings;
    }

    public void readNbt(String text) {
        String value = JsonHelper.getValue(text, this.getName());
        if (value != null) {
            this.setAmount(Float.parseFloat(value));
        } else {
            this.setAmount(0.0f);
        }
    }

    public Health getHealth() {
        return this.health;
    }

    public String toString() {
        return super.toString();
    }
}

