/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import aiven.zomboidhealthsystem.infrastructure.config.JsonObject;
import java.io.IOException;

public class ServerConfig {
    private static ServerConfig INSTANCE = null;
    public final String minecraftDir;
    private JsonHelper helper;

    private ServerConfig(String minecraftDir) throws IOException {
        this.minecraftDir = minecraftDir;
        this.helper = new JsonHelper(new JsonObject(minecraftDir + "/config", "zomboidhealthsystem-server.json"));
        if (!this.helper.file().wasFile()) {
            this.helper.setDefault(new Codec[0]);
        }
    }

    public <T> Argument<T> addArgument(Codec<T> codec) {
        Argument<T> argument = new Argument<T>(codec, this.helper);
        if (this.helper != null && !this.helper.file().wasFile()) {
            try {
                this.helper.writeCodecsInConfig(codec);
                this.helper.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return argument;
    }

    public static void initialize() throws IOException {
        INSTANCE = new ServerConfig(Util.getMinecraftDirectory());
    }

    public static ServerConfig getInstance() {
        return INSTANCE;
    }

    public static class Argument<T> {
        private final Codec<T> codec;
        private final T defaultValue;
        private final JsonHelper helper;

        private Argument(Codec<T> codec, JsonHelper helper) {
            this.codec = codec;
            this.defaultValue = codec.getValue();
            this.helper = helper;
        }

        public void setValue(T value) {
            try {
                this.codec.setValue(value);
                this.helper.writeCodecsInConfig(this.codec);
                this.helper.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getStringValue() {
            try {
                String val = this.helper.getValue(this.codec);
                if (val != null) {
                    return val;
                }
                return this.defaultValue.toString();
            }
            catch (Exception e) {
                return this.defaultValue.toString();
            }
        }

        public Float getFloatValue() {
            return Float.valueOf(Float.parseFloat(this.getStringValue()));
        }

        public Double getDoubleValue() {
            return Double.parseDouble(this.getStringValue());
        }

        public Integer getIntegerValue() {
            return Integer.parseInt(this.getStringValue());
        }

        public Boolean getBooleanValue() {
            return Boolean.parseBoolean(this.getStringValue());
        }
    }
}

