/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player;

import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.foundation.items.BandageItem;
import aiven.zomboidhealthsystem.foundation.network.PacketId;
import aiven.zomboidhealthsystem.foundation.network.ServerNetwork;
import aiven.zomboidhealthsystem.foundation.player.HungerHelper;
import aiven.zomboidhealthsystem.foundation.player.Temperature;
import aiven.zomboidhealthsystem.foundation.player.conditions.AbstractCondition;
import aiven.zomboidhealthsystem.foundation.player.conditions.Cold;
import aiven.zomboidhealthsystem.foundation.player.conditions.Drowsiness;
import aiven.zomboidhealthsystem.foundation.player.conditions.Exhaustion;
import aiven.zomboidhealthsystem.foundation.player.conditions.Pain;
import aiven.zomboidhealthsystem.foundation.player.conditions.Thirst;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.util.HashMap;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class Health {
    private static final int HEAD_CHANCE_HIT = 24;
    private static final int BODY_CHANCE_HIT = 30;
    private static final int ARMS_CHANCE_HIT = 30;
    private static final int LEGS_CHANCE_HIT = 16;
    private static final int FOOTS_CHANCE_HIT = 0;
    public static final String HEAD_ID = "head";
    public static final String BODY_ID = "body";
    public static final String LEFT_ARM_ID = "left_arm";
    public static final String RIGHT_ARM_ID = "right_arm";
    public static final String LEFT_LEG_ID = "left_leg";
    public static final String RIGHT_LEG_ID = "right_leg";
    public static final String LEFT_FOOT_ID = "left_foot";
    public static final String RIGHT_FOOT_ID = "right_foot";
    public static final int MAX_HEAD_HP = 4;
    public static final int MAX_BODY_HP = 6;
    public static final int MAX_ARM_HP = 4;
    public static final int MAX_LEG_HP = 4;
    public static final int MAX_FOOT_HP = 4;
    public static final int BANDAGE_HEAL_TIME = 36000;
    public static final int BANDAGE_BECOME_DIRTY_AFTER = 2400;
    public static final int UPDATE_EVERY_TICKS = 5;
    public static final int INFECTION_TIME = 6000;
    public static final int PLAYER_FALLING_IF_AMPLIFIER = 4;
    public static final int MAX_SLOWNESS_AMPLIFIER = 4;
    public static final int MAX_AMPLIFIER = 10;
    public class_1657 user;
    public final BodyPart[] bodyParts;
    final AbstractCondition[] conditions;
    public HashMap<String, BodyPart> partHashMap = new HashMap();
    public Head head;
    public Body body;
    public Arm leftArm;
    public Arm rightArm;
    public Leg leftLeg;
    public Leg rightLeg;
    public Foot leftFoot;
    public Foot rightFoot;
    private float slownessAmplifier = 0.0f;
    private float fatigueAmplifier = 0.0f;
    private int absorption = 0;
    public boolean isDead = false;
    public float playerHp = 100.0f;
    public final Pain pain;
    public final Drowsiness drowsiness;
    public final Thirst thirst;
    public final Exhaustion exhaustion;
    public final Temperature temperature;
    public final HungerHelper hunger;
    public final Cold cold;
    private int i = 0;

    public Health(class_1657 user) {
        this(user, 4.0f, 6.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f);
    }

    public Health(class_1657 user, float headHp, float bodyHp, float leftArmHp, float rightArmHp, float leftLegHp, float rightLegHp, float leftFootHp, float rightFootHp) {
        this.user = user;
        this.head = new Head(this, headHp, user, HEAD_ID);
        this.body = new Body(this, bodyHp, user, BODY_ID);
        this.leftArm = new Arm(this, leftArmHp, user, LEFT_ARM_ID);
        this.rightArm = new Arm(this, rightArmHp, user, RIGHT_ARM_ID);
        this.leftLeg = new Leg(this, leftLegHp, user, LEFT_LEG_ID);
        this.rightLeg = new Leg(this, rightLegHp, user, RIGHT_LEG_ID);
        this.leftFoot = new Foot(this, leftFootHp, user, LEFT_FOOT_ID);
        this.rightFoot = new Foot(this, rightFootHp, user, RIGHT_FOOT_ID);
        this.bodyParts = new BodyPart[]{this.head, this.body, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot};
        this.partHashMap.put(HEAD_ID, this.head);
        this.partHashMap.put(BODY_ID, this.body);
        this.partHashMap.put(LEFT_ARM_ID, this.leftArm);
        this.partHashMap.put(RIGHT_ARM_ID, this.rightArm);
        this.partHashMap.put(LEFT_LEG_ID, this.leftLeg);
        this.partHashMap.put(RIGHT_LEG_ID, this.rightLeg);
        this.partHashMap.put(LEFT_FOOT_ID, this.leftFoot);
        this.partHashMap.put(RIGHT_FOOT_ID, this.rightFoot);
        this.pain = new Pain(this);
        this.drowsiness = new Drowsiness(this);
        this.thirst = new Thirst(this);
        this.exhaustion = new Exhaustion(this);
        this.temperature = new Temperature(this);
        this.hunger = new HungerHelper(this);
        this.cold = new Cold(this);
        this.conditions = new AbstractCondition[]{this.pain, this.drowsiness, this.thirst, this.exhaustion, this.cold};
    }

    public void tick() {
        if (this.i++ >= 5) {
            this.update();
            this.i = 0;
        }
    }

    public void applyEffects() {
        if (this.getPlayer().method_5805() && !this.getPlayer().method_7337()) {
            for (BodyPart part : this.bodyParts) {
                part.applyEffects();
                part.addAmplifier(this);
            }
            if (this.slownessAmplifier >= 4.0f) {
                this.getPlayer().method_18380(class_4050.field_18079);
            }
            if (this.slownessAmplifier > 4.0f) {
                this.slownessAmplifier = 4.0f;
            }
            this.updateStatusEffect(class_1294.field_5909, (int)this.slownessAmplifier);
            this.updateStatusEffect(class_1294.field_5901, (int)this.fatigueAmplifier);
            this.updateStatusEffect(class_1294.field_5911, (int)this.fatigueAmplifier);
            this.slownessAmplifier = 0.0f;
            this.fatigueAmplifier = 0.0f;
            if (this.getPlayer().method_6059(class_1294.field_5898)) {
                int dur = this.getPlayer().method_6112(class_1294.field_5898).method_5584();
                if (dur > this.absorption) {
                    int amplifier = this.getPlayer().method_6112(class_1294.field_5898).method_5578();
                    this.setAdditionalHp((float)amplifier * 2.0f);
                }
                this.absorption = dur;
            } else if (this.absorption != -1 && !this.getPlayer().method_6059(class_1294.field_5898)) {
                for (BodyPart part : this.bodyParts) {
                    if (part.getAdditionalHp() == 0.0f) continue;
                    part.setAdditionalHp(0.0f);
                }
                this.absorption = -1;
            }
            if (this.getPlayerHp() <= 0.0f) {
                this.onDeath(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)));
            }
            this.getPain().applyEffects();
        }
    }

    public void update() {
        if (this.getPlayer().method_5805() && !this.getPlayer().method_7337()) {
            for (BodyPart part : this.bodyParts) {
                part.update();
            }
            this.applyEffects();
            if (this.getPlayer().method_6059(class_1294.field_5924)) {
                int amplifier = this.getPlayer().method_6112(class_1294.field_5924).method_5578();
                this.healAllParts(((float)amplifier + 1.0f) / 100.0f * 5.0f);
                this.healPlayerHp(((float)amplifier + 1.0f) / 100.0f * 5.0f);
            }
            if (this.getSumBleeding() <= 3.0f && this.getPlayer().method_7344().method_7586() >= 19 && !this.haveInfection()) {
                this.healPlayerHp(0.015000001f);
            }
            for (AbstractCondition condition : this.conditions) {
                condition.update();
            }
            this.getTemperature().update();
        }
    }

    public void damageBodyParts(class_1282 source, float amount) {
        float damageAmount = (float)Util.floor(amount, 10);
        this.getPlayer().method_6066().method_5547(source, amount);
        if (this.getPlayer().method_5805() && this.isAlive()) {
            if (source.method_49708(class_8111.field_44869)) {
                this.onDeath(source);
            } else if (source.method_49708(class_8111.field_42342)) {
                int random = new Random().nextInt(0, 2);
                float d = random == 1 ? this.head.damage(amount / 10.0f, 0.0f) : this.body.damage(amount / 10.0f, 0.0f);
                if (d > 0.1f && this.importantBodyPartsAlive(source)) {
                    this.damageBodyParts(source, d);
                }
            } else if (Health.isPointDamage(source)) {
                float d = this.randomHit().damage(damageAmount);
                if (d > 0.1f && this.importantBodyPartsAlive(source)) {
                    this.damageBodyParts(source, d);
                }
            } else if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42339)) {
                BodyPart[] orderDamageBodyParts = new BodyPart[]{this.head, this.leftArm, this.rightArm, this.body, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot};
                float d = damageAmount / 2.0f;
                for (int i = 7; i != 0 && !(d < 0.2f); --i) {
                    int random = new Random().nextInt(0, 2);
                    BodyPart part = orderDamageBodyParts[i - random];
                    d = part.damage(d, 0.75f);
                }
            } else if (Health.isAllBodyDamage(source)) {
                for (BodyPart part : this.bodyParts) {
                    part.damage(damageAmount / (float)this.alivePartCount(), 0.75f);
                }
            } else {
                int random = new Random().nextInt(0, 8);
                float d = this.bodyParts[random].damage(amount);
                if (d > 0.2f && this.importantBodyPartsAlive(source)) {
                    this.damageBodyParts(source, d);
                }
            }
            this.applyEffects();
        }
    }

    private void damagePlayerHp(class_1282 source, float amount) {
        this.getPlayer().method_6066().method_5547(source, amount);
        if (amount > 0.0f) {
            this.setPlayerHp(this.getPlayerHp() - amount);
        }
    }

    public void healPlayerHp(float amount) {
        if (this.getPlayerHp() + amount < 100.0f) {
            this.setPlayerHp(this.getPlayerHp() + amount);
        } else {
            this.setPlayerHp(100.0f);
        }
    }

    public void healRandom(float amount) {
        int random;
        float d;
        if (!this.isFullHp() && (d = this.bodyParts[random = new Random().nextInt(0, 8)].heal(amount)) > 0.1f) {
            this.healRandom(d);
        }
    }

    public void healAllParts(float amount) {
        int i = 8;
        for (BodyPart part : this.bodyParts) {
            if (!part.isFullHp()) continue;
            --i;
        }
        if (i != 0) {
            for (BodyPart part : this.bodyParts) {
                part.heal(amount / (float)i);
            }
        }
    }

    public Pain getPain() {
        return this.pain;
    }

    public Drowsiness getDrowsiness() {
        return this.drowsiness;
    }

    public Thirst getThirst() {
        return this.thirst;
    }

    public Exhaustion getExhaustion() {
        return this.exhaustion;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public Cold getCold() {
        return this.cold;
    }

    public HungerHelper getHunger() {
        return this.hunger;
    }

    public void stumble(float damage) {
        if (!this.getPlayer().method_20448()) {
            int random = new Random().nextInt(6, 8);
            if (damage != 0.0f) {
                this.bodyParts[random].damage(damage, 0.0f);
            }
            this.getPlayer().method_18380(class_4050.field_18079);
            ModServer.getInstance().sendPacketDamage(this.getPlayer());
            this.getPlayer().method_37908().method_45447(null, this.getPlayer().method_24515(), class_3417.field_14904, class_3419.field_15254);
            this.addStatusEffect(class_1294.field_5919, 1, 60);
        }
    }

    public void stumble() {
        this.stumble(0.05f);
    }

    public void onSleep() {
        this.getDrowsiness().onSleep();
        this.getExhaustion().onSleep();
        this.getCold().onSleep();
        this.getTemperature().onSleep();
        this.getThirst().onSleep();
        this.getHunger().onSleep();
        for (BodyPart part : this.bodyParts) {
            part.onSleep();
        }
    }

    public void setAdditionalHp(float amount) {
        for (BodyPart part : this.bodyParts) {
            if (!(part.getAdditionalHp() < amount / 8.0f)) continue;
            part.setAdditionalHp(amount / 8.0f);
        }
    }

    public boolean importantBodyPartsAlive(class_1282 source) {
        boolean bl;
        boolean bl2 = bl = this.head.getHp() != 0.0f && this.body.getHp() != 0.0f;
        if (!bl && this.isAlive()) {
            this.onDeath(source);
        }
        return bl;
    }

    public float getSumHp() {
        float sum = 0.0f;
        for (BodyPart part : this.bodyParts) {
            sum += part.getHp() + part.getAdditionalHp();
        }
        return sum;
    }

    public float getSumBleeding() {
        float sum = 0.0f;
        for (BodyPart part : this.bodyParts) {
            sum += part.getBleeding();
        }
        return sum;
    }

    public int alivePartCount() {
        int count = 0;
        for (BodyPart part : this.bodyParts) {
            if (part.getHp() == 0.0f) continue;
            ++count;
        }
        return count;
    }

    public float getMaxSumHp() {
        float d = 0.0f;
        for (BodyPart part : this.bodyParts) {
            d += part.getMaxHp();
        }
        return d;
    }

    public void onDeath(class_1282 source) {
        if (this.isAlive()) {
            this.getPlayer().method_6066().method_5547(source, 0.0f);
            this.isDead = true;
            this.getPlayer().method_6033(0.0f);
            ServerNetwork.send(PacketId.ONDEATH, (class_3222)this.getPlayer(), PacketByteBufs.create());
            this.getPlayer().method_6078(source);
        }
    }

    public boolean isFullHp() {
        for (BodyPart part : this.bodyParts) {
            if (part.isFullHp()) continue;
            return false;
        }
        return true;
    }

    public class_1657 getPlayer() {
        return this.user;
    }

    public float getPlayerHp() {
        return this.playerHp;
    }

    public boolean isAlive() {
        return !this.isDead && this.getPlayer().method_5805();
    }

    public void setPlayerHp(float playerHp) {
        this.playerHp = playerHp;
    }

    public BodyPart[] getBodyParts() {
        return this.bodyParts;
    }

    public boolean haveInfection() {
        for (BodyPart part : this.bodyParts) {
            if (!part.isInfection()) continue;
            return true;
        }
        return false;
    }

    public BodyPart randomHit() {
        int random = new Random().nextInt(0, 101);
        if (random <= 24) {
            return this.head;
        }
        if (random <= 54) {
            return this.body;
        }
        if (random <= 69) {
            return this.leftArm;
        }
        if (random <= 84) {
            return this.rightArm;
        }
        if (random <= 92) {
            return this.leftLeg;
        }
        if (random <= 100) {
            return this.rightLeg;
        }
        if (random <= 100) {
            return this.leftFoot;
        }
        return this.rightFoot;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder("{", "}", 2);
        if (this.getPlayerHp() != 100.0f) {
            builder.append("\"player_hp\": " + this.playerHp);
        }
        for (AbstractCondition condition : this.conditions) {
            String[][] nbt;
            for (String[] values : nbt = condition.getNbt()) {
                if (values[1].equals("0.0") || values[1].equals("0")) continue;
                builder.append(values[0], values[1]);
            }
        }
        if (this.getTemperature().temperature != 36.6f) {
            builder.append("\"temperature\": " + this.getTemperature().getTemperature());
        }
        for (BodyPart part : this.bodyParts) {
            if (part.getHp() + part.getAdditionalHp() == part.getMaxHp() && !part.isBandaged() && !part.isBleeding() && part.infection <= 0) continue;
            builder.append("\"" + part.getName() + "\": ");
            JsonBuilder builder2 = new JsonBuilder("[", "]", 3);
            if (part.getHp() + part.getAdditionalHp() != part.getMaxHp()) {
                builder2.append("\"hp\": " + (part.getHp() + part.getAdditionalHp()));
            }
            if (part.isBandaged()) {
                builder2.append("\"bandage time\": " + part.getBandageTime());
                builder2.append("\"bandage item\": " + class_1792.method_7880((class_1792)part.getBandageItem()));
            }
            if (part.isBleeding()) {
                builder2.append("\"bleeding\": " + part.getBleeding());
            }
            if (part.getInfection() > 0) {
                builder2.append("\"infection\": " + part.getInfection());
            }
            builder.add(builder2.get());
        }
        return builder.get();
    }

    public void clearEffect(class_1291 effect) {
        if (this.getPlayer().method_6059(effect)) {
            this.getPlayer().method_6016(effect);
        }
    }

    public static Health parseHealth(class_1657 user, String text) {
        float[] hp = new float[8];
        float[] addHp = new float[8];
        String[] names = new String[]{HEAD_ID, BODY_ID, LEFT_ARM_ID, RIGHT_ARM_ID, LEFT_LEG_ID, RIGHT_LEG_ID, LEFT_FOOT_ID, RIGHT_FOOT_ID};
        float[] maxHps = new float[]{4.0f, 6.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f};
        String[][] strings = new String[8][5];
        float temperature = 36.6f;
        int f = 0;
        for (String id : names) {
            String text1 = JsonHelper.getValue(text, id);
            if (text1 != null) {
                strings[f] = Health.parseBodyPart(text1);
            }
            ++f;
        }
        String stringPlayerHp = JsonHelper.getValue(text, "player_hp");
        float player_hp = stringPlayerHp != null ? Float.parseFloat(stringPlayerHp) : 100.0f;
        String temperatureString = JsonHelper.getValue(text, "temperature");
        if (temperatureString != null) {
            temperature = Float.parseFloat(temperatureString);
        }
        for (int i = 0; i < 8; ++i) {
            String value = strings[i][0];
            if (value != null) {
                float val = Float.parseFloat(value);
                addHp[i] = val - maxHps[i];
                if (addHp[i] < 0.0f) {
                    addHp[i] = 0.0f;
                }
                hp[i] = val - addHp[i];
                continue;
            }
            addHp[i] = 0.0f;
            hp[i] = maxHps[i];
        }
        Health health = new Health(user, hp[0], hp[1], hp[2], hp[3], hp[4], hp[5], hp[6], hp[7]);
        for (int i = 0; i < 8; ++i) {
            health.bodyParts[i].setAdditionalHp(addHp[i]);
        }
        int dur = -1;
        if (user.method_6059(class_1294.field_5898)) {
            dur = user.method_6112(class_1294.field_5898).method_5584();
        }
        health.absorption = dur + 20;
        if (health.head.getHp() == 0.0f || health.body.getHp() == 0.0f) {
            health.isDead = true;
        }
        int p = 0;
        for (BodyPart part : health.getBodyParts()) {
            if (strings[p][1] != null) {
                part.setBandageTime((int)Float.parseFloat(strings[p][1]));
            } else {
                part.setBandageTime(0);
            }
            if (strings[p][2] != null) {
                part.setBleeding(Float.parseFloat(strings[p][2]));
            } else {
                part.setBleeding(0.0f);
            }
            if (strings[p][3] != null) {
                try {
                    part.setBandageItem((BandageItem)class_1792.method_7875((int)Integer.parseInt(strings[p][3])));
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("It can't be a bandage: " + strings[p][3] + " " + String.valueOf(class_1792.method_7875((int)Integer.parseInt(strings[p][3]))));
                }
            }
            if (strings[p][4] != null) {
                part.setInfection(Integer.parseInt(strings[p][4]));
            }
            ++p;
        }
        health.setPlayerHp(player_hp);
        health.getTemperature().setTemperature(temperature);
        for (AbstractCondition condition : health.conditions) {
            condition.readNbt(text);
        }
        return health;
    }

    public static String[] parseBodyPart(String text) {
        String[] arguments = new String[]{"hp", "bandage time", "bleeding", "bandage item", "infection"};
        String[] values = new String[arguments.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = JsonHelper.getValue(text, arguments[i]);
        }
        return values;
    }

    public void updateStatusEffect(class_1291 effect, int amplifier) {
        this.addStatusEffect(effect, amplifier, 300);
    }

    public void addStatusEffect(class_1291 effect, int amplifier, int duration) {
        Util.addStatusEffect(this.getPlayer(), effect, duration, amplifier);
    }

    public static boolean isAllBodyDamage(class_1282 source) {
        for (class_6862 class_68622 : new class_6862[]{class_8103.field_42249, class_8103.field_42243, class_8103.field_42246, class_8103.field_42252, class_8103.field_42253}) {
            if (!source.method_48789(class_68622)) continue;
            return true;
        }
        for (class_6862 class_68623 : new class_5321[]{class_8111.field_42349}) {
            if (!source.method_49708((class_5321)class_68623)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPointDamage(class_1282 source) {
        for (class_5321 t : new class_5321[]{class_8111.field_42321, class_8111.field_42360, class_8111.field_42323, class_8111.field_42319, class_8111.field_42344, class_8111.field_42320, class_8111.field_42325}) {
            if (!source.method_49708(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean random(int time) {
        return new Random().nextInt(0, time / 5) == 0;
    }

    public static class Head
    extends ImportartBodyPart {
        public Head(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        @Override
        void wasDamaged(float amount) {
            if (amount >= 1.0f) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5919, 200, 1);
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), amount * 5.0f);
            }
        }

        @Override
        public void addAmplifier(Health health) {
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }

        @Override
        public float getEffectAmplifierDivisor() {
            return 2.0f;
        }

        @Override
        public void update() {
            super.update();
            if (this.getMaxHp() / 2.0f >= this.getHp() && Health.random(3600)) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5919, 200, 1);
            }
        }
    }

    public static class Body
    extends ImportartBodyPart {
        public Body(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        @Override
        void wasDamaged(float amount) {
            if (amount >= 1.0f) {
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), amount * 5.0f);
            }
        }

        @Override
        public void addAmplifier(Health health) {
            health.slownessAmplifier += this.effectAmplifier;
        }

        @Override
        public float getMaxHp() {
            return 6.0f;
        }

        @Override
        public float getEffectAmplifierDivisor() {
            return 3.0f;
        }

        @Override
        public void update() {
            super.update();
            if (this.getMaxHp() / 2.0f >= this.getHp() && Health.random(3600)) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5916, 200, 1);
            }
        }
    }

    public static class Arm
    extends BodyPart {
        public Arm(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        @Override
        public void addAmplifier(Health health) {
            health.fatigueAmplifier += this.effectAmplifier;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }

        @Override
        public float getEffectAmplifierDivisor() {
            return 3.0f;
        }
    }

    public static class Leg
    extends BodyPart {
        public Leg(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        @Override
        public void addAmplifier(Health health) {
            health.slownessAmplifier += this.effectAmplifier;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }

        @Override
        public float getEffectAmplifierDivisor() {
            return 2.0f;
        }
    }

    public static class Foot
    extends BodyPart {
        public Foot(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        @Override
        public void addAmplifier(Health health) {
            health.slownessAmplifier += this.effectAmplifier;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }

        @Override
        public float getEffectAmplifierDivisor() {
            return 2.5f;
        }
    }

    public static abstract class BodyPart {
        private final Health health;
        private float hp;
        private float additionalHp = 0.0f;
        private final class_1657 player;
        public float effectAmplifier = 0.0f;
        private final String name;
        private int bandageTime = 0;
        private BandageItem bandageItem;
        private BandageItem lastBandageItem;
        private float bleeding = 0.0f;
        private int infection = 0;

        public BodyPart(Health health, float hp, class_1657 player, String name) {
            this.health = health;
            this.hp = hp;
            this.player = player;
            this.name = name;
        }

        public float heal(float amount) {
            if (!this.isFullHp()) {
                if (this.getHp() + amount > this.getMaxHp()) {
                    float d = this.getHp() + amount - this.getMaxHp();
                    this.setHp(this.getMaxHp());
                    return d;
                }
                this.setHp(this.getHp() + amount);
                return 0.0f;
            }
            return amount;
        }

        public float damage(float amount, float bleeding_chance) {
            float g;
            float random;
            if (amount <= this.getAdditionalHp()) {
                this.setAdditionalHp(this.getAdditionalHp() - amount);
                return 0.0f;
            }
            if (amount > this.getHp() + this.getAdditionalHp()) {
                float d = this.getHp() + this.getAdditionalHp();
                this.setAdditionalHp(0.0f);
                this.setHp(0.0f);
                this.setBleeding(2.5f);
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), amount - d);
                return amount - d;
            }
            this.hp -= amount - this.getAdditionalHp();
            this.setAdditionalHp(0.0f);
            if (bleeding_chance > 0.0f && (random = new Random().nextFloat(0.0f, g = 13.0f / ((amount + (this.getMaxHp() - this.getHp())) * bleeding_chance))) <= 5.0f) {
                this.setBleeding((this.getMaxHp() - this.getHp()) / 2.0f);
            }
            return 0.0f;
        }

        public float damage(float amount) {
            return this.damage(amount, 1.0f);
        }

        public void applyEffects() {
            if (this.getHp() < this.getMaxHp()) {
                this.effectAmplifier = (this.getMaxHp() - this.getHp()) / this.getEffectAmplifierDivisor();
            } else {
                this.effectAmplifier = 0.0f;
                this.setBleeding(0.0f);
            }
        }

        public void update() {
            this.applyEffects();
            if (this.isInfection()) {
                this.setInfection(this.getInfection() + 5);
                if (this.getInfection() > 12000) {
                    this.getHealth().updateStatusEffect(class_1294.field_5909, 1);
                    if (this.getInfection() > 18000) {
                        this.getHealth().updateStatusEffect(class_1294.field_5901, 1);
                        if (this.getInfection() > 24000) {
                            this.getHealth().updateStatusEffect(class_1294.field_5909, 2);
                            this.getHealth().updateStatusEffect(class_1294.field_5911, 1);
                            if (this.getInfection() > 30000) {
                                if (Health.random(2400)) {
                                    this.getHealth().stumble(0.0f);
                                }
                                if (Health.random(400)) {
                                    this.getHealth().addStatusEffect(class_1294.field_5916, 1, 140);
                                }
                                if (this.getInfection() > 36000) {
                                    if (Health.random(2400)) {
                                        this.getHealth().stumble(0.0f);
                                    }
                                    if (Health.random(400)) {
                                        this.getHealth().addStatusEffect(class_1294.field_5919, 1, 140);
                                    }
                                    if (this.getInfection() > 42000) {
                                        this.getHealth().updateStatusEffect(class_1294.field_5899, 1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.isBandaged()) {
                if (!this.isInfection()) {
                    this.heal(this.bandageItem.getHealAmount() / 36000.0f * 5.0f / (20.0f / (float)this.getPlayer().method_7344().method_7586()));
                }
                this.setBandageTime(this.getBandageTime() + 5);
                if (this.bandageItem.isDirty()) {
                    this.setInfection(this.getInfection() + 5);
                }
                if (this.bandageItem.stopBleeding()) {
                    if (this.isBleeding()) {
                        this.setBleeding(this.getBleeding() - 7.5E-4f);
                        if ((double)this.getBandageTime() > 2400.0 / ((double)this.getBleeding() + 0.5) / (double)this.bandageItem.dirtyDivisor()) {
                            this.setBandageItem(this.bandageItem.getDirtyBandageItem());
                        }
                    }
                } else {
                    this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), this.getBleeding() / 30.0f * 5.0f);
                }
            } else {
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), this.getBleeding() / 30.0f * 5.0f);
            }
        }

        public void bandage(BandageItem item) {
            this.bandageTime = 0;
            this.bandageItem = item;
            this.lastBandageItem = null;
        }

        public class_1792 unBandage() {
            this.bandageTime = 0;
            if (this.bandageItem != null) {
                this.lastBandageItem = this.bandageItem;
                this.bandageItem = null;
                return this.lastBandageItem;
            }
            return null;
        }

        public class_1792 getBandageItem() {
            return this.bandageItem;
        }

        public void setBandageItem(@Nullable BandageItem item) {
            if (item != null) {
                this.bandageItem = item;
            }
        }

        public void setBandageTime(int bandageTime) {
            this.bandageTime = Math.max(bandageTime, 0);
        }

        public int getBandageTime() {
            return this.bandageTime;
        }

        public boolean isBandaged() {
            return this.bandageItem != null;
        }

        public float getBleeding() {
            return this.bleeding;
        }

        public void setBleeding(float bleeding) {
            this.bleeding = Math.max(bleeding, 0.0f);
        }

        public boolean isBleeding() {
            return this.getBleeding() != 0.0f;
        }

        public boolean isInfection() {
            return this.getInfection() > 6000;
        }

        public void setInfection(int infection) {
            this.infection = Math.max(infection, 0);
        }

        public int getInfection() {
            return this.infection;
        }

        public void disInfect() {
            this.setInfection(this.getInfection() - 1200);
            if (!this.isInfection()) {
                this.setInfection(0);
            }
        }

        public void onSleep() {
            this.heal(0.5f);
            if (this.isBandaged()) {
                this.setBleeding(this.getBleeding() - 0.3f);
            }
        }

        public Health getHealth() {
            return this.health;
        }

        public float getHp() {
            return this.hp;
        }

        public void setHp(float hp) {
            this.hp = hp;
        }

        public void setAdditionalHp(float additionalHp) {
            this.additionalHp = additionalHp;
        }

        public float getAdditionalHp() {
            return this.additionalHp;
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public String getName() {
            return this.name;
        }

        public boolean isFullHp() {
            return this.getHp() >= this.getMaxHp();
        }

        public float getPain() {
            if (this.getHp() <= 0.2f) {
                return 5.0f;
            }
            float d = this.getMaxHp() - this.getHp();
            if (this.isBandaged()) {
                return d / 1.25f;
            }
            return d;
        }

        public abstract void addAmplifier(Health var1);

        public abstract float getMaxHp();

        public abstract float getEffectAmplifierDivisor();
    }

    private static abstract class ImportartBodyPart
    extends BodyPart {
        public ImportartBodyPart(Health health, float maxHp, class_1657 user, String name) {
            super(health, maxHp, user, name);
        }

        public void nullHp() {
            this.getHealth().onDeath(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.SEVERE_DAMAGE)));
        }

        @Override
        public void update() {
            super.update();
            if (this.getHp() == 0.0f) {
                this.nullHp();
            }
        }

        @Override
        public float damage(float amount) {
            this.wasDamaged(amount);
            return super.damage(amount);
        }

        abstract void wasDamaged(float var1);
    }
}

